#!/bin/sh
#------------------------------------------------------------------------------
# interface.cgi - set bit 0-7 of the parallel port
#
# Creation:     24.09.2001  by Johannes Hermen
#
# 
# Update: 31.01.2005 - Holger Frank 
# Update: 28.07.2012 - demlak
#
#------------------------------------------------------------------------------
# get main helper functions
. /srv/www/include/cgi-helper

# Security 
check_rights "status" "interface"

#------------------------------------------------------------------------------
# Config Variablen aus /var/run/interface.cfg auslesen
#------------------------------------------------------------------------------
# get config variables
. /var/run/interface.cfg


#-------------------------------------------------------------------------------------------------------------------------------------
# Seite aufbauen
#-------------------------------------------------------------------------------------------------------------------------------------
# um das layout zu ndern kann einfach alles auer den #-- Bit lesen --- Breichen gendert werden, wobei mit echo "hier html"
# einfach html code ausgegeben werden kann. zu beachten  ist , das Anfhrungszeichen im HTML code als \" geschrieben werden mssen
# z.B.  echo "<img scr=\"bla.gif\">"	 viel Spa damit.....
#-----------------------------------------
# Seitenkopf
#-----------------------------------------

if [ -z "$FORM_port" ]; then
   FORM_port="1"
fi

show_html_header "Interface an Parallelport: $FORM_port" "refresh=$INTERFACE_TIMER;url=${myname}?port=$FORM_port"

for idx in `seq 1 $INTERFACE_PORT_N`
 do
   # get label defined in config file
    eval 'label=$INTERFACE_PORT_'$idx'_NAME'
   # html escape special chars in label
    label="`echo \"${label}\" | htmlspecialchars`"
   # concatinate string for show_tab_header function
   # and choose whether tab is active or inactive
   [ "$idx" != "$FORM_port" ] \
    && maintabs="${maintabs}\"${label}\" \"${myname}?port=${idx}\" " \
    || maintabs="${maintabs}\"${label}\" \"no\" "
 done
eval "show_tab_header $maintabs"

#--Status--------------------------------------------

   _opt_status="Status"
   _opt_controlcenter="Controlcenter"
   _opt_help="Hilfe"

   echo '<div style="float: left; margin-right: 50px">'

   show_tab_header "$_opt_status" no
   echo '<br>'
   echo "<table class=\"normtable\"><tr><th>Status</th><th>Beschreibung des angeschlossen Gertes</th></tr>"

for idl in `seq 1 5`
   do
	echo "<tr><th>"
	#--- Status Bit lesen ----------------------------------------
	eval port=\$INTERFACE_PORT_${FORM_port}
	if [ `/usr/local/bin/lptkeys -p $port -f | cut -c ${idl}` = "1" ]
        then   echo "<img src="../img/interface_statuson.gif" align=middle border=0>"
        else echo "<img src="../img/interface_statusoff.gif" align=middle border=0>"
	fi
	#--- Ende Bit lesen ------------------------------------
	eval 'echo \</th\>\<th\>$INTERFACE_'$FORM_port'_IN_DEV_'${idl}'_DESCR\</th\>\</tr\>'
   done

	echo '</TD></table>' 
	echo "<br><h4>Aktualisierung alle $INTERFACE_TIMER Sekunden</h4>"
	show_tab_footer
	echo '</div>'

#----Controlcenter------------------------
	
#------------------------------------------------------------------------------
# Ports Schalten
#------------------------------------------------------------------------------

port=$FORM_port
case $FORM_bit in
   allon)  eval '/usr/local/bin/k74a -p $INTERFACE_PORT_'$FORM_port' write 255' ;;
   alloff) eval '/usr/local/bin/k74a -p $INTERFACE_PORT_'$FORM_port' write 0' ;;
   [0-7]) eval '/usr/local/bin/k74a -p $INTERFACE_PORT_'$FORM_port' $FORM_bit toggle' ;;
esac

#----------------------------------------------------------------------------------------
# Ende Ports schalten
#----------------------------------------------------------------------------------------

show_tab_header "$_opt_controlcenter" no
echo "<a href="interface.cgi?port=$FORM_port\&bit=alloff">alle-off</a>   <a href="interface.cgi?port=$FORM_port\&bit=allon">alle-on</a>"

#--------------------------------
# Tabelle
#--------------------------------
	
   echo "<table class=\"normtable\"><tr><h3><th>Port:</th><th><center>1</th><th ><center>2</th><th ><center>3</th><th ><center>4</th><th ><center>5</th><th ><center>6</th><th ><center>7</th><th ><center>8</th></h3></tr>"
   echo "<tr><th><h4><center>Status:</h4></th>"

for idb in `seq 0 7`
do
   echo "<th>"
	#--- Bit lesen ----------------------------------------
	eval 'readbit=`/usr/local/bin/k74a -p $INTERFACE_PORT_'$FORM_port' $idb read`'
	if [ $readbit = "1" ]
	  then echo "<a href="interface.cgi?port=$FORM_port\&bit=${idb}"><img src="../img/interface_on.gif" align=middle border=0><br clear=all><center>on"
	  else echo "<a href="interface.cgi?port=$FORM_port\&bit=${idb}"><img src="../img/interface_off.gif" align=middle border=0><br clear=all><center>off"
	fi
	#--- Ende Bit lesen ------------------------------------
   echo "</th>"
done

#-----------------------------------------------------------
# Tabellenende 
#-----------------------------------------------------------

echo "</tr></table>"

echo \<h4\>Beschreibung\</h4\>

for idd in `seq 1 8`
do
   eval 'echo Port ${idd}: $INTERFACE_'$FORM_port'_OUT_DEV_'${idd}'_DESCR\<br\>'
done

show_tab_footer

echo "<br>" 

#show_tab_header "$_opt_help" no
#    echo "<br>Written by Johannes Hermen<br>www.fsai.fh-trier.de/~hermenj<br><br>Version fr 3.0.0 angepasst von Holger Frank - support ber Newsgroup<br>#<br>"
#show_tab_footer

show_html_footer
#-Ende-Design-------------------------------------------------------------------------------------------------------------