//#include <sys/io.h>
#include <asm/io.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <limits.h>
#include <errno.h>
#include <signal.h>
#include <getopt.h>

#define PROGVERS "0.0.3"

int got_signal=0;
static unsigned short Port=0x378;
int out_format=0;
unsigned short Mask=0x1F;

/*
 * 13.06.2001 - Axel Ehnert axel@ehnert.net
 *
 * Added KEYTAB, Keytab
 * get_key and handle_key to handle 5 connected switches.
 * switches are connected as:
 *
 * ERROR - Pin 15 - Key 1
 * SLCT  - Pin 13 - Key 2
 * PE    - Pin 12 - Key 3
 * ACK   - Pin 10 - Key 4
 * BUSY  - Pin 11 - Key 5
 *
 * Edited: 04.07.01
 *         Added switch -f (force - no loop)
 *
 */

int get_key (void)
{
  unsigned char bits=0;

  bits=inb(Port+1);
  bits=~(bits^0x80) & 0xf8;
//             ^       ^
//  BUSY is inverted   mask 3 low bits

// Shift bits to right

  bits=bits>>3;

// Mask the bits

  bits=bits & Mask;

  return (bits);
}

int handle_key (int *taste)
{
  int i;
  if ( out_format == 0 ) {
    printf ("%d%d%d%d%d\n",
                   *taste & 0x01,
                   *taste >> 1 & 0x01,
                   *taste >> 2 & 0x01,
                   *taste >> 3 & 0x01,
                   *taste >> 4 & 0x01
           );
  }
  else {
    printf ("%d\n", (*taste & 0x10)/16 * 5 +
                    (*taste & 0x08)/8 * 4 +
                    (*taste & 0x04)/4 * 3 +
                    (*taste & 0x02) +
                    (*taste & 0x01));
  }
}

void handler (int signal)
{
  got_signal=signal;
}

void usage ()
{
  printf ("\nUsage: lptkeys [-5] [-c] [-f] [-h] [-v] [-n] [-m 0x..] [-p 0x378|0x278|0x3bc]\n"
"                -5 set +5V on pin 17 (SELECT PRINTER)\n"
"                   without this switch: don't touch pin 17\n"
"                -c shows an example circuit\n"
"                -f report current status - do not wait for key pressed\n"
"                -h shows help and exits\n"
"                -m mask the lines according to 0x.. \n"
"                   the bitmask accords to the default output\n"
"                   format\n"
"                -v shows version and exits\n"
"                -p use given IO port\n"
"                -n output key as number rather then binary\n\n");
}

void version ()
{
  printf ("\nlptkeys Version: %s\n(C) Axel Ehnert, 2001\n\n", PROGVERS);
}

void circuit ()
{
  printf ("\nDB25  Pinname                5 x 4,7k\n"
"                             _____\n"
"15    ERROR    ---------o----|___|--------o +5V\n"
"                        /\n"
"                        o\n"
"               S1       |\n"
"                        -\n"
"                             _____\n"
"13    SLCT     ---------o----|___|--------o +5V\n"
"                        /\n"
"                        o\n"
"               S2       |\n"
"                        -\n"
"                             _____\n"
"12    PE       ---------o----|___|--------o +5V\n"
"                        /\n"
"                        o\n"
"               S3       |\n"
"                        -\n"
"                             _____\n"
"10    ACK      ---------o----|___|--------o +5V\n"
"                        /\n"
"                        o\n"
"               S4       |\n"
"                        -\n"
"                             _____\n"
"11    BUSY     ---------o----|___|--------o +5V\n"
"                        /\n"
"                        o\n"
"               S5       |                 ^\n"
"                        -                 |\n"
"                                          |\n"
"17    SLCT PRI ---------------------------+ +5V \n\n");

  printf ("NO WARRANTY FOR DAMAGES OF YOUR HARDWARE!!!\n\n");
}

int main (int argc, char *argv[])
{
  int taste=0;
  int otaste=0;
  int force=0;
  int set5v=0;
  char c;
  char *s, *e;

  while ((c=getopt (argc, argv, "5cfhm:np:v"))!=EOF) {
    switch (c) {
    case 'c':
      circuit();
      exit(0);
    case 'h':
      usage();
      exit(0);
    case 'v':
      version();
      exit(0);
    case 'n':
      out_format++;
      break;
    case '5':
      set5v++;
      break;
    case 'f':
      force++;
      break;
    case 'm':
      s=optarg;
      if ((Mask=strtol(s, &e, 0))==0 || *e!='\0') {
        fprintf (stderr, "lptkeys: bad mask '%s'\n", s);
        exit (-1);
      }
// 1->5 2->4 4->2 5->1
      Mask = (Mask & 0x10)/16 +
             (Mask & 0x08)/8 * 2 +
             (Mask & 0x04)/4 * 4 +
             (Mask & 0x02)/2 * 8 +
             (Mask & 0x01) * 16;
      break;
    case 'p':
      s=optarg;
      if ((Port=strtol(s, &e, 0))==0 || *e!='\0') {
        fprintf (stderr, "lptkeys: bad port '%s'\n", s);
        exit (-1);
      }
      if (Port!=0x278 && Port!=0x378 && Port!=0x3bc) {
        fprintf (stderr, "lptkeys: Port may only be 0x378 (lpt1)\n"
"                          0x278 (lpt2)\n"
"                          0x3bc (lpt3)!\n");
        exit (-1);
      }
      break;
    default:
      exit(2);
    }
  }

  // now install our own signal handler
  signal(SIGHUP,  handler);
  signal(SIGINT,  handler);
  signal(SIGQUIT, handler);
  signal(SIGTERM, handler);

  if (ioperm(Port, 3, 1)!=0) {
    fprintf (stderr, "lptkeys: ioperm(0x%x) failed: %s", Port, strerror(errno));
    return -1;
  }

  if (set5v==1) {
    outb (0x00, Port+2);
  }

  if (force==0) {
    while (got_signal==0 && taste==otaste) {
      taste=get_key();
      if (taste!=0) {
        handle_key (&taste);
      }
      usleep (10000);
    }
  }
  else {
    taste=get_key();
    handle_key (&taste);
  }

  if (ioperm(Port, 3, 0)!=0) {
    fprintf (stderr, "lptkeys: ioperm(0x%x) failed: %s", Port, strerror(errno));
    return -1;
  }

}
