#!/bin/sh
##------------------------------------------------------------------------------
## local: opt\files\srv\www\admin\my_link.cgi
## fli4l: srv/www/admin/my_link.cgi
## DE: OPT_HTTPD Webadmin Webseite fr My Link
## EN: OPT_HTTPD webadmin page for My Link
##------------------------------------------------------------------------------
##      Creation:  31.12.2005  V0.6.1 Manfred Schliesing <ms1958@web.de>
##      modified:  23.09.2008  V0.6.4 Florian Schlgl    <Florian_Schloegl.Wolfsteam@web.de>
## Last modified:  04.12.2011  V0.6.6 Manfred Schliesing <ms1958@web.de> 
##                             (Anpassung an FLI4L 3.7.0)
##------------------------------------------------------------------------------
## Files:	/var/run/mylink.conf
## 		$MYLINK_DATA_PATH/mylink_links.conf
##------------------------------------------------------------------------------
. /srv/www/include/cgi-helper
. /var/run/my_link.conf

# DE: Rechte kontollieren
# EN: check rights
: ${FORM_action:=view}
check_rights "mylink" "$FORM_action"

# HTML-Header ausgeben
show_html_header "My Link"

# Haupttab ausgeben
show_tab_header "Links" no

case $FORM_action in
	#----------------------------------------
	# DE: Link hinzufgen
	# EN: add link
	#----------------------------------------
	add)
		case $FORM_url in
			"")
				show_error "$_error_header" "$_error_no_url"
			echo "<CENTER><A href=\"$myname\">$_cmd_go_back</A></CENTER>
<META http-equiv=\"refresh\" content=\"5; URL=$myname\">"
			;;
			
			*)
				case $FORM_text in
					"")
					FORM_text=$FORM_url
					;;
				esac
				
				#----------------------------------------
				# DE: alte Links einlesen
				# EN: read old links
				#----------------------------------------
				if [ -f $MY_LINK_DATA_PATH/mylink_links.conf ]
				then
					. $MY_LINK_DATA_PATH/mylink_links.conf
				else
					MY_LINK_N=0
				fi
				
				[ $MY_LINK_N ] || MY_LINK_N=0
				
				#----------------------------------------
				# DE: Link hinzufgen
				# EN: add link
				#----------------------------------------
				MY_LINK_N=`expr $MY_LINK_N + 1`
				
				eval 'MY_LINK_'$MY_LINK_N'_URL'=$FORM_url
				eval 'MY_LINK_'$MY_LINK_N'_TEXT'='$FORM_text'
				eval 'MY_LINK_'$MY_LINK_N'_COMMENT'='$FORM_comment'
				
				#----------------------------------------
				# DE: Links speichern
				# EN: save links
				#----------------------------------------
				{
					echo "MY_LINK_N='$MY_LINK_N'"
					for idx in `seq 1 $MY_LINK_N`
					do
						eval mylink_url='$MY_LINK_'$idx'_URL'
						echo "MY_LINK_"$idx"_URL='$mylink_url'"
						eval mylink_text='$MY_LINK_'$idx'_TEXT'
						if [ $mylink_text = "" ]
						then
							mylink_text=$mylink_url
						fi
						echo "MY_LINK_"$idx"_TEXT='$mylink_text'"
						eval mylink_comment='$MY_LINK_'$idx'_COMMENT'
						echo "MY_LINK_"$idx"_COMMENT='$mylink_comment'"
					done
				} > $MY_LINK_DATA_PATH/mylink_links.conf
				
				#----------------------------------------
				# DE: Ausgabe: Link hinzugefgt
				# EN: print success result
				#----------------------------------------
				show_info "$_add_link_header" "$_add_link_link_added"
			echo "<CENTER><A href=\"$myname\">$_cmd_go_back</A></CENTER>
<META http-equiv=\"refresh\" content=\"5; URL=$myname\">"
			;;
		esac
	;;
	
	#----------------------------------------
	# DE: Link lschen
	# EN: delete link
	#----------------------------------------
	delete)
		#----------------------------------------
		# DE: alte Links einlesen
		# EN: read old links
		#----------------------------------------
		if [ -f $MY_LINK_DATA_PATH/mylink_links.conf ]
		then
			. $MY_LINK_DATA_PATH/mylink_links.conf
		else
			MY_LINK_N=0
		fi
		
		if [ "$FORM_number" -le "$MY_LINK_N" -o "$FORM_number" = "$MY_LINK_N" ]
		then
			#----------------------------------------
			# DE: Links lschen und speichern
			# EN: delete link and save them
			#----------------------------------------
			numberless1=`expr $FORM_number - 1`
			MY_LINK_N=`expr $MY_LINK_N - 1`
			
			{
				echo "MY_LINK_N='$MY_LINK_N'"
				
				# DE: Links bis zum gelschten
				# EN: links up to the one to delete
				for idx in `seq 1 $numberless1`
				do
					eval mylink_url='$MY_LINK_'$idx'_URL'
					echo "MY_LINK_"$idx"_URL='$mylink_url'"
					eval mylink_text='$MY_LINK_'$idx'_TEXT'
					echo "MY_LINK_"$idx"_TEXT='$mylink_text'"
					eval mylink_comment='$MY_LINK_'$idx'_COMMENT'
					echo "MY_LINK_"$idx"_COMMENT='$mylink_comment'"
				done
				
				# DE: Links ab den gelschten
				# EN: links till the end
				for idx in `seq $FORM_number $MY_LINK_N`
				do
					idx2=`expr $idx + 1`
					
					eval mylink_url='$MY_LINK_'$idx2'_URL'
					echo "MY_LINK_"$idx"_URL='$mylink_url'"
					eval mylink_text='$MY_LINK_'$idx2'_TEXT'
					echo "MY_LINK_"$idx"_TEXT='$mylink_text'"
					eval mylink_comment='$MY_LINK_'$idx2'_COMMENT'
					echo "MY_LINK_"$idx"_COMMENT='$mylink_comment'"
				done
			} > $MY_LINK_DATA_PATH/mylink_links.conf
			
			#----------------------------------
			# DE: Link gelscht ausgabe
			# EN: print that link is deleted
			#----------------------------------
			eval mylink_url='$MY_LINK_'$FORM_number'_URL'
			eval mylink_text='$MY_LINK_'$FORM_number'_TEXT'
			eval mylink_comment='$MY_LINK_'$FORM_number'_COMMENT'
			show_info "$_delete_link_header" "$_delete_link_link_deleted<BR><BR><A HREF=\"$mylink_url\">$mylink_text</A>"
			echo "<CENTER><A href=\"$myname\">$_cmd_go_back</A></CENTER>
<META http-equiv=\"refresh\" content=\"5; URL=$myname\">"
			
		else
			#----------------------------------
			# DE: ungltige Nummer
			# EN: invalid number
			#----------------------------------
			show_error "$_error_header" "$_error_invalid_number"
			echo "<CENTER><A href=\"$myname\">$_cmd_go_back</A></CENTER>
<META http-equiv=\"refresh\" content=\"5; URL=$myname\">"
		fi
	;;
	
	#----------------------------------------
	# DE: Liste ausgeben
	# EN: print list
	#----------------------------------------
	view)
		#----------------------------------------
		# DE: Tabellenkopf ausgeben
		# EN: print table header
		#----------------------------------------
		echo "<TABLE class=\"normtable\">
		  <TR>
		    <TH align=\"center\">$_table_header_number</TH>
		    <TH align=\"left\">$_table_header_link</TH>
		    <TH align=\"left\">$_table_header_comment</TH>
		    <TH align=\"left\">$_table_header_action</TH>
		  </TR>"

		#----------------------------------------
		# DE: Links ausgeben
		# EN: print links
		#----------------------------------------
		if [ -f $MY_LINK_DATA_PATH/mylink_links.conf ]
		then
			. $MY_LINK_DATA_PATH/mylink_links.conf
		#if [ $MY_LINK_N -gt 0 ]
		#then
			for idx in `seq 1 $MY_LINK_N`
			do
				eval mylink_url='$MY_LINK_'$idx'_URL'
				eval mylink_text='$MY_LINK_'$idx'_TEXT'
				eval mylink_comment='$MY_LINK_'$idx'_COMMENT'

				echo "  <TR>
    <TD align=\"center\"><A href=\"/admin/index.cgi?link=$mylink_url\">$idx</A></TD>
    <TD align=\"left\"><A href=\"$mylink_url\">$mylink_text</A></TD>
    <TD align=\"left\">$mylink_comment</TD>
    <FORM action=\"$myname\" method=\"get\"><TD align=\"center\">
      <INPUT type=\"hidden\" name=\"action\" value=\"delete\">
      <INPUT type=\"hidden\" name=\"number\" value=\"$idx\">
      <INPUT type=\"submit\" value=\"$_table_action_delete\" class=\"actions\"></TD>
    </FORM>
  </TR>"
			done
		fi

		#----------------------------------------
		# DE: Neue Links hinzufgen
		# EN: Add new links
		#----------------------------------------
			echo "  <FORM action=\"$myname\" method=\"get\"><TR>
		    <TD><INPUT type=\"hidden\" name=\"action\" value=\"add\"></TD>
		    <TD align=\"left\">
		      <TABLE border=\"0\" width=\"100%\">
		        <TR><TD>$_table_add_url</TD><TD><INPUT type=\"text\" name=\"url\" value=\"http://\" width=\"100%\" style=\"width:100%\"></TD></TR>
		        <TR><TD>$_table_add_text</TD><TD><INPUT type=\"text\" name=\"text\" width=\"100%\" style=\"width:100%\"></TD></TR>
		      </TABLE>
		    </TD>
		    <TD align=\"left\"><INPUT type=\"text\" name=\"comment\" width=\"100%\" style=\"width:100%\"></TD>
		    <TD align=\"center\"><INPUT type=\"submit\" value=\"$_table_action_add\" class=\"actions\"></TD>
		  </TR></FORM>
		</TABLE>"
	;;
	
	#----------------------------------------
	# DE: Liste ausgeben
	# EN: print list
	#----------------------------------------
	view)
		echo "$_error_page_nonexist"
	;;
esac

#----------------------------------------
# DE: Ende des Dokuments ausgeben
# EN: print end of doc
#----------------------------------------
show_tab_footer
show_html_footer

