#!/bin/bash
#
# send ps file as faxformat to the fli4l into the send queue
#
# Variablen unbedingt an Deine Bedürfnisse anpassen
# ####### Anpassungsbereich Anfang ################
#
SCPSERVER="fli4l.mydomain.lan"
SCPUSER="root"
SCPFAXQUEUE="/tmp/sendFax"
#
FTPSERVER="$SCPSERVER"
FTPUSER="faxsend"
FTPPASS="FaxSenderPassword"
#
# ####### Anpassungsbereich Ende ##################
#
use_scp()
{
  scp -P 22 "/tmp/$FAXNO.sff" $SCPUSER@$SCPSERVER:$SCPFAXQUEUE/$FAXNO.$my_time.$$.sff
  my_rc=$?
}
#
use_ftp()
{
  # local: check ftp-errors in file
  FTPERRORS="/tmp/ftperrors.$$"
  # save .netrc if it exists
  if [ -s $HOME/.netrc ]
  then
    mv -f $HOME/.netrc $HOME/.netrc.$$
  fi
  echo "machine $FTPSERVER login $FTPUSER password $FTPPASS" > $HOME/.netrc
  chmod 600 $HOME/.netrc
  ( echo "send /tmp/$FAXNO.sff /$FAXNO.$my_time.$$.sff";
  echo "bye" ) | ftp $FTPSERVER 2>$FTPERRORS
  rm -f $HOME/.netrc
  # restore old .netrc
  if [ -s $HOME/.netrc.$$ ]
  then
    mv -f $HOME/.netrc.$$ $HOME/.netrc
  fi
  # check for ftp-errors
  if [ -s $FTPERRORS ]
  then
    my_rc=255
    echo "ftp: `cat $FTPERRORS`"
  else
    my_rc=0
  fi
  # clean the error-file
  rm -f $FTPERRORS
}
#
echo
if [ -n "$2" ]
then
  FAXNO="$1"
  if [ -f /tmp/"$FAXNO.sff" ]
  then
    echo "ABBRUCH: Datei /tmp/$FAXNO.sff existiert schon, bitte prüfen!"
    echo
  else
    echo "Vorbereitung: erzeuge /tmp/$FAXNO.sff..."
    # exit
    gs -dNOPAUSE -dQUIET -dBATCH -sPAPERSIZE=a4 \
       -sDEVICE=cfax -sOutputFile=/tmp/$FAXNO.sff $2
    my_time="$(date +%Y.%m.%d-%H:%M:%S)"
    echo "..Uebertragung beginnt $my_time"
    # scp -P $remoteport "$dir_build/rc.cfg" "$dir_build/opt.img" "$dir_build/kernel" "$dir_build/rootfs.img" "$dir_build/syslinux.cfg" ${remoteusername}@${remotehostname}:${remotepathname}
    # scp -P 22 -i $HOME/bin/fli4l.private.key -v "$FAXNO.sff" root@fli4l.bruno.lan:/tmp/sendFax
    if [ "$3" = "scp" ]
    then
      use_scp
    else
      use_ftp
    fi
    echo "....endet $(date +%Y.%m.%d-%H:%M:%S)"
    echo "..mit returncode = $my_rc"
    #
    # delete the temp-file
    echo "..lösche temporäres /tmp/$FAXNO.sff"
    rm -f /tmp/$FAXNO.sff
    echo
    echo "============================="
    echo "     ---===Status===---"
    echo "============================="
    if [ "$my_rc" = "0" ]
    then
      echo "Erfolg: $my_time"
      my_status="Erfolg"
    else
      echo "... $my_time"
      echo "FEHLER: kein Versand möglich!"
      my_status="Fehler"
    fi
    echo "Parameter: $1 $2"
    echo "============================="
    # schreibe ein kleines log
    echo "$my_time, Status: $my_status ($my_rc), $2 an $FAXNO" >> $HOME/fli4lFax.log
  fi
else
  echo "usage: fli4lFax <phone-number> <postscript-file> [<transfer-method>]" 
  echo "                transfer-method: [ ftp | scp ] default: ftp"
fi
echo
