#!/bin/sh

#------------------------------------------------------------------------------
# Creation:      27.03.2007    Christoph Fritsch <fli4l@dechristo.net>
# Last modified: 01.05.2011    Christoph Fritsch <fli4l@dechristo.net>
#-------------------------------------------------------------------------------

#--------------------------------------------------------
# fax2mail.sh
#--------------------------------------------------------

#---------------------------------------
# Hilfsfunktionen
#---------------------------------------
#---------------------------------------
# usage ()
#---------------------------------------
usage ()
{
    echo "usage: $0 sff_file or gziped sff_file MSN <List of recipients>"
    echo "       'sff-file' must be specified as an absolute path!"
    echo "       $0 -v"
    echo "       print out some version information"
}

#---------------------------------------
# log (string, color)
#---------------------------------------
log ()
{
    TEXT=$1
    COLOR=$2

    if [ "${FAX2MAIL_LOGFILE}" != "" ]; then
        case "${FAX2MAIL_LOGFILE}"
        in
            syslog) logger "OPT_FAX2MAIL: ${TEXT}";;
            *)      echo "${DATE} OPT_FAX2MAIL: ${TEXT}" >> ${FAX2MAIL_LOGFILE};;
        esac
    fi
    
    if  [ "${COLOR}" != "" ]; then
        colecho "OPT_FAX2MAIL: ${TEXT}" "${COLOR}"
    fi
    
    return 1    
}

#---------------------------------------
# Delete original Fax-Msg on Router and Update mfax.log
# del_fax (filedir, filename)
#---------------------------------------
del_fax ()
{
    FDIR=$1
    FNAM=$2
    LOGFILE=$FDIR'/mfax.log'
    FILE=$FDIR/$FNAM

    if [ -w ${FILE} ]
    then
        rm -f ${FILE}
        if [ -e ${FILE} ]
        then
            log "Failed deleting fax ${FILE}!" "rd"
        else
            log "Fax ${FILE} deleted successfully" "gn"
            # begin mfax.log update
            mv ${LOGFILE} /tmp/mfax_tmp.log
            cat /tmp/mfax_tmp.log | grep -v "${FNAM}" >> ${LOGFILE}
            # endof mfax.log update
        fi
    else
        log "Fax ${FILE} konnte nicht entfernt werden" "rd"
    fi
}

#---------------------------------------
# Hilfsvariablen
#---------------------------------------
. /etc/fax2mail.conf
VERSION='0.3.6 (2011-05-01)'
BASENAME=''

#---------------------------------------
# Aufrufparameter einlesen
#---------------------------------------

log "$*"

if [ "$1" = "-v" ]; then
    echo "FAX2MAIL.sh version ${VERSION}"
    exit 0
fi

## Syntax: cmd recipient1 recipient2 Faxfile MSN
while [ "$1" ]
do
    case $1 in
    *[^0-9]*)
        FILENAME="$1"
        case x$2 in
        x) csid=$FAXRCV_CSID 
           log "OPT_FAXSEND Parameter FAXRCV_CSID: $csid" "cy"
           ;; 
        *) csid=$2 
           log "OPT_FAXSEND Parameter 2 (CSID): $2" "cy"
           ;;
        esac
        log "File: $FILENAME, MSN: $csid" "cy"
        break 
        ;;
    *)
    #collect recipients
        RECIPIENTS="$RECIPIENTS $1" 
        log "Recipients: $RECIPIENTS" "cy"
        ;;
    esac
    shift
done


if [ -f "$FILENAME" ]; then
    log "File $FILENAME ok"
else
    log "missing or invalid filename ($1). will quit now..." "rd"
    usage
    exit 1
fi


#---------------------------------------
# define MTA
#---------------------------------------
if [ "$FAX2MAIL_SMTP_CLIENT" = "ssmtp" ] 
then
    FAXCMD="ssmtp.sh"
else
    FAXCMD="msmtp.sh"
fi

#---------------------------------------
# prepare conversion
#---------------------------------------

     FAXDIR=`dirname "${FILENAME}"`
  EXTENSION=`basename "${FILENAME}" | sed 's/^\(.*\)\(\.sff\)\(.*\)$/\2\3/g'`
   BASENAME=`basename "${FILENAME}" .gz`
   BASENAME=`basename "${BASENAME}" .sff`
     TMPDIR=`date '+%Y%m%d%H%M%S'`          # temporary directory for conversion
       MFAX=`cat ${FAXDIR}/mfax.log | grep $BASENAME`
       DATE=`echo ${MFAX} | cut -f1,2 -d' '`        #get date from log: actual system time doesn't matter
   FAXPAGES=`echo ${MFAX} | cut -f4 -d' '`        #get pagecount from log: filename could be incorrect ...
     SENDER=`echo ${MFAX} | cut -f3 -d' '`        #get sender from log: filename may be incorrect ...
 SENDERNAME=`sed 's/,[^,]*$//' /etc/phonebook | grep "^${SENDER}=" | cut -d"=" -f 2-`  # get sendername from /etc/phonebook

if [ "${SENDERNAME}" = "" ];
then
    SENDERNAME=${SENDER}" (unbekannt)"
fi


if [ "${FAXDIR}" = "." ] || [ ! -d "${FAXDIR}" ]; then
    log "missing or invalid directory in filename ($1). will quit now..." "rd"
    exit 1
fi

cd "${FAXDIR}"
mkdir -p "${TMPDIR}"
if [ -d "${TMPDIR}" ]; then
    # temporary directory exists
    #-------------------------------
    # start conversion
    #-------------------------------
    
    # work with copy only
    cp "${FILENAME}" "${TMPDIR}"
    cd "${TMPDIR}"
    
    #--------------------
    # unzip if necessary
    #--------------------
    if [ "${EXTENSION}" = ".sff.gz" ]; then
        gzip -d "${BASENAME}${EXTENSION}" > /dev/null 2>&1
    fi

    #--------------------
    # convert to multipage TIFF 
    #--------------------
    if [ "${OPT_FAX2MAIL_TIF}" = "yes" ]; then
        #sfftobmp -t "${BASENAME}.sff" "${BASENAME}.tif"
        sff2tiff "${BASENAME}.sff" -o "${BASENAME}.tif"
    fi
    
    #--------
    # PDF
    #--------
    if [ "${OPT_FAX2MAIL_PDF}" = "yes" ]; then
        tiff2pdf "${BASENAME}.tif" -f -o "${BASENAME}.pdf"
    fi

    #--------
    # PS
    #--------
    if [ "${OPT_FAX2MAIL_PS}" = "yes" ]; then
        sff2misc -p "${BASENAME}.tif" "${BASENAME}"
    fi

    #--------
    # PNG
    #--------
#    if [ "${OPT_FAX2MAIL_PNG}" = "yes" ]; then
#        PAGE="1"
#        while [ ${PAGE} -le ${FAXPAGES} ];
#        do
#            tiff2png "${BASENAME}.tif" "${BASENAME}_${PAGE}.png" -p ${PAGE} -a
#            PAGE=`expr ${PAGE} + 1`
#        done
#    fi

    #--------
    # pbm
    #--------
    if [ "${OPT_FAX2MAIL_PBM}" = "yes" ]; then
        sff2misc -m "${BASENAME}.tif" "${BASENAME}"
    fi
    
    #--------
    # JPEG
    #--------
    if [ "${OPT_FAX2MAIL_JPG}" = "yes" ]; then
        case "`echo $filename | cut -b1-2`" in
            fn) conv_option="-d" ;;
            *)  conv_option="-j" ;;
        esac
        
        #creates BASENAME.$PAGE.jpg
            sff2misc $conv_option $BASENAME.sff $BASENAME
    fi
    
    #-------------------------------
    # conversions done
    #-------------------------------
    
    #-------------------------------
    # create bodytext
    #-------------------------------
    {
        echo -e "Fax von     : ${SENDERNAME}\r"
        echo -e "Faxnummer   : ${SENDER}\r"
        echo -e "an MSN      : ${csid}\r"
        echo -e "Datum       : ${DATE}\r"
        echo -e "Seiten      : ${FAXPAGES}\r"
    } > body.txt

    #-----------------------------------
    # send received fax as mail
    #-----------------------------------
    
    for RECIPIENT in $RECIPIENTS
    do
        eval TO='$FAX2MAIL_'$RECIPIENT'_TO'
        eval FORMAT='$FAX2MAIL_'$RECIPIENT'_FORMAT'
        eval GZIP='$FAX2MAIL_'$RECIPIENT'_ZIP'
        log "To: $TO From: $FROM, Gzip: $GZIP" "gn"

        if [ "$GZIP" = "gzip" ]; then
            /usr/local/bin/tar czfv "FAX_von_${SENDER}.tar.gz" *."${FORMAT}"
            FORMAT="tar.gz"
        elif [ "$GZIP" = "bzip2" ]; then
            /usr/local/bin/tar cjfv "FAX_von_${SENDER}.tar.bz2" *."${FORMAT}"
            FORMAT="tar.bz2"
        fi


        $FAXCMD \
        -f "${FAX2MAIL_FROM}" \
        -t "${TO}" \
        -r "${FAX2MAIL_REPLY_TO}" \
        -s "Fax von ${SENDERNAME}, ${FAXPAGES} Seite(n)" \
        -b "${FAXDIR}/${TMPDIR}/body.txt" \
        -d "${FAXDIR}/${TMPDIR}" \
        -rn "^body.txt$" \
        -rp "^.*$FORMAT$"
    done

    if [ "${FAX2MAIL_DELFAX}" = "yes" ]; then
        del_fax  "${FAXDIR}" "${BASENAME}${EXTENSION}"
    fi
    
    #-------------------------------
    # cleanup
    #-------------------------------
    cd ..
    rm -rf "${TMPDIR}"
    
    # done!
else
    log "Cannot create temporary directory. Will quit now ..." "rd"
    exit 1
fi

exit 0
