/* 
 * actorpoll.c - UDP actor poll program for EZcontrol T-10 
 * 
 * Copyright (c) 2005 Rose + Herleth GbR. All rights reserved. 
 *
 *
 * Conditions of Use:
 * For free use in commercial and non-commercial software but only
 * to communicate with Rose+Herleth GbR EZcontrol devices.
 * Use in firmware of third-party hardware only with written approval
 * of Rose+Herleth GbR.
 *
 * Nutzungsbedingungen:
 * Zur freien Verwendung in kommerzieller und nicht-kommerzieller Software
 * jedoch nur zur Kommunikation mit EZcontrol Geraeten der Firma Rose+Herleth GbR.
 * Nutzung in der Firmware der Hardware von Fremdherstellern bedarf der schriftlichen
 * Genehmigung der Rose+Herleth GbR.
 *
 *  07aug05 - Initial release
 *
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/ip.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>              // for gethostbyname
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/select.h>

#define ERROR  -1
#define TRUE    1

#define SEND_PORT 7044

#define GET	0x6711
#define SENSOR	0x1
#define ACTOR	0x2

#define VERSION "1.00"




struct config_pakets {
  uint16_t teletype;
  uint16_t type;  // Aktor, Sensor, Script
  uint16_t n; // Speicherplatznr.
  char descr[32];
  uint16_t reserved1[7];
  uint16_t system;
  uint16_t hc;
  uint16_t hc2;
  uint16_t address;
  int16_t value1;
  int16_t value2;
  int16_t value3;
  int16_t value4; // zustand des aktors
  float   fvalue1;
  float   fvalue2;
  float   fvalue3;
  float   fvalue4;
  uint16_t astype; // art des sensors/aktors
  uint16_t status;
  uint16_t reserved2[3];

  uint16_t reserved3[129];
};





int main(int argc, char *argv[])
{



  static int so_reuseaddr = TRUE;
  char buffer[1500];
  struct sockaddr_in udp_addr_in;
  struct sockaddr_in dest;
  int dest_size=sizeof(struct sockaddr_in);
  int udp_sd, len, n;

  unsigned int repeat=0;
  int i,j;
  struct hostent *hp;
  char *inet_ntoa();
  struct timeval timeout;
  fd_set rd_set;
  
  float value;
  struct config_pakets *configp=(struct config_pakets *)buffer;



  if  (argc != 3)
  	  {
      fprintf(stderr, "Falscher Syntax!\n");
      printf("%s <hostname> <aktornr (1-20)>\n", argv[0]);
      exit(ERROR);
      }

  if  (!(hp = gethostbyname(argv[1])))
  	  {
      fprintf(stderr, "Falscher Hostname: %s\n", argv[1]);
      exit(ERROR);
      }
  

  udp_sd=socket(AF_INET, SOCK_DGRAM, 0);
  if  (udp_sd < 0)
  	  {
      printf("Socket kann nicht geoeffnet werden.\n");
      exit(ERROR);
      }
  
  i=1;
//  timeout.tv_sec = 3;
  timeout.tv_sec = 20;
  timeout.tv_usec = 0;

  FD_ZERO(&rd_set);
  FD_SET(udp_sd, &rd_set);

  dest.sin_family=AF_INET;
  dest.sin_addr=*(struct in_addr *) hp->h_addr_list[0];
  dest.sin_port=htons(SEND_PORT);

  memset( configp, 0, sizeof(struct config_pakets) );
  configp->teletype=GET;
  configp->type=ACTOR;
  configp->n=atoi(argv[2]);
  configp->reserved3[127]=0xffff;
  if  (configp->n > 0)
      configp->n--;
    
  i=0;
  do  {
      i++;
    
      if  (sendto(udp_sd, buffer, sizeof(struct config_pakets), 0, (struct sockaddr *)&dest, sizeof(dest)) < 0)
    	    {
          printf("sendto error\n");
          close(udp_sd);
          exit(ERROR);
          }
      } while( (i < 4) && (select(udp_sd+1, &rd_set, NULL, NULL, &timeout) == ERROR));
      
  if  (i < 4)
  	  {
      len=recvfrom(udp_sd, buffer, 1500, 0, (struct sockaddr *)&dest, &dest_size);
      if  (len < 0)
      	  {
          printf("recvfrom error\n");
          close(udp_sd);
          exit(ERROR);
          }
      else
      	  {
          printf("%d\n", configp->value4);
          //printf("%s sys %d, hc1 %d, hc2 %d, adr %d, v1 %d\n", configp->descr, configp->system, configp->hc, configp->hc2, configp->address, configp->value1);
          }
      }
 else
 	    {
      printf("keine antwort...\n");
      close(udp_sd);
      exit(ERROR);
      }

  
  close(udp_sd);

  return(0);
}