#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 22.12.2006 22:24 V1.0.1 Einbau manual_start und manual_stop (manuell)
#              11.01.2007 21:07 v1.0.2 Einbau group_off und group_on
#                                      Einbau only_off und only_on
#                                      Einbau ping
#              15.02.2007 17:54 v1.1.0 Einbau logfile
#              17.04.2007 14:57 v1.1.1 Prfen beim Init ob Datei schon da ist (WORK_SAVE)
#
# Skript status
#
#
# Devices       0 / off                 Offline
# -------       1 / on                  Online
#               2 / starting            fhrt gerade hoch
#               3 / stopping            fhrt gerade runter
#               4 / group_wait          verzgerte Gruppenverarbeitung
#               5 / parent_wait         verzgerte Serververarbeitung
#               6 /                     frei
#               7 / maint_off           Maintenance-Mode beenden
#               8 / maint_on            Maintenance-Mode starten
#               9 / init                Initialisierung
#
#              10 / manual_off          manuell Offline
#              11 / manual_on           manuell Online
#              12 / manual_starting     manuell fhrt gerade hoch
#              13 / manual_stopping     manuell fhrt gerade runter
#              14 / manual_group_wait   manuell ausgeschaltet verzgerte Gruppenverarbeitung
#
#              20 / group_off           Group Offline
#              21 / group_on            Group Online
#
#              30 / only_off            only server Offline
#              31 / only_on             only server Online
#
#              40 / ping_off            ping nicht ok
#              41 / ping_on             ping ok
#
# Allgemein     s / status              Rckgabe Status
# ---------     m / maint               Rckgabe Maintaenance-Mode
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen
####################################################

HOST=$1
STATUS=$2

if [ $# -ne 2 ]
then
        echo "Aufruf $BASE Host 0/1/2/3/4/5/6/- 7/8/9/ - 10/11/12/13/14/ - 21/21/ - 30/31/ - 40/41/ - s/m"
        echo "Aufruf $BASE Host off/on/starting/stopping/group_wait/parent_wait/ready"
        echo "Aufruf $BASE Host maint_off/maint_on/init"
        echo "Aufruf $BASE Host manual_off/manual_on/manual_starting/manual_stopping/manual_group_wait"
        echo "Aufruf $BASE Host group_off/group_on"
        echo "Aufruf $BASE Host only_off/only_on"
        echo "Aufruf $BASE Host ping_off/ping_on"
        echo "Aufruf $BASE Host status/maint"
        debug "Aufruf $BASE Host nicht korrekt"
        exit $EXIT_ERROR
fi

###################################################
# Status-Files fr type 0,1,2 (device) schreiben
###################################################

status_file ()
{
    if [ $1 -eq 9 ]
    then
        if [ ! -e $WORK/pcs/$HOST ]
        then
            echo "status=\"9\"" > $WORK/pcs/$HOST
            echo "ping=\"0\"" >> $WORK/pcs/$HOST
            echo "timestamp=\"`date +%s`\""  >> $WORK/pcs/$HOST
            echo "date=\"`date`\""  >> $WORK/pcs/$HOST
        fi
        return
    fi

    local status=`grep "^status=" $WORK/pcs/$HOST | cut -f 2 -d '"'`
    local ping=`grep "^ping=" $WORK/pcs/$HOST | cut -f 2 -d '"'`
    local timestamp=`grep "^timestamp=" $WORK/pcs/$HOST | cut -f 2 -d '"'`
    local date=`grep "^date=" $WORK/pcs/$HOST | cut -f 2 -d '"'`

    case $1 in
      40|41) ping=`expr $1 - 40`
             ;;
          *) status=$1
             timestamp=`date +%s`
             date=`date`
             ;;
    esac

    echo "status=\"$status\"" > $WORK/pcs/$HOST
    echo "ping=\"$ping\"" >> $WORK/pcs/$HOST
    echo "timestamp=\"$timestamp\""  >> $WORK/pcs/$HOST
    echo "date=\"$date\""  >> $WORK/pcs/$HOST
}

####################################################
# Setzen oder lesen Status
####################################################

debug "status for $HOST Status: $STATUS started"

case $STATUS in
      off|0)                 status_file 0 ;;
      on|1)                  status_file 1 ;;
      starting|2)            status_file 2 ;;
      stopping|3)            status_file 3 ;;
      group_wait|4)          status_file 4 ;;
      parent_wait|5)         status_file 5 ;;
      6)                     status_file 6 ;;
      maint_off|7)           rm -f $WORK/maintenance/$HOST ;;
      maint_on|8)            echo "on" > $WORK/maintenance/$HOST ;;
      init|9)                status_file 9 ;;
      manual_off|10)         status_file 10 ;;
      manual_on|11)          status_file 11 ;;
      manual_starting|12)    status_file 12 ;;
      manual_stopping|13)    status_file 13 ;;
      manual_group_wait|14)  status_file 14 ;;
      group_off|20)          status_file 20 ;;
      group_on|21)           status_file 21 ;;
      only_off|30)           status_file 30 ;;
      only_on|31)            status_file 31 ;;
      ping_off|40)           status_file 40 ;;
      ping_on|41)            status_file 41 ;;
      status|s)              if [ -e $WORK/pcs/$HOST ]
                             then
                                 echo `grep "^status=" $WORK/pcs/$HOST | cut -f 2 -d '"'`
                             else
                                 echo 99
                                 exit $EXIT_ERROR
                             fi
                             ;;
      maint|m)               if [ -e $WORK/maintenance/$HOST ]
                             then
                                 echo 8
                             else
                                 echo 7
                             fi
                             ;;
      *)                     debug "status for $HOST Status: $STATUS error"
                             exit $EXIT_ERROR
                             ;;
esac

####################################################
# Ende setzen Status
####################################################

debug "status for $HOST Status: $STATUS read"
exit $EXIT_SUCCESS