#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Anzeigen Tabelle Befehle
#
# Last Update: 11.07.2010 09:11:31
#
#----------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /srv/www/lang/automation.$lang

###########################################################################
# Aufbauen Tabs mit Hostnamen
###########################################################################

version=`cat /etc/version | grep "3.0"`
if  [ "$version" != "" ]
then
     header_nr=`/usr/bin/expr $HOSTS / 9 + 1`
else
     header_nr=1
fi

idx=1
for host in `grep "^host_[0-9]*=" $CONF | cut -f 2 -d '"'`
do
       host_bind=`echo $host | sed 's/-/_/g'`
       if  [ "$version" != "" ]
       then
            nr=`/usr/bin/expr $idx / 9 + 1`
       else
            nr=1
       fi
       eval host_header$nr="$"host_header$nr\"$host_bind $myname?action=showBefehle\&host=$host \"
       eval _$host_bind=$host_bind

       idx=`/usr/bin/expr $idx + 1`
done

####################################################
# Setzen Host fr Tab
####################################################

host=$FORM_host
if [ "$host" = "" ]
then
    host=`grep "^host_1=" $CONF | cut -f 2 -d '"'`
fi
FORM_action=`echo $host | sed 's/-/_/g'`

####################################################
# Anzeigen Tabs mit Hostnamen
####################################################

idx=1
while [ $idx -le $header_nr ]
do
       eval show_tab_header "$"host_header$idx
       idx=`/usr/bin/expr $idx + 1`
done

####################################################
# Anzeigen Tabelle mit Befehlen
####################################################

echo '<table border=1 cellpadding=2 cellspacing=0 bgcolor=f0f0f0 bordercolor=ffffff>'

echo '<tr bgcolor=000000>'
echo '<td align="left"><b><font color=ffffff>'$_AUTO_commands'</font></b></td>'
echo '</tr>'

echo '<tr>'
echo '<td align="left" bgcolor="#999999"><a href="'$myname'?extAction='$host',maintenance,showBefehle">maintenance</a></td>'
echo '</tr>'

if [ `grep "^"$host"_groups=" $CONF | cut -f 2 -d '"'` -gt 0 ]
then
    echo '<tr>'
    echo '<td align="left" bgcolor="#999999"><a href="'$myname'?extAction='$host',only_stop,showBefehle">only host offline</a></td>'
    echo '</tr>'

    echo '<tr>'
    echo '<td align="left" bgcolor="#999999"><a href="'$myname'?extAction='$host',only_start,showBefehle">only host online</a></td>'
    echo '</tr>'
fi

for command in `grep "^"$host"_command_[0-9]*=" $CONF | cut -f 2 -d '"'`
do
      echo '<tr>'
      echo '<td align="left" bgcolor="#99CCFF"><a href="'$myname'?extAction='$host','$command',showBefehle">'$command'</a></td>'
      echo '</tr>'
done

echo '</table>'

####################################################
# Ende Tabs
####################################################

idx=1
while [ $idx -le $header_nr ]
do
       show_tab_footer
       idx=`/usr/bin/expr $idx + 1`
done

###################### Ende ########################
