#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    17.04.2007
# Author:      Roland Spitzer
#
# Last Update: 17.04.2007 13:19 erstellt
#              07.05.2007 05:06 v1.1.2 Sichern status-files nach rc511.automation
#              07.06.2007 07:58 v1.1.3 setzen logfile-Adapter auf status off
#              12.08.2007 15:40 v1.1.4 IRTRANS ausgebaut Start/Stop ber
#                                      automation.txt (boot/shutdown)
#
# Stoppen automation
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

debug "stop started"

####################################################
# Prfen ob bereits inaktiv, ansonsten beenden
####################################################

if [ ! -f /var/run/automation.pid ]
then
    /usr/bin/logger Automation not running
    log "Automation not running"
    exit $EXIT_SUCCESS
fi

####################################################
# Stop logfile-adapter (type 3)
####################################################  

for pid in `ps | grep "tail -q -n 1 -F" |  grep -v grep | cut -c 1-5`; do kill $pid; done
for host in `grep "^".*_type*=\"3\" $CONF | cut -f 1 -d '=' | sed 's/_type*$//;'`
do
    $BIN/status.sh $host off
done
log "Logfiles stopped"

####################################################
# Stop automation
####################################################

kill `cat /var/run/automation.pid` > /dev/null
rm /var/run/automation.pid
sleep 1
log "Automation stopped"

####################################################
# Ende Stop
####################################################

debug "stop ready"
exit $EXIT_SUCCESS