#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    25.07.2008 12:25
# Author:      Roland Spitzer
#
# Last Update: 25.07.2008 12:25 v1.1.5 erstellt
#              10.12.2009 06:29 v1.1.6 generieren start, stop und check fr Type2
#
# Erstellen conf-Datei automation.conf und update crontab
#
#----------------------------------------------------------------------------

#set -x

. /usr/local/bin/automation/prolog.inc
. /boot/rc.cfg

debug "generating $CONF started"

####################################################
# Lschen Eintrge aus crontab
####################################################

if [ -e $CRONTABS_PATH/root ]
then
    mv $CRONTABS_PATH/root $CRONTABS_PATH/root.save
    
    IFS=';'
    automat="no"
    cat $CRONTABS_PATH/root.save |
    while read line
    do
        if [ "$line" = "# automation start" ]; then
            automat="yes"
        fi   
        if [ "$automat" = "no" ]; then 
            echo $line >> $CRONTABS_PATH/root
        fi
        if [ "$line" = "# automation end" ]; then
            automat="no"
        fi
    done
    unset IFS

    echo "# automation start" >> $CRONTABS_PATH/root
    rm $CRONTABS_PATH/root.save
    chmod 600 $CRONTABS_PATH/root
fi

####################################################
# Erstellen conf-Datei
####################################################

{
####################
# global parameter #
####################

echo start_at_boot_time=\""$AUTOMATION_START_AT_BOOT_TIME"\"
echo log=\""$AUTOMATION_LOG"\"
echo debug=\""$AUTOMATION_DEBUG"\"
echo logfile=\""$AUTOMATION_LOGFILE"\"
echo work=\""$AUTOMATION_WORK"\"
echo work_save=\""$AUTOMATION_WORK_SAVE"\"
refresh=$AUTOMATION_REFRESH
if [ "$refresh" = "" ]; then
    refresh=60
fi
echo refresh=\""$refresh"\"
sleeph=$AUTOMATION_SLEEPH
if [ "$sleeph" = "" ]
then
    version=`cat /etc/version | grep "3.0"`
    if  [ "$version" != "" ]
    then
         sleeph=1
    else
         sleeph=0
    fi
fi
echo sleeph=\""$sleeph"\"
sleepv=$AUTOMATION_SLEEPV
if [ "$sleepv" = "" ]; then
    sleepv=0
fi
echo sleepv=\""$sleepv"\"
auto_hosts=$AUTOMATION_AUTO_HOSTS
if [ "$auto_hosts" = "" ]; then
    auto_hosts="no"
fi
echo auto_hosts=\""$auto_hosts"\"

#########
# Hosts #
#########

echo hosts=\""$AUTOMATION_HOSTS_N"\"

idx1=1
while [ $idx1 -le $AUTOMATION_HOSTS_N ]
do
       eval host='$AUTOMATION_HOST_'$idx1
       echo host_"$idx1"=\""$host"\"
       eval delay='$AUTOMATION_HOST_'$idx1'_DELAY'
       if [ "$delay" = "" ]; then
           delay=0
       fi
       echo "$host"_delay=\""$delay"\"
       eval boottime='$AUTOMATION_HOST_'$idx1'_BOOTTIME'
       if [ "$boottime" = "" ]; then
           boottime=0
       fi
       echo "$host"_boottime=\""$boottime"\"
       eval http='$AUTOMATION_HOST_'$idx1'_HTTP'
       if [ ! "$http" = "" ]; then
           echo "$host"_http=\""$http"\"
       fi

       ########
       # Type #
       ########

       eval type='$AUTOMATION_HOST_'$idx1'_TYPE'
       if [ "$type" = "" ]; then
           type=1
       fi
       echo "$host"_type=\""$type"\"
       if [ $type -eq 0 ]
       then
           eval type0_default='$AUTOMATION_HOST_'$idx1'_TYPE0_DEFAULT'
           if [ "$type0_default" = "" ]; then
               type0_default="stop"
           fi
           echo "$host"_type0_default=\""$type0_default"\"
       fi

       if [ $type -eq 2 ]
       then
           eval type2_server='$AUTOMATION_HOST_'$idx1'_TYPE2_SERVER'
           echo "$host"_type2_server=\""$type2_server"\"
           eval type2_parm='$AUTOMATION_HOST_'$idx1'_TYPE2_PARM'
           echo "$host"_type2_parm=\""$type2_parm"\"
       fi

       if [ $type -eq 3 ]
       then
           eval type3_file='$AUTOMATION_HOST_'$idx1'_TYPE3_FILE'
           echo "$host"_type3_file=\""$type3_file"\"
       fi

       ###############
       # Host Groups #
       ###############

       eval groups='$AUTOMATION_HOST_'$idx1'_GROUP_N'
       if [ "$groups" = "" ]; then
           groups=0
       fi
       echo "$host"_groups=\""$groups"\"

       idx2=1
       while [ $idx2 -le $groups ]
       do
              eval group='$AUTOMATION_HOST_'$idx1'_GROUP_'$idx2
              echo "$host"_group_"$idx2"=\""$group"\"
              idx2=`expr $idx2 + 1`
       done

       ###############
       # Host Childs #
       ###############

       eval childs='$AUTOMATION_HOST_'$idx1'_CHILD_N'
       if [ "$childs" = "" ]; then
           childs=0
       fi
       echo "$host"_childs=\""$childs"\"

       idx2=1
       while [ $idx2 -le $childs ]
       do
              eval child='$AUTOMATION_HOST_'$idx1'_CHILD_'$idx2
              echo "$host"_child_"$idx2"=\""$child"\"

              idx2=`expr $idx2 + 1`
       done

       ##############
       # Host Ports #
       ##############

       eval ports='$AUTOMATION_HOST_'$idx1'_PORT_N'
       if [ "$ports" = "" ]; then
           ports=0
       fi
       echo "$host"_ports=\""$ports"\"

       idx2=1
       while [ $idx2 -le $ports ]
       do
              eval port='$AUTOMATION_HOST_'$idx1'_PORT_'$idx2
              echo "$host"_port_"$idx2"=\""$port"\"

              idx2=`expr $idx2 + 1`
       done

       #################
       # Host Commands #
       #################

       eval commands='$AUTOMATION_HOST_'$idx1'_COMMAND_N'
       if [ "$commands" = "" ]; then
           commands=0
       fi
##     echo "$host"_commands=\""$commands"\"    ### nach hinten 10.12.2009 06:30:09 ###

       idx2=1
       while [ $idx2 -le $commands ]
       do
              eval command='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2
              echo "$host"_command_"$idx2"=\""$command"\"
              eval cron='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2'_CRON'
              case $cron in
                           no|"")   : ;;
                   boot|shutdown)   echo "$host"_command_"$idx2"_cron=\""$cron"\" ;;
                     automation*)   echo "$host"_command_"$idx2"_cron=\""$cron"\" ;;
                               *)   croncmd=""$BIN"/command.sh "$host" "$command" &"   
                                    IFS=';'
                                    for subcron in $cron
                                    do
                                        # add_crontab_entry "$subcron" "$croncmd"
                                        if [ -e $CRONTABS_PATH/root ]
                                        then
                                            echo "$subcron" "$croncmd" >> $CRONTABS_PATH/root
                                        fi
                                    done
                                    echo "$host"_command_"$idx2"_cron=\""$cron"\"
                                    unset IFS
                                    ;;     
              esac
              if [ $type -eq 3 ]
              then
                  set -f
                  eval search='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2'_SEARCH'
                  echo "$host"_command_"$idx2"_search=\""$search"\"
                  eval count='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2'_COUNT'
                  echo "$host"_command_"$idx2"_count=\""$count"\"
                  set +f
              fi

              ########################
              # Host Command-Records #
              ########################

              eval commandanz='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2'_N'
              if [ "$commandanz" = "" ]; then
                  commandanz=0
              fi
              echo "$host"_command_"$idx2"_anz=\""$commandanz"\"

              set -f
              idx3=1
              while [ $idx3 -le $commandanz ]
              do
                     eval commandrec='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2'_'$idx3
                     echo "$host"_command_"$idx2"_"$idx3"=\""$commandrec"\"

                     idx3=`expr $idx3 + 1`
              done
              set +f

              idx2=`expr $idx2 + 1`
       done

       ############################################
       # Generierung Commands 10.12.2009 06:30:19 #
       ############################################

       if [ $type -eq 2 ]
       then
           start=0
           stop=0
           check=0
       
           if [ ! "$type2_server" = "" ]
           then
               idx2=1
               while [ $idx2 -le $commands ]
               do
                   eval command='$AUTOMATION_HOST_'$idx1'_COMMAND_'$idx2
                   case $command in
                            start)   start=1 ;;
                             stop)   stop=1 ;;
                            check)   check=1 ;;
                                *)   : ;;     
                   esac

                   idx2=`expr $idx2 + 1`
               done
               
               if [ $start -eq 0 ]
               then
                   commands=`expr $commands + 1`
                   echo "$host"_command_"$commands"=\"start\"
                   echo "$host"_command_"$commands"_anz=\"1\"
                   echo "$host"_command_"$commands"_1=\"$BIN_ROOT/EZconsole "$type2_server" -p "$type2_parm" 255\"
               fi                           
               if [ $stop -eq 0 ]
               then
                   commands=`expr $commands + 1`
                   echo "$host"_command_"$commands"=\"stop\"
                   echo "$host"_command_"$commands"_anz=\"1\"
                   echo "$host"_command_"$commands"_1=\"$BIN_ROOT/EZconsole "$type2_server" -p "$type2_parm" 0\"
               fi        
               if [ $check -eq 0 ]
               then
                   commands=`expr $commands + 1`
                   echo "$host"_command_"$commands"=\"check\"
                   echo "$host"_command_"$commands"_anz=\"1\"
                   echo "$host"_command_"$commands"_1=\"return \`eval $BIN_ROOT/actorpoll "$type2_server" "$type2_parm"\`\"
               fi        
           
           fi
       fi

       echo "$host"_commands=\""$commands"\"

       #################
       # nchster Host #
       #################

       idx1=`expr $idx1 + 1`
done

if [ -e $CRONTABS_PATH/root ]
then
    echo "# automation end" >> $CRONTABS_PATH/root
fi

########################
# Hosts aus /etc/hosts #
########################

if [ "$AUTOMATION_AUTO_HOSTS" = "yes" ]
then
    idx1=`expr $idx1 - 1`

    for etchost in `grep -v "^#" /etc/hosts | cut -f 2 -d ' '`
    do
        if [ "$etchost" = "localhost" ]; then
            continue
        fi

        idx2=1
        while [ $idx2 -le $AUTOMATION_HOSTS_N ]
        do
               eval host='$AUTOMATION_HOST_'$idx2
               if [ "$etchost" = "$host" ]; then
                   break
               fi
               idx2=`expr $idx2 + 1`
        done

        if [ ! "$etchost" = "$host" ]
        then
            idx1=`expr $idx1 + 1`
            echo host_"$idx1"=\""$etchost"\"
            echo "$etchost"_delay=\"0\"
            echo "$etchost"_boottime=\"0\"
            echo "$etchost"_type=\"1\"
            echo "$etchost"_groups=\"0\"
            echo "$etchost"_childs=\"0\"
            echo "$etchost"_ports=\"0\"
            echo "$etchost"_commands=\"0\"
        fi
    done
fi
}  > $CONF

debug "generating $CONF ended"

#set +x
