#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    28.05.2007
# Author:      Roland Spitzer
#
# Last Update: 
#
# Skript to generate automation special-commands
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Prfen ob bereits aktiv, ansonsten beenden
####################################################

LOCKFILE="/var/run/automation_special.pid"
if [ -f $LOCKFILE ]
then
    echo "$BASE already running"
    log "already running"
    exit $EXIT_ERROR
fi
echo $$ > $LOCKFILE

####################################################
# Parameter prfen und setzen
####################################################

FUNKTION=$1

case $FUNKTION in
      
      boot|shutdown) 
          ;;
      
      automation_start|automation_stop) 
          
          if [ ! -f /var/run/automation.pid ]
          then
              echo "$BASE automation not active"
              log "automation not active"
              exit $EXIT_ERROR
          fi
          ;;
          
      *) echo "Aufruf $BASE boot/shutdown/automation_start/automation_stop"
         debug "Aufruf $BASE boot/shutdown/automation_start/automation_stop"
         exit $EXIT_ERROR
         ;;
esac

####################################################
# Special Command Verarbeitung
####################################################

debug "special $FUNKTION generation started"

for hostcommand in `grep "^".*_command_[0-9]*_cron=\"$FUNKTION\" $CONF | cut -f 1 -d '=' | sed 's/_cron$//;'`
do
    host=`echo $hostcommand | sed 's/_command_[0-9]*$//;'`
    command=`grep ""$hostcommand"=" $CONF | cut -f 2 -d '"'`
    log "$FUNKTION for $host $command started"
    $BIN/command.sh $host $command
done

####################################################
# Ende
####################################################

rm -f $LOCKFILE 2>/dev/null
debug "command-special for $FUNKTION ended"

exit $EXIT_SUCCESS