#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
# Last Update:
#
# Include fr alle Skripte
#
# Last Update: 13.02.2007 04:37 v1.0.3 Doppelpunkt hinter dem Datum entfernt (log)
#              16.02.2007 11:39 v1.1.0 read_file eingebaut
#              11.04.2007 12:34 v1.1.1 IRTRANS und BIN_ROOT eingebaut
#                                      einzelne CAT's -> while read line
#              17.04.2007 13:52 v1.1.1 prfen start.sh, prfen ob CONF vorhanden
#              21.04.2007 13:19 v1.1.1 special_command() eingebaut
#              09.05.2007 21:56 v1.1.2 special_command mit und ohne & (Tino Albrecht)
#              12.05.2007 10:58 v1.1.3 in den rc/rc0-Skripten mu noch kein
#                                      CONF-File existieren
#              28.05.2007 16:26 v1.1.3 Conf-Lesen in Subroutine
#              28.05.2007 22:33 v1.1.3 special_command in eigenes Skript
#              07.06.2007 06:24 v1.1.3 SSH eingebaut da bei 3.1.2 die ssh-files
#                                      in /etc/ssh liegen
#              12.08.2007 15:40 v1.1.4 IRTRANS ausgebaut Start/Stop ber
#                                      automation.txt (boot/shutdown)
#              26.07.2008 04:32 v1.1.5 CRONTABS_PATH eingebaut
#
#----------------------------------------------------------------------------

####################################################
# Parameter setzen
####################################################

EXIT_SUCCESS=0
EXIT_ERROR=1

CONF=/var/run/automation.conf
BIN_ROOT=/usr/local/bin
BIN=/usr/local/bin/automation
BASE=`basename "$0"`
if [ -e /opt/etc/ssh ]
then
    SSH=/opt/etc/ssh
else
    SSH=/etc/ssh
fi
CRONTABS_PATH=/var/spool/cron/crontabs

####################################################
# Ausgabe log und debug
####################################################

log ()
{
    if [ "$LOG" = "yes" ]
    then
        set -f
        echo `date '+%d.%m.%y %T'` $$ $BASE $1 >> $LOGFILE
        set +f
    fi
}

debug ()
{
    if [ "$DEBUG" = "yes" ]
    then
        set -f
        echo `date '+%d.%m.%y %T'` $$ $BASE $1 >> $LOGFILE
        set +f
    fi
}

####################################################
# Lesen Conf-File und Status-File
####################################################

read_conf ()
{
    HOSTS=`grep -c "^host_[0-9]*=" $CONF`

    set -f
    while read line
    do
        case $line in
                     "log="*) LOG=`echo $line | cut -f 2 -d '"'` ;;
                   "debug="*) DEBUG=`echo $line | cut -f 2 -d '"'` ;;
                 "logfile="*) LOGFILE=`echo $line | cut -f 2 -d '"'` ;;
                    "work="*) WORK=`echo $line | cut -f 2 -d '"'` ;;
               "work_save="*) WORK_SAVE=`echo $line | cut -f 2 -d '"'` ;;
        esac
    done < $CONF
    set +f
}

read_file ()
{
    while read line
    do
           case $line in
                 status*) status=`echo $line | cut -f 2 -d '"'` ;;
                   ping*) ping=`echo $line | cut -f 2 -d '"'` ;;
              timestamp*) timestamp=`echo $line | cut -f 2 -d '"'` ;;
                   date*) date=`echo $line | cut -f 2 -d '"'` ;;
                   hour*) hour=`echo $line | cut -f 2 -d '"'` ;;
                    day*) day=`echo $line | cut -f 2 -d '"'` ;;
           esac
    done < $WORK/pcs/$1
}

####################################################
# Lesen CONF-Datei
####################################################

if [ -f $CONF ]
then
    read_conf
fi

####################### Ende ####################### 