#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    15.02.2007 08:11
# Author:      Roland Spitzer
#
# Last Update: 15.02.2007 08:12 angelegt
#              03.05.2007 02:24 v1.1.1 Fehlerbehebung ersetzen " anstatt mit @ durch  ersetzen
#                                      Hinweis von T.Albrecht
#              07.06.2007 07:42 v1.1.3 beim ps grep, grep ausgeklammert
#
# Logfile-Adapter : berwachung und Auswertung eines log-files mittels tail
# und Ausfhren von Aktionen wenn entsprechende Eintrge im Logfile gefunden
# werden.
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen und setzen
####################################################

HOST=$1

if [ $# -ne 1 ]
then
    echo "Aufruf $BASE Logfile"
    debug "Aufruf $BASE Logfile"
    exit $EXIT_ERROR
fi

type3_file=`grep "^"$HOST"_type3_file=" $CONF | cut -f 2 -d '"'`

####################################################
# Prfungen
####################################################

if [ ! "$(ps | grep "tail" | grep -v grep | grep $type3_file)" = "" ]
then
    echo "$BASE $HOST bereits aktiv"
    log "$BASE $HOST bereits aktiv"
    exit $EXIT_ERROR
fi

if [ -f $type3_file ]
then :
else
    echo "$BASE $HOST $type3_file existiert nicht"
    log "$BASE $HOST $type3_file existiert nicht"
    exit $EXIT_ERROR
fi

####################################################
# Variablen auslesen und setzen
####################################################

anz=0
date_day=0
date_hour=0
date_day_old=0
date_hour_old=0

set -f
for commandpref in `grep "^"$HOST"_command_[0-9]*=" $CONF | cut -f 1 -d '='`
do
      command=`grep "^"$commandpref"=" $CONF | cut -f 2 -d '"'`
      if [ "$command" = "start" -o "$command" = "stop" -o "$command" = "manual_start" -o "$command" = "manual_stop" ]
      then
          continue
      fi

      search=`grep "^"$commandpref"_search=" $CONF | sed 's/'\"'//;s/'\"'$//' | cut -f 2 -d ''`
      hour_max=`grep "^"$commandpref"_count=" $CONF | cut -f 2 -d '"' | cut -f 1 -d ' '`
      if [ "$hour_max" = "*" ]
      then
          hour_max=9999999
      fi
      day_max=`grep "^"$commandpref"_count=" $CONF | cut -f 2 -d '"' | cut -f 2 -d ' '`
      if [ "$day_max" = "*" ]
      then
          day_max=9999999
      fi

      anz=`/usr/bin/expr $anz + 1`

      eval command$anz="$"command
      eval search$anz="$"search
      eval hour_max$anz="$"hour_max
      eval day_max$anz="$"day_max

      eval hour_count$anz=0
      eval day_count$anz=0
      eval message$anz=0
done
set +f

if [ $anz -eq 0 ]
then
    echo "$BASE $HOST keine Befehle definiert"
    log "$BASE $HOST keine Befehle definiert"
    exit $EXIT_ERROR
fi

log "Automation Logfile "$HOST" started"

#######################################
# Fllen Variablen aus dyn. Variablen #
# Ausgabe Meldung                     #
#######################################

set_parm ()
{
    eval command="$"command$1
    eval search="$"search$1
    eval hour_max="$"hour_max$1
    eval day_max="$"day_max$1

    eval hour_count="$"hour_count$1
    eval day_count="$"day_count$1
    eval message="$"message$1
}

log_message ()
{   
    if [ $message -eq 0 ]
    then
        log "$HOST $command max count $2 reached"
        eval message$1=1
    fi
}

####################################################
# berwachen Logfiles
####################################################

set -f
tail -q -n 1 -F $type3_file --max-unchanged-stats=120 |
while read line
do
      if [ `$BIN/status.sh $HOST maint` -eq 8 ]
      then
          debug "Device $HOST in maintenance mode"
          continue
      fi

      date_hour=`date +%k`
      date_day=`date +%j`

      ####################################################
      # Verarbeitung
      ####################################################

      idx=1
      while [ $idx -le $anz ]
      do
             #################
             # Datumswechsel #
             #################

             if [ $date_day -ne $date_day_old ]
             then
                 eval hour_count$idx=0
                 eval day_count$idx=0
                 eval message$idx=0
             else
                 if [ $date_hour -ne $date_hour_old ]
                 then
                     eval hour_count$idx=0
                     eval message$idx=0
                 fi
             fi

             ######################################
             # String prfen und Kommando starten #
             ######################################

             set_parm $idx

             value=`echo $line | eval $search`
             if [ ! "$value" = "" ]
             then
                 if [ $day_count -lt $day_max ]
                 then
                     if [ $hour_count -lt $hour_max -o $hour_max -eq 0 ]
                     then
                         $BIN/command.sh $HOST $command "$value"

                         hour_count=`/usr/bin/expr $hour_count + 1`
                         day_count=`/usr/bin/expr $day_count + 1`
                         eval hour_count$idx="$"hour_count
                         eval day_count$idx="$"day_count
                     else
                         log_message $idx "hour"
                     fi
                 else
                     log_message $idx "day"
                 fi
             fi

             idx=`/usr/bin/expr $idx + 1`
      done

      date_hour_old=$date_hour
      date_day_old=$date_day

done &
set +f

####################################################
# Ende
####################################################

exit $EXIT_SUCCESS