#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.12.2009 10:48:03
# Author:      Roland Spitzer
#
# Last Update: 
#
# Skript to generate xml-file for CasaRemote (iPhone-Application)
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen und setzen
####################################################

debug "Bedienelement-Automat.xml generation for iPhone started"

skript=$BIN"/Bedienelement-Automat.xml"
inc=$BIN"/iphone.inc"

{
####################################################
# Skript generieren
####################################################

set -f
cat $inc |
while read line
do
      if [ "$line" = "<!--- Skript-Ende --->" ]
      then
          for host in `grep "^host_[0-9]*=" $CONF | cut -f 2 -d '"'`
          do
              echo "     <socket>"
			        echo "         <name>"$host"</name>"
			        echo "         <socktype>toggle</socktype>"
			        echo "         <picture></picture>"
			        echo "         <ident>"$host";startstop</ident>"
		          echo "     </socket>"
          
              for command in `grep "^"$host"_command_[0-9]*=" $CONF | cut -f 2 -d '"'`
              do
                  if [ "$command" = "start" -o "$command" = "stop" -o "$command" = "check" ]
                  then
                      :
                  else
                      echo "     <socket>"
			                echo "         <name>"$host" "$command"</name>"
			                echo "         <socktype>button</socktype>"
			                echo "         <picture></picture>"
			                echo "         <ident>"$host";"$command"</ident>"
		                  echo "     </socket>"   
                  fi
              done
          done
          
          echo $line
      else
          echo $line
      fi
done
set +f

} > $skript

####################################################
# Ende Generierung
####################################################

debug "Bedienelement-Automat.xml generation ended"
exit $EXIT_SUCCESS