#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 22.12.2006 22:24 V1.0.1 Einbau manual_start und manual_stop (manuell)
#              14.01.2007 04:15 v1.0.2 Einbau group_start, group_stop, only_start, only_stop 
#
# Skript abhaengige Server starten und stoppen
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen
####################################################

HOST=$1
FUNKTION=$2

debug "group $FUNKTION check for $HOST started"

case $2 in
      stop)         FUNKTION=0 ;;
      start)        FUNKTION=1 ;;
      manual_stop)  FUNKTION=10 ;;
      manual_start) FUNKTION=11 ;;
      group_stop)   FUNKTION=20 ;;
      group_start)  FUNKTION=21 ;;
      only_stop)    FUNKTION=30 ;;
      only_start)   FUNKTION=31 ;;
esac

case $FUNKTION in
      0|1|10|11|20|21|30|31) : ;;
      *) echo "Aufruf $BASE Host 0/1/10/11/20/21/30/31 oder stop/start/manual_stop/manual_start/group_stop/group/start/only_stop/only_start"
         debug "Aufruf $BASE Host 0/1/10/11/20/21/30/31"
         exit $EXIT_ERROR
         ;;
esac

#######################################################
# Prfen ob abhngige Hosts woanders gebraucht werden
#######################################################

host_offline ()
{
    for host in `grep "^".*_group_[0-9]*=\""$1"\" $CONF | cut -f 1 -d '=' | sed 's/_group_[0-9]*$//;'`
    do
        local status=`$BIN/status.sh $host status`
        if [ $status -eq 1 -o $status -eq 11 ]
        then
            if [ ! "$1" = "$host" ]
            then
                echo $EXIT_ERROR
                return
            fi
        fi
    done

    echo $EXIT_SUCCESS
}

####################################################
# Group Check Host Verarbeitung
####################################################

if [ `$BIN/status.sh $HOST maint` -eq 7 ]
then

    case $FUNKTION in

         ########################
         # Stop ber Automation #
         ########################

          0) if [ `host_offline $HOST` -eq $EXIT_SUCCESS ]
             then
                 $BIN/command.sh $HOST stop >/dev/null &
                 debug "group check $HOST stop"
             fi
             ;;

         #########################
         # Start ber Automation #
         #########################

          1) $BIN/command.sh $HOST start >/dev/null &
             debug "group check $HOST start"
             ;;

         ################
         # Stop manuell #
         ################

         10) $BIN/command.sh $HOST manual_stop >/dev/null &
             debug "group check $HOST manual stop"
             ;;

         #################
         # Start manuell #
         #################

         11) $BIN/command.sh $HOST manual_start >/dev/null &
             debug "group check $HOST manual start"
             ;;

         ###########################
         # Abhngige Hosts stoppen #
         ###########################

         20) for host_group in `grep "^"$HOST"_group_[0-9]*=" $CONF | cut -f 2 -d '"'`
             do
                 status=`$BIN/status.sh $host_group status`

                 if [ `$BIN/status.sh $host_group maint` -eq 7 -a ! "$host_group" = "$HOST" ]
                 then
                     if [ $status -ne 0 -a $status -ne 10 ]
                     then
                         if [ `host_offline $host_group` -eq $EXIT_SUCCESS ]
                         then
                             $BIN/command.sh $host_group stop >/dev/null &
                             debug "group check $host_group stop"
                         fi
                     fi
                 fi
             done
             debug "group check $HOST group stop"
             ;;

         ###########################
         # Abhngige Hosts starten #
         ###########################

         21) for host_group in `grep "^"$HOST"_group_[0-9]*=" $CONF | cut -f 2 -d '"'`
             do
                 status=`$BIN/status.sh $host_group status`

                 if [ `$BIN/status.sh $host_group maint` -eq 7 -a ! "$host_group" = "$HOST" ]
                 then
                     if [ $status -ne 1 -a $status -ne 11 ]
                     then
                         $BIN/command.sh $host_group start >/dev/null &
                         debug "group check $host_group start"
                     fi
                 fi
             done
             debug "group check $HOST group start"
             ;;


         ###################
         # Stop nur Server #
         ###################

         30) $BIN/command.sh $HOST only_stop >/dev/null &
             debug "group check $HOST only stop"
             ;;

         ####################
         # Start nur Server #
         ####################

         31) $BIN/command.sh $HOST only_start >/dev/null &
             debug "group check $HOST only start"
             ;;
    esac
fi

####################################################
# Ende Group Check
####################################################

debug "group $FUNKTION check for $HOST ended"
exit $EXIT_SUCCESS