#!/bin/sh
#------------------------------------------------------------------------------
# PFTPD main form
#
# Creation:    2001-06-19  Florian Zierer
# Last update: 2009-05-20  Arno Welzel with additions by Frank Saurbier
#------------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /var/run/pftpd.conf

check_rights "pftpd" "action"

# hack for proper tab-selection, inspired by pf.cgi
: ${FORM_action:=opt_control}
: ${FORM_log_lines:=25}
: ${FORM_log_sort:=reverse}
: ${FORM_showall:=}
myname=`basename $0`

# header [refresh]
# 
# Builds the http and html page header and optionally
# inserts a meta refresh tag to automatically reload
# the current action tab

header ()
{
	if [ "$1" != "" ]
	then
		show_html_header "$_MP_pftpd" "refresh=$1; url=$myname?action=$FORM_action"
	else
		show_html_header "$_MP_pftpd"
	fi
	
	show_tab_header "$_opt_control" "$myname?action=opt_control" \
					"$_opt_user" "$myname?action=opt_user" \
					"$_opt_connections" "$myname?action=opt_connections" \
					"$_opt_logfile" "$myname?action=opt_logfile"
}

case $FORM_action in
opt_control)
	header
	
	if [ "$FORM_command" = "" ]
	then
		echo "<p></p>"
		
		if [ -f /var/run/pure-ftpd.pid ]
		then
		  echo "<table class=\"normtable\"><tr><td bgcolor=\"#80ff80\">$_ctr_statusrun</td><td> <a href=\"$myname?action=opt_control&command=stop\"><b>$_ctr_actionstop</b></a></td></tr></table>"
		else
		  echo "<table class=\"normtable\"><tr><td bgcolor=\"#ff8080\">$_ctr_statusstop</td><td> <a href=\"$myname?action=opt_control&command=start\"><b>$_ctr_actionstart</b></a> </td></tr></table>"
		fi

		echo "<br/><form action=\"$myname\" method=\"POST\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_control\"/>"
		echo "<input type=\"hidden\" name=\"command\" value=\"setbandwidth\"/>"
		echo "$_ctr_upload:$_ctr_download (kb/s): <input name=\"bandwidth\" size=\"6\" value=\"$PFTPD_BANDWIDTH\"/>"
		echo "<input type=\"submit\" value=\"$_ctr_change\"/>"
		echo "</form>"
	fi

	if [ "$FORM_command" = "stop" ]
	then
		echo "<p>$_ctr_stopping</p>"
		kill `cat /var/run/pure-ftpd.pid`

		echo "<p><a href=\"$myname?action=opt_control\">$_ctr_continue</a></p>"
	fi

	if [ "$FORM_command" = "start" ]
	then
		echo "<p>$_ctr_starting</p>"
		if [ -f /var/run/pure-ftpd.pid ]
		then
			kill `cat /var/run/pure-ftpd.pid`
		fi
		. /boot/rc.cfg
		. /var/run/pftpd.conf
		. /etc/rc.d/rc400.pftpd >/dev/null 2>/dev/null

		echo "<p><a href=\"$myname?action=opt_control\">$_ctr_continue</a></p>"
	fi

	if [ "$FORM_command" = "setbandwidth" ]
	then
		echo "<p>$_ctr_bandwidthupdate</p>"
		FORM_bandwidth=`echo "$FORM_bandwidth" | sed "s/%3A/\:/g"`

		if [ -f /var/run/pure-ftpd.pid ]
		then
			kill `cat /var/run/pure-ftpd.pid`
		fi
		. /boot/rc.cfg
		PFTPD_BANDWIDTH=$FORM_bandwidth
		. /etc/rc.d/rc400.pftpd >/dev/null 2>/dev/null

		grep -v PFTPD_BANDWIDTH < /var/run/pftpd.conf > /var/run/pftpd.conf1
		mv /var/run/pftpd.conf1 /var/run/pftpd.conf

		echo "PFTPD_BANDWIDTH='$FORM_bandwidth'" >> /var/run/pftpd.conf

		echo "<p><a href=\"$myname?action=opt_control\">$_ctr_continue</a></p>"
	fi
	;;

opt_user)
	case $FORM_command in
	"")
		header
		
		echo "<h2>$_ctr_headeruseroverview</h2>"
		echo "<form action=\"$myname\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\">"
		echo "<input type=\"hidden\" name=\"command\" value=\"useradd\">"
		echo "<p><input type=\"submit\" value=\"$_ctr_adduser\"></p>"
		echo "</form>"
		
		USERLIST=`cat "$PWF"`
		if [ "$USERLIST" = "" ]
		then
			echo "<p>$_ctr_nouser</p>"
		else
			echo "<table class=\"normtable\">"
			echo "<tr><th rowspan=\"2\">$_ctr_login</th><th rowspan=\"2\">$_ctr_localdir</th><th colspan=\"3\">$_ctr_limits</th><th rowspan=\"2\">$_ctr_action</th></tr>"
			echo "<tr><th>$_ctr_sessions</th><th>$_ctr_ipaddress</th><th>$_ctr_time</th></tr>"
			echo "$USERLIST" |
			(
			while read line
			do
				account=`echo $line | cut -d ":" -f 1`
				path=`echo $line | cut -d ":" -f 6 | sed 's/\/\.\///g'`
				sessions=`echo $line | cut -d ":" -f 11`
				ip=`echo $line | cut -d ":" -f 16 | sed 's/,/<br\/>/g'`
				time=`echo $line | cut -d ":" -f 18`
				
				echo "<tr>"
				echo "<td>$account</td>"
				echo "<td>$path</td>"
				echo "<td>$sessions</td>"
				echo "<td>$ip</td>"
				echo "<td>$time</td>"
				echo "<td><a href=\"$myname?action=opt_user&command=useredit&login=$account\">$_ctr_edit</a>&nbsp;&nbsp;<a href=\"$myname?action=opt_user&command=userdelete&login=$account\">$_ctr_delete</a></td>"
				echo "</tr>"
			done
			)
			echo "</table>"
		fi
		;;
		
	useradd)
		if [ "$FORM_cancel" != "" ]
		then
			header 0
			echo "<h2>$_ctr_headeradduser</h2>"
			echo "<p>$_ctr_cancelled</p>"
			echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
		fi
		
		if [ "$FORM_ok" != "" ]
		then
			msg=""
			
			if [ "$FORM_user_login" = "" ]
			then
				msg="$_ctr_errorlogin"
				FORM_ok=""
			fi
			
			if [ "$FORM_user_pwd" = "" ]
			then
				if [ "$msg" != "" ]
				then
					msg="$msg<br/>"
				fi
				msg="$msg""$_ctr_errorpass"
				FORM_ok=""
			fi
			
			if [ "$FORM_user_pwd" != "$FORM_user_pwd2" ]
			then
				if [ "$msg" != "" ]
				then
					msg="$msg<br/>"
				fi
				msg="$msg""$_ctr_errorpassmatch"
				FORM_ok=""
			fi
			
			if [ ! -d "$FORM_user_path" -a "$FORM_user_makedir" != "1" ]
			then
				if [ "$msg" != "" ]
				then
					msg="$msg<br/>"
				fi
				msg="$msg""$_ctr_errordir"
				FORM_ok=""
			fi

			if [ "$FORM_ok" != "" ]
			then
				header
				echo "<h2>$_ctr_headeradduser</h2>"
				
				if [ "$FORM_user_makedir" = "1" ]
				then
					mkdir $FORM_user_path
					chown ftpuser.ftpgroup $FORM_user_path
				fi
				
				if [ -d "$FORM_user_path" ]
				then
					echo "<p>$_ctr_usercreating <b>$FORM_user_login</b>..."
					
					(echo $FORM_user_pwd; echo $FORM_user_pwd) | pure-pw useradd "$FORM_user_login" -u ftpuser -d "$FORM_user_path" -f $PWF 2>/dev/null >/dev/null
					pure-pw usermod "$FORM_user_login" -y "$FORM_user_limitsessions" -r "$FORM_user_limitip" -z "$FORM_user_limittime" -f $PWF 2>/dev/null >/dev/null
					pure-pw mkdb /etc/pureftpd.pdb -f $PWF 2>/dev/null >/dev/null
					
					echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
				else
					echo "<p><b>$_ctr_errordir $FORM_user_path!</b>"
					FORM_ok=""
				fi
			fi
		else
			FORM_user_path="$FTPDIR"
		fi
		
		if [ "$FORM_ok" = "" -a "$FORM_cancel" = "" ]
		then
			header
			echo "<h2>$_ctr_headeradduser</h2>"
			
			if [ "$msg" != "" ]
			then
				echo "<p><b>$msg</b></p>";
			fi
			
			echo "<form action=\"$myname\" method=\"POST\">"
			echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\"/>"
			echo "<input type=\"hidden\" name=\"command\" value=\"useradd\"/>"
			echo "<p><table cellpadding=\"0\" cellspacing=\"0\">"
			echo "<tr><td><b>General</b><br/><br/></td></tr>"
			echo "<tr><td>$_ctr_login:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_login\" size=\"20\" maxlength=\"64\" value=\"$FORM_user_login\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_password:&nbsp;&nbsp;</td><td><input type=\"password\" name=\"user_pwd\" size=\"20\" maxlength=\"64\" value=\"$FORM_user_pwd\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_password_repeat:&nbsp;&nbsp;</td><td><input type=\"password\" name=\"user_pwd2\" size=\"20\" maxlength=\"64\"/ value=\"$FORM_user_pwd2\"></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_localdir:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_path\" size=\"40\" maxlength=\"250\"  value=\"$FORM_user_path\"></tr>"
			echo "<tr><td colspan=\"2\" style="height:2px"></td></tr>"
			echo -n "<tr><td></td><td><input type=\"checkbox\" name=\"user_makedir\" id=\"user_makedir\" value=\"1\""
			if [ "$FORM_user_makedir" = "1" ]
			then
				echo -n "checked=\"checked\""
			fi
			echo "/><label for=\"user_makedir\"> $_ctr_createdir</label></td></tr>"
			echo "<tr><td><br/><b>Limits</b><br/><br/></td></tr>"
			echo "<tr><td>$_ctr_sessions:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_limitsessions\" size=\"6\" maxlength=\"6\" value=\"$FORM_user_limitsessions\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_ipaddress:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_limitip\" size=\"40\" maxlength=\"320\" value=\"$FORM_user_limitip\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_time:&nbsp;&nbsp;</td><td><input name=\"user_limittime\" size=\"9\" maxlength=\"9\" value=\"$FORM_user_limittime\"/> (hhmm-hhmm)</td></tr>"
			echo "</table></p>"
			echo "<p><input type=\"submit\" name=\"ok\" value=\"$_ctr_ok\">&nbsp;&nbsp;<input type=\"submit\" name=\"cancel\" value=\"$_ctr_cancel\"></p>"
			echo "</form>"
		fi
		;;
	
	useredit)
		if [ "$FORM_cancel" != "" ]
		then
			header 0
			echo "<h2>$_ctr_headeredituser</h2>"
			echo "<p>$_ctr_cancelled</p>"
			echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
		fi
		
		if [ "$FORM_ok" != "" ]
		then
			msg=""
			
			if [ "$FORM_user_pwd" != "$FORM_user_pwd2" ]
			then
				if [ "$msg" != "" ]
				then
					msg="$msg<br/>"
				fi
				msg="$msg""$_ctr_errorpassmatch"
				FORM_ok=""
			fi
			
			if [ ! -d "$FORM_user_path" -a "$FORM_user_makedir" != "1" ]
			then
				if [ "$msg" != "" ]
				then
					msg="$msg<br/>"
				fi
				msg="$msg""$_ctr_errordir"
				FORM_ok=""
			fi

			if [ "$FORM_ok" != "" ]
			then
				header
				echo "<h2>$_ctr_headeredituser</h2>"

				if [ "$FORM_user_makedir" = "1" ]
				then
					mkdir $FORM_user_path
					chown ftpuser.ftpgroup $FORM_user_path
				fi
				
				if [ -d "$FORM_user_path" ]
				then
					echo "<p>$_ctr_userupdating <b>$FORM_login</b>..."
					
					if [ "$FORM_user_pwd" != "" ]
					then
						(echo $FORM_user_pwd; echo $FORM_user_pwd) | pure-pw passwd "$FORM_login" -f $PWF 2>/dev/null >/dev/null
					fi
					pure-pw usermod "$FORM_login" -y "$FORM_user_limitsessions" -r "$FORM_user_limitip" -z "$FORM_user_limittime" -d "$FORM_user_path" -f $PWF 2>/dev/null >/dev/null
					pure-pw mkdb /etc/pureftpd.pdb -f $PWF 2>/dev/null >/dev/null
					
					echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
				else
					echo "<p><b>$_ctr_errordir $FORM_user_path!</b>"
					FORM_ok=""
				fi
			fi
		fi
		
		if [ "$FORM_ok" = "" -a "$FORM_cancel" = "" ]
		then
			header
			echo "<h2>$_ctr_headeredituser</h2>"
			
			if [ "$msg" != "" ]
			then
				echo "<p><b>$msg</b></p>";
			fi
			
			if [ "$FORM_reload" != "1" ]
			then
				cat "$PWF" >/tmp/pftpd_users.$$
			
				while read line
				do
					account=`echo $line | cut -d ":" -f 1`
					if [ "$account" = "$FORM_login" ]
					then
						FORM_user_path=`echo $line | cut -d ":" -f 6 | sed 's/\/\.\///g'`
						FORM_user_limitsessions=`echo $line | cut -d ":" -f 11`
						FORM_user_limitip=`echo $line | cut -d ":" -f 16`
						FORM_user_limittime=`echo $line | cut -d ":" -f 18`
					fi
				done </tmp/pftpd_users.$$
				rm /tmp/pftpd_users.$$
			fi
			
			echo "<form action=\"$myname\" method=\"POST\">"
			echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\"/>"
			echo "<input type=\"hidden\" name=\"command\" value=\"useredit\"/>"
			echo "<input type=\"hidden\" name=\"reload\" value=\"1\"/>"
			echo "<input type=\"hidden\" name=\"login\" value=\"$FORM_login\"/>"
			echo "<p><table cellpadding=\"0\" cellspacing=\"0\">"
			echo "<tr><td><b>General</b><br/><br/></td></tr>"
			echo "<tr><td>$_ctr_login:&nbsp;&nbsp;</td><td>$FORM_login</td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_password:&nbsp;&nbsp;</td><td><input type=\"password\" name=\"user_pwd\" size=\"20\" maxlength=\"64\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_password_repeat:&nbsp;&nbsp;</td><td><input type=\"password\" name=\"user_pwd2\" size=\"20\" maxlength=\"64\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_localdir:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_path\" size=\"20\"  maxlength=\"64\" value=\"$FORM_user_path\"/></tr>"
			echo "<tr><td colspan=\"2\" style="height:2px"></td></tr>"
			echo -n "<tr><td></td><td><input type=\"checkbox\" name=\"user_makedir\" id=\"user_makedir\" value=\"1\""
			if [ "$FORM_user_makedir" = "1" ]
			then
				echo -n "checked=\"checked\""
			fi
			echo "/><label for=\"user_makedir\"> $_ctr_createdir</label></td></tr>"
			echo "<tr><td><br/><b>Limits</b><br/><br/></td></tr>"
			echo "<tr><td>$_ctr_sessions:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_limitsessions\" size=\"6\" maxlength=\"6\" value=\"$FORM_user_limitsessions\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_ipaddress:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_limitip\" size=\"40\"  maxlength=\"320\" value=\"$FORM_user_limitip\"/></td></tr>"
			echo "<tr><td colspan=\"2\" style="height:4px"></td></tr>"
			echo "<tr><td>$_ctr_time:&nbsp;&nbsp;</td><td><input type=\"text\" name=\"user_limittime\" size=\"9\" maxlength=\"9\" value=\"$FORM_user_limittime\"/> (hhmm-hhmm)</td></tr>"
			echo "</table></p>"
			echo "<p><input type=\"submit\" name=\"ok\" value=\"$_ctr_ok\">&nbsp;&nbsp;<input type=\"submit\" name=\"cancel\" value=\"$_ctr_cancel\"></p>"
			echo "</form>"
		fi
		;;
	
	userdelete)
		if [ "$FORM_cancel" != "" ]
		then
			header 0
			echo "<h2>$_ctr_headerdeleteuser</h2>"
			echo "<p>$_ctr_cancelled</p>"
			echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
		fi
		
		if [ "$FORM_ok" != "" ]
		then
			header
			echo "<h2>$_ctr_headerdeleteuser</h2>"
			
			echo "<p>$_ctr_userdeleting <b>$FORM_login</b>...</p>"
			
			pure-pw userdel $FORM_login -f $PWF 2>/dev/null >/dev/null
			pure-pw mkdb /etc/pureftpd.pdb -f $PWF
			
			echo "<p><a href=\"$myname?action=opt_user\">$_ctr_continue</a></p>"
		fi
		
		if [ "$FORM_ok" = "" -a "$FORM_cancel" = "" ]
		then
			header
			echo "<h2>$_ctr_headerdeleteuser</h2>"
			
			echo "<form action=\"$myname\" method=\"POST\">"
			echo "<input type=\"hidden\" name=\"action\" value=\"opt_user\"/>"
			echo "<input type=\"hidden\" name=\"command\" value=\"userdelete\"/>"
			echo "<input type=\"hidden\" name=\"login\" value=\"$FORM_login\"/>"
			echo "<p>$_ctr_userdeleteconfirm</p>"
			echo "<p>$_ctr_login: <b>$FORM_login</b></p>"
			echo "<p><input type=\"submit\" name=\"ok\" value=\"$_ctr_ok\">&nbsp;&nbsp;<input type=\"submit\" name=\"cancel\" value=\"$_ctr_cancel\"></p>"
			echo "</form>"
		fi
		;;
	esac
	;;

opt_connections)
	header
	
	if [ "$FORM_command" = "" ]
	then
		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_connections\">"
		echo "<input type=\"submit\" value=\"$_con_refresh\">"
		echo "</form>"

		CONNLIST=`/usr/local/sbin/pure-ftpwho -s`
		if [ "$CONNLIST" = "" ]
		then
			echo "<p>$_con_noconnections"
		else
			echo "$CONNLIST" |
			(
			echo "<table class=\"normtable\">"
			echo "<tr><th>$_con_action</th><th>PID</th><th>$_con_account</th><th>$_con_time</th><th>$_con_state</th><th>$_con_speed</th><th>$_con_filename</th><th>$_con_remote</th><th>$_con_currentkb</th><th>$_con_totalkb</th><th>$_con_localhost</th></tr>"
			while read line
			do
				pid=`echo $line | cut -d "|" -f 1`
				acct=`echo $line | cut -d "|" -f 2`
				time=`echo $line | cut -d "|" -f 3`
				state=`echo $line | cut -d "|" -f 4`
				file=`echo $line | cut -d "|" -f 5`
				peer=`echo $line | cut -d "|" -f 6`
				local=`echo $line | cut -d "|" -f 7`
				port=`echo $line | cut -d "|" -f 8`
				current=`echo $line | cut -d "|" -f 9`
				total=`echo $line | cut -d "|" -f 10`
				percentage=`echo $line | cut -d "|" -f 11`
				bandwidth=`echo $line | cut -d "|" -f 12`

				if [ "$state" = "IDLE" ]
				then
					file="-"
					percentage="&nbsp;"
					echo "<tr valign=\"middle\" align=\"right\"><td><a href=\"$myname?action=opt_connections&command=kill&pid=$pid\"><b>$_con_kill</b></a></td><td>$pid</td><td>$acct</td><td>$time</td><td>$state $percentage</td><td>$bandwidth k/s</td><td>$file</td><td>$peer</td><td>$current</td><td>$total</td><td>$local:$port</td></tr>"
					else
					echo "<tr valign=\"middle\" align=\"right\"><td><a href=\"$myname?action=opt_connections&command=kill&pid=$pid\"><b>$_con_kill</b></a></td><td>$pid</td><td>$acct</td><td>$time</td><td>$state $percentage%</td><td>$bandwidth k/s</td><td>$file</td><td>$peer</td><td>$current</td><td>$total</td><td>$local:$port</td></tr>"
				fi
			done

			echo "</table>"
			)
		fi
	fi

	if [ "$FORM_command" = "kill" ]
	then
		echo "<p>$_con_killing $FORM_pid..."
		kill $FORM_pid

		echo "<p><form action=\"$myname\" method=\"get\">"
		echo "<input type=\"hidden\" name=\"action\" value=\"opt_connections\">"
		echo "<input type=\"submit\" value=\"$_ctr_continue\">"
		echo "</form>"
	fi
	;;

opt_logfile)
	header
	
	case $PFTPD_LOG_FORMAT in
		stats)
		cat <<-EOF
<p><form action="$myname" method="GET">
<input type="hidden" name="action" value="opt_logfile">
<input class="itext" type="text" size="3" maxlength="4" name="log_lines" value="$FORM_log_lines">&nbsp;$_log_lines&nbsp;&nbsp;
<input class="sbutton" type="submit" value="$_log_show">
<input class="sbutton" type="submit" name="showall" value="$_log_show_all">
<!-- <input class="sbutton" type="submit" name="download" value="$_log_download"> -->
<input class="sbutton" type="submit" name="clearlog" value="$_log_clear">
<input type="hidden" name="log_sort" value="$FORM_log_sort">
</form></p>
EOF
		;;
	esac

	if [ "$FORM_clearlog" != "" ]
	then
		if [ -f "$PFTPD_LOG_PATH" ]
		then
			rm $PFTPD_LOG_PATH
		fi
	fi

	if [ -f "$PFTPD_LOG_PATH" ]
	then
		echo "<table class=\"normtable\">"
	  
		if [ -n "$FORM_showall" ]
		then
			cat "$PFTPD_LOG_PATH" > /tmp/pftp_log.$$
		else
			cat "$PFTPD_LOG_PATH" | tail -n $FORM_log_lines > /tmp/pftp_log.$$
		fi
		
		case $PFTPD_LOG_FORMAT in
		stats)
		case $FORM_log_sort in
			normal)
			/usr/local/bin/pure-statsdecode /tmp/pftp_log.$$ > /tmp/pftp_log.$$.1
			;;
			
			*)
			/usr/local/bin/pure-statsdecode /tmp/pftp_log.$$ | sed '1!G;h;$!d' > /tmp/pftp_log.$$.1
			;;
		esac
		
		echo "<tr><th>"
		
		case $FORM_log_sort in
			normal)
			echo "<a href=\"$myname?action=opt_logfile&log_lines=$FORM_log_lines&showall=$FORM_showall&log_sort=reverse\">$_log_date<img src="/img/sreverse.gif"></a>"
			;;
			*)
			echo "<a href=\"$myname?action=opt_logfile&log_lines=$FORM_log_lines&showall=$FORM_showall&log_sort=normal\">$_log_date<img src="/img/snormal.gif"></a>"
			;;
		esac
		
		echo "</th><th>$_log_time</th><th>$_log_sessionid</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_time</th><th>$_log_file</th></tr>"
		while read date time1 session account ip state size time file
		do
			echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$time1</td><td>$session</td><td align=\"left\">$account</td><td>$ip</td><td align=\"center\">$state</td><td>$size</td><td>$time</td><td align=\"left\">$file</td></tr>"
		done < /tmp/pftp_log.$$.1
		rm -f /tmp/pftp_log.$$.1
		;;

		w3c)
		echo "<tr><th>$_log_date</th><th>$_log_time</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_file</th></tr>"
		while read date time1 ip state file x account size
		do
			echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$time1</td><td>$account</td><td>$ip</td><td>$state</td><td>$size</td><td>$file</td></tr>"
		done < /tmp/pftp_log.$$
		;;

		clf)
		echo "<tr><th>$_log_date</th><th>$_log_account</th><th>$_log_ip</th><th>$_log_du</th><th>$_log_size</th><th>$_log_file</th></tr>"
		while read ip x account date  c state file y size
		do
			echo "<tr valign=\"middle\" align=\"right\"><td>$date</td><td>$account</td><td>$ip</td><td>$state</td><td>$size</td><td>$file</td></tr>"
		done < /tmp/pftp_log.$$
		;;
		esac
		
		rm -f /tmp/pftp_log.$$
		echo "</table>"
	else
		echo "<p>$_log_empty"
	fi
	;;
esac

show_tab_footer
show_html_footer
