#!/bin/sh
##-------------------------------------------------------------------------------
## c3Surf   is Copyright (c)  2007 Frank Saurbier, fs, email: saurbier@arcor.de
## loginusr is Copyright (c)  2008 Frank Saurbier, fs, email: saurbier@arcor.de
##
## Creation:     14.08.2009  fs
## Last Update:  14.08.2009  fs
## Version:      2.3.1
##
## history:      08.2009: first c3surf multi language support for login form (fs)
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------
# Package Vars
. /var/run/c3surf.conf

eval "`proccgi $*`"
# this script sets the default language for the login form

# page logging
if [ "$C3SURF_DOLOG_PAGE" = "yes" ]
then
  /usr/local/bin/c3surf_log_page.sh "$C3SURF_LOG_PATH" "$REMOTE_ADDR" "$HTTP_USER_AGENT" "setlang.cgi:" "$FORM_language"
fi

# only do work if a language code ist transmitted
# de, en, es
# /srv/www/c3surf/index.cgi
# /srv/www/c3surf/c3surf_status.cgi
if [ -n $FORM_language ]
then
  echo "c3surf_login_lang=\"$FORM_language\"" > /srv/www/c3surf/lang/default
fi
# go back to login page
echo "Location: /"
echo
exit 0
# we need Package Vars
# if we do it that way
#. /var/run/c3surf.conf
#echo "Location: http://$C3SURF_HTTPD_HOST_NAME/"
#echo
#exit 0

