#!/bin/sh
##-------------------------------------------------------------------------------
## c3Surf   is Copyright (c)  2007 Frank Saurbier, fs, email: saurbier@arcor.de
## loginusr is Copyright (c)  2008 Frank Saurbier, fs, email: saurbier@arcor.de
##
## Creation:     17.04.2007  fs
## Last Update:  05.08.2008  fs
## Version:      2.1.0
## requires:
## history:      04.2008: c3surf erweitert um echtes login (fs)
##               08.2008: persistenten Pfad hinzugefgt fr user.data
##               09.2008: C3SURF_READ_PATH fr C3SURF_WORKON_TMP="yes"
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------
eval "`proccgi $*`"

# Package Vars
. /var/run/c3surf.conf

# Option: LOGINUSR
# Diese Seite erledigt die Nacharbeiten fr das echte Login

# Tricky: wir wollen kein autologin, wenn der Client bereits Usr/Pwd Kombination kennt
case $FORM_action in
  login)
    case "x$FORM_time" in
    x)
      echo "Location: /index.cgi"
      echo
    ;;
    *)
      ta=`date +%s`
      td=`expr $ta - $FORM_time`
      # only send 401 if time difference between login request and entered password is less or equal 2 seconds
      case $td in
      0|1|2)
        echo 'Status: 401 Unauthorized'
        echo 'WWW-Authenticate: Basic realm="login"'
        echo
      ;;
      *)
        if [ -n "$REMOTE_USER" ]
        then
          # lese Daten der Anmeldung
          if [ -f $C3SURF_TMP_PATH/$REMOTE_ADDR.time ]
          then
            {
              read oldtime oldcount oldid oldrest
            } < $C3SURF_TMP_PATH/$REMOTE_ADDR.time
          else
            oldid=""
          fi
          # call the worker, logout is mandatory if there is someone else online - only one login per IP!
          if [ "$REMOTE_USER" != "$oldid" ]
          then
            /usr/local/bin/c3surf_worker.sh "doAutoLogout" "$REMOTE_ADDR"
          fi
          /usr/local/bin/c3surf_worker.sh "doLogin" "$REMOTE_ADDR" "$REMOTE_USER"
        fi
        echo "Location: /index.cgi"
        echo
      ;;
      esac
    ;;
    esac
  ;;
  *)
     echo "Location: /index.cgi"
     echo
  ;;
esac