#!/bin/sh
##-------------------------------------------------------------------------------
## c3Surf is Copyright (c)  2009 Frank Saurbier, fs, email: 3surf@arcor.de
##
## Print Voucher Page - fli4l
##
## Creation:     24.06.2009  fs
## Last Update:  24.06.2000  fs
## Version: 	 2.3.0
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /var/run/c3surf.conf

# print voucher
_prt_h_head="---=== So geht es ins Internet ===---"
_prt_h_foot_1="Der Gutschein verfllt mit der ersten Anmeldung."
_prt_h_foot_2="Der Gutschein ist nach Anmeldung folgende Anzahl Stunden gltig:"
_prt_h_foot_3="Beliebige An- und Abmeldungen bis zum angegebenen Datum mglich."
_prt_h_uid="Benutzer"
_prt_h_pwd="Passwort"
_prt_h_time="Minuten"
_prt_h_valid="gltig bis"

my_n=0

###################################
simple_output ()
{
  htmlspecialchars | while read line
  do
    fsuid=`echo $line | cut -d "," -f 1`
    fspwd=`echo $line | cut -d "," -f 2`
    fstime=`echo $line | cut -d "," -f 3`
    fsvalid=`echo $line | cut -d "," -f 4`
    fslives=`echo $line | cut -d "," -f 5`

# table header
#echo "<table class=\"normtable\">"

my_foot="$_prt_h_foot_1"
if [ -n "$fslives" ]
then
  if [ $fslives -lt 0 ]; then my_foot="$_prt_h_foot_3"; fi
  # if [ $fslives -eq 0 ]; then my_foot="$_prt_h_foot_1"; fi
  if [ $fslives -gt 0 ]; then my_foot="$_prt_h_foot_2 $fslives"; fi
fi

if [ $my_n -ne 0 ]
then
  echo "<br>"
fi
my_n=`/usr/bin/expr $my_n "+" 1`
[ $my_n -ge 5 ] && $my_n=0

cat <<-EOF
<center><table border=2>
<colgroup>
  <col width="200">
  <col width="130">
  <col width="90">
  <col width="250">
</colgroup>
<tr>
<th colspan="4"><center><br>$_prt_h_head<br>&nbsp;</center></th>
</tr>
EOF

cat <<-EOF
<tr>
<th><center>$_prt_h_uid</center></th>
<th><center>$_prt_h_pwd</center></th>
<th><center>$_prt_h_time</center></th>
<th><center>$_prt_h_valid</center></th>
</tr>
EOF

cat <<-EOF
<tr>
<td><center><nobr>$fsuid</nobr></center></td>
<td><center><nobr>$fspwd</nobr></center></td>
<td><center><nobr>$fstime</nobr></center></td>
<td><center><nobr>$fsvalid</nobr></center></td>
</tr>
EOF

cat <<-EOF
<tr>
<td colspan="4"><center>$my_foot</center></td>
</tr>
</table><br>
EOF

  done
}

# show_html_header "3Surf Voucher Print $C3SURF_VERSION" "showmenu=no"

# ###
# Anfang generieren
# ###
# thx to Manfred: tell doctype with echo - cat forces Kapersky to alert phishing
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate, no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo

# ###
# Meta Daten
# ###
cat <<-EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="expires" content="0">
<meta name="description" content="Voucher Printer">
<meta name="author" content="Frank Saurbier">
<meta name="robots" content="noindex">
<title>Print Voucher</title>
</head>
<body text="#000000" bgcolor="#F0F0F0" link="#0000FF" vlink="#800000" alink="#FF0000">
EOF

[ -f $C3SURF_VOUCHER_PRINTFILE ] && /bin/cat $C3SURF_VOUCHER_PRINTFILE | simple_output

#
#show_html_footer
# ###
# der html footer
# ###
cat <<-EOF
<!--html footer-->
</body>
</html>