#!/bin/sh
# -----------------------------------------------------------------------------
# This file is part of opt_c3surf. For contact and licensing information, see
#   (fli4lroot)/config/c3surf.txt
# File: c3surf_countdown.sh (fs)
# -----------------------------------------------------------------------------
. /var/run/c3surf.conf
c3surf_reference_curfew=$(/bin/date +%H)
#
# ---------------------------------------------------
# - calc the timer 
# ---------------------------------------------------
calcTime()
{
  fsnow=`date +%s`
  fstime=`/usr/bin/expr $fstime - $fsnow`
}
#
# ---------------------------------------------------
# - check the ARP table and logout if IP is gone
# ---------------------------------------------------
checkArp()
{
  if [ "$C3SURF_CHECK_ARP" = "yes" ]
  then
    if [ -f /proc/net/arp ]
    then
      arp_ip_found="no"
      {
        read arp_header
        # while read arp_ip arp_hwtype arp_flags arp_mac arp_mask arp_device
        while read arp_ip arp_rest
        do
          if [ "$arp_ip" = "$fsip" ]
          then
            arp_ip_found="yes"
            break
          fi
        done
      } < /proc/net/arp
      # do the logout without counter Quota
      if [ "$arp_ip_found" = "no" ]
      then
        /usr/local/bin/c3surf_worker.sh "doArpLogout" "$fsip" "$fsid"
      fi # no IP found
    fi # check for /proc/net/arp
  fi # ARP-Check
}
# ---------------------------------------------------
# - check curfew and logout if it hits
# ---------------------------------------------------
checkCurfew()
{
  if [ "$C3SURF_CHECK_CURFEW" = "yes" ]
  then
    if [ -n "$fscurfew" ]
    then
      curfew_found="no"
      for i in $fscurfew
      do
        if [ $i -eq $c3surf_reference_curfew ]
        then
          curfew_found="yes"
          break
        fi
      done
      # do the logout without counter Quota
      if [ "$curfew_found" = "yes" ]
      then
        /usr/local/bin/c3surf_worker.sh "doCurfewLogout" "$fsip" "$fsid"
      fi # curfew found
    fi # check for fscurfew
  fi # CURFEW-Check
}
#
# ---------------------------------------------------
# - check the blocked UID/IP and unblock - parallel?
# ---------------------------------------------------
for f in $C3SURF_TMP_PATH/*.block
do
  # schliee den Abfrage-String aus
  if [ "$f" != "$C3SURF_TMP_PATH/*.block" ]
  then
    {
      read fstime c3surf_rest
    } < $f
    fsnow=`date +%s`
    fstime=`/usr/bin/expr $fstime - $fsnow`
    if [ $fstime -le 0 ]
    then
      rm -f "$f"
    fi
  fi
done
#
# ---------------------------------------------------
# - countdown the time for UID/IP
# ---------------------------------------------------
for f in $C3SURF_TMP_PATH/*.time
do
  # schliee den Abfrage-String aus
  if [ "$f" != "$C3SURF_TMP_PATH/*.time" ]
  then
    {
      read fstime fscount fsid fsip fsmac fsvorname fsname fsmail fscurfew
    } < $f
    # check (Admin) unlimited login
    if [ $fstime -eq 0 ]
    then
      if [ "$fsid" != "-" ]
      then
        # this is not an admin login, it is an unlimited: do arpcheck
        checkArp
      fi
    else
      # check the online time left
      calcTime
      if [ $fstime -le 0 ]
      then
        # this is a real quota limit logout
        /usr/local/bin/c3surf_worker.sh "doLogout" "$fsip" "$fsid"
      else
        # lets check the ARP if configured (soft logout)
        checkArp
      fi # Logout
    fi # unlimited (Admin) login
    # check all for curfew if configured (soft logout)
    checkCurfew
  fi # ignore *.time
done
#