#!/bin/sh
# #-------------------------------------------------------------------------------
# # faxsnd is Copyright (c)  2008 Frank Saurbier, fs, email: c3surf@arcor.de
# #
# # Admin Interface - faxsnd  - fli4l
# #
# # This program is free software; you can redistribute it and/or modify
# # it under the terms of the GNU General Public License as published by
# # the Free Software Foundation in Version 2; Not any previous or future
# # version.
# #-------------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /var/run/faxsnd.conf

faxsnd_tab_virgin=true
upl_status=""

###################################
simple_output ()
{
  htmlspecialchars | while read line
  do
    fstime=`echo $line | cut -d "|" -f 1`
    fsstatus=`echo $line | cut -d "|" -f 2`
    fsnstatus=`echo $line | cut -d "|" -f 3`
    fsphone=`echo $line | cut -d "|" -f 4`
    fsfile=`echo $line | cut -d "|" -f 5`
    fssent=`echo $line | cut -d "|" -f 6`
    if [ -f "$fssent" ]
    then
      fsaction="&nbsp;<a href=\"$myname?action=special&work=retry&faxfile=$fssent&faxphone=$fsphone\">$_log_retry_send</a>&nbsp;"
    else
      fsaction=$_log_no_file
    fi
cat <<-EOF
<tr>
<td><nobr>$fstime</nobr></td>
<td><nobr>$fsstatus ($fsnstatus)</nobr></td>
<td><nobr>$fsphone</nobr></td>
<td><nobr>`basename "$fsfile"`</nobr></td>
<td><nobr>$fsaction</nobr></td>
</tr>
EOF
  #
  #echo "<tr>\
  #<td><nobr>$fstime</nobr></td>\
  #<td><nobr>$fsstatus ($fsnstatus)</nobr></td>\
  #<td><nobr>$fsphone</nobr></td>\
  #<td><nobr>$fsfile</nobr></td>\
  #<td><nobr>$fsaction</nobr></td>\
  #</tr>"
  #
  done
}
#

# ###########################################
# Rechte checken (im Moment nur faxsnd:allow)
# ###########################################
check_rights "faxsnd" "allow"

# hack for proper tab-selection, inspired by pf.cgi
: ${FORM_action:=logview}
: ${FORM_work:=}

# ####################################################
# beginne mit der Arbeit, dann klappt auch der refresh
# ####################################################
case $FORM_action in

  upload)
    case "$FORM_work" in
      error)
        upl_status="ERROR: no upload and no fax received for the send queue."
      ;;

      ok)
        if [ -f "$FORM_faxfile" ]
        then
          my_base=$(basename "$FORM_faxfile")
          my_call=$(echo $my_base | cut -d "." -f 1)
          my_file=$(echo $my_base | cut -d "." -f 2)
          my_time="$(date +%Y.%m.%d-%H:%M:%S)"
          my_fax=$(echo "$my_call.$my_time.$my_file.sff")
          mv -f "$FORM_faxfile" "$FAXSND_QUEUE/$my_fax"
          echo "UPLOAD: new fax in queue: $my_fax" > "$FAXSND_QUEUE/.status"
          myrefresh="yes"
          FORM_action="logview"
        else
          upl_status="ERROR: upload file not found, $FORM_faxfile."
        fi
      ;;

    esac
  ;;

  logview)
    if [ -n "$FORM_clearlog_yes" -a -n "$FORM_subaction" ]
    then
      # -------------------- not good for logs
      # rm -f $FAXSND_LOG/$FORM_subaction
      # --------------------------------------
      > $FAXSND_LOG/$FORM_subaction
      # --------------------------------------
      # unset FORM_subaction
      # --------------------------------------
      FORM_subaction=""
      myrefresh="yes"
    fi
  ;;

  queue)
    case $FORM_work in

      delete)
        rm -f $FORM_faxfile
        myrefresh="yes"
        FORM_action="logview"
      ;;

      jobstart)
        echo "QUEUE: faxsend job started by user." > "$FAXSND_QUEUE/.status"
        {
          /usr/local/bin/faxsnd_workFax.sh 2>/dev/null
        } 1>/dev/null &
        myrefresh="yes"
        FORM_action="logview"
      ;;

      on)
        rm -f "$FAXSND_QUEUE/.off"
        myrefresh="yes"
        FORM_action="logview"
      ;;

      off)
        > "$FAXSND_QUEUE/.off"
        myrefresh="yes"
        FORM_action="logview"
      ;;

    esac
  ;;

  special)
    if [ "$FORM_work" = "retry" ]
    then
      cp -f $FORM_faxfile $FAXSND_QUEUE/$FORM_faxphone.$$.sff
      myrefresh="yes"
      FORM_action="logview"
    fi
  ;;

  faxsent)
    if [ "$FORM_work" = "delete" ]
    then
      rm -f $FORM_faxfile
      myrefresh="yes"
    fi
  ;;

esac

# ####################################################
# mache eine Refresh, damit die get-Parameter aus dem Browser verschwinden
# ####################################################
if [ "$myrefresh" = "yes" ]
then
  echo "Location: $myname?action=$FORM_action"
  echo
  exit
fi

# nur die "logview" Seite aktualisieren
if [ "$FORM_action" = "logview" ]
then
  if [ -f "$FAXSND_QUEUE/.workFax" ]
  then
    show_html_header "FaxSend $FAXSND_VERSION" "refresh=20;url=$myname?action=$FORM_action"
  else
    show_html_header "FaxSend $FAXSND_VERSION" "refresh=300;url=$myname?action=$FORM_action"
  fi
else
  show_html_header "FaxSend $FAXSND_VERSION"
fi

# echo "<h2>3Surf&nbsp;Admin&nbsp;&nbsp;&nbsp;&rarr;&nbsp;<a href=\"http://$C3SURF_HTTPD_HOST_NAME/\" target=\"_blank\">LoginUsr&nbsp;Anmeldeseite</a>&nbsp;&larr;</h2>"
echo "<br>"


#
#################################
# Tabs ausgeben
#################################
show_tab_header "$_logview" "$myname?action=logview" \
                "$_upload" "$myname?action=upload" \
                "$_faxsent" "$myname?action=faxsent"


case $FORM_action in
  #################################
  ###      TAB: Upload         ###
  #################################
  upload)

  if [ -n "$upl_status" ]
  then
    echo "<h2>&nbsp;<font color=\"red\">&nbsp;$upl_status<font color=\"normal\"></h2>"
  fi


# ---------------------------
# Arbeitsbereich Upload
# ---------------------------
cat <<-EOF
<h1>$_upl_head</h1>
<form action="./faxsnd_upload.cgi" method="post" enctype="multipart/form-data">
<p>$_upl_fileselect<br>
<input name="fxdatei" type="file" size="50" maxlength="8000000" accept="text/*">
</p>
<br>$_upl_faxnumber <INPUT type="text" name="fxreceiver" size="20" value="">
<br>$_upl_faxnumber_comment
<br>
<br><h2>$_upl_faxwarning</h2>
<br><input type=submit value="Send"> <input type=reset value="Cancel">
EOF
  ;;

  #################################
  ### anfang   TAB: Logview     ### und Queue
  #################################
  logview)
  # Ausstehende Faxe zeigen
    echo "<table class=\"normtable\">"
    # Faxe suchen

    if [ -f "$FAXSND_QUEUE/.off" ]
    then
      echo "<h2>&nbsp;<font color=\"red\">&nbsp;off&nbsp;<font color=\"normal\"<a href=\"$myname?action=queue&work=on\">$_log_faxstatus_off</a>&nbsp;</h2>"
    else
      echo "<h2>&nbsp;<font color=\"green\">&nbsp;&nbsp;on&nbsp;<font color=\"normal\"<a href=\"$myname?action=queue&work=off\">$_log_faxstatus_on</a>&nbsp;</h2>"
    fi

    if [ -f "$FAXSND_QUEUE/.status" ]
    then
      echo "<h2>&nbsp;<font color=\"green\">&nbsp;`cat "$FAXSND_QUEUE/.status"`<font color=\"normal\"></h2>"
      rm -f "$FAXSND_QUEUE/.status"
    fi

    if [ -f "$FAXSND_QUEUE/.workFax" ]
    then
      echo "<h2>&nbsp;<font color=\"blue\">&nbsp;JOB: faxsend is active.<font color=\"normal\"></h2>"
    fi

    my_queue="full"
    for f in $FAXSND_QUEUE/*.sff
    do
      # schliee den Abfrage-String aus
      if [ "$f" = "$FAXSND_QUEUE/*.sff" ]
      then
        show_info "$_queue_info_head" "$_queue_info_nothing_txt"
        my_queue="empty"
      else
        # Ausgabe der Header (einmalig)
        if [ $faxsnd_tab_virgin = true ]
        then
          cat <<-EOF
            &nbsp;<h2>$_queue_for_send</h2>
            <tr>
            <td><center><b>$_gen_h_file</b></center></td>
            <td><center><b>$_gen_h_action</b></center></td>
            </tr>
EOF
          faxsnd_tab_virgin=false
        fi

        # Ausgabe der Inhalte
        cat <<-EOF
          <tr>
          <td><center>`basename "$f"`</center></td>
          <td><center>
          &nbsp;<a href="$myname?action=queue&work=delete&faxfile=$f">$_queue_delete</a>&nbsp;
          </center></td></tr>
EOF
      # Ende else
      fi
    done
    # Tabelle schlieen
    echo "</table>"
    if [ "$my_queue" = "full" ]
    then
      echo "&nbsp;<font color=\"blue\">--==&nbsp;<b><a href=\"$myname?action=queue&work=jobstart\">$_log_faxsendall</a></b>&nbsp;==--&nbsp;"
    fi


    # Start with logview
    # init for log
    faxsnd_tab_virgin=true
    echo "<hr noshade size="1">"

    # some constants (basename of log) = sort order of logfiles
    log_file1="faxsnd.log"
#    log_file2="any.log"
    _log_sort_normal_idx="1"
    _log_sort_reverse_idx="2"

    # some defaults
    : ${FORM_log_lines:=30}
    : ${FORM_log_sort:=$_log_sort_reverse_idx}
    : ${FORM_showall:=}

    #################################
    # Tabs generieren
    #################################

    fs_tabs=""
    for f in "$log_file1"
    do
      # teste ob Datei da ist
      # if test -f $FAXSND_LOG/$f
      # teste ob Datei mit Inhalt da ist
      if test -s $FAXSND_LOG/$f
      then
        echo "&nbsp;<h2>$_log_to_view</h2>"
        : ${FORM_subaction:=$f}
        if [ $FORM_subaction = $f ]
        then
          fs_tabs=$(echo "$fs_tabs" "$f" "no")
        else
          fs_tabs=$(echo "$fs_tabs" "$f" "$myname?action=logview&subaction=$f&log_sort=$FORM_log_sort&log_lines=$FORM_log_lines")
        fi
      fi
    done

    #################################
    # Tabs ausgeben
    #################################
    if [ -n "$fs_tabs" ]
    then

      # prepare select field for sort
      log_sorta_idx=$FORM_log_sort
      if [ $log_sorta_idx -eq $_log_sort_reverse_idx ]
      then
        log_sortb_idx=$_log_sort_normal_idx
        log_sortb_txt=$_log_sort_normal_txt
        log_sorta_txt=$_log_sort_reverse_txt
      else
        log_sortb_idx=$_log_sort_reverse_idx
        log_sortb_txt=$_log_sort_reverse_txt
        log_sorta_txt=$_log_sort_normal_txt
      fi

      # formular Auswahl
      cat <<-EOF
<br>
<form action="$myname" method="GET">
&nbsp;<select name="log_sort">
<option value="$log_sorta_idx">$log_sorta_txt</option>
<option value="$log_sortb_idx">$log_sortb_txt</option>
</select>
<input type="hidden" name="action" value="logview">
<input type="hidden" name="subaction" value="$FORM_subaction">
<input class="itext" type="text" size="3" maxlength="4" name="log_lines" value="$FORM_log_lines">&nbsp;
<input class="sbutton" type="submit" value="$_log_refresh">&nbsp;
<input class="sbutton" type="submit" name="showall" value="$_log_show_all">
<!-- <input class="sbutton" type="submit" name="download" value="$_log_download"> -->
&nbsp;&nbsp;<input class="sbutton" type="submit" name="clearlog" value="$_log_clear">
EOF

      if [ -n "$FORM_clearlog" ]
      then
        cat <<-EOF
&rarr;<input class="sbutton" type="submit" name="clearlog_yes" value="$_log_clear_yes">
EOF
      fi

      cat <<-EOF
</form>
EOF

      if [ -n "$FORM_clearlog" ]
      then
        show_info "$FORM_subaction" "$_log_clear_question"
      else
        show_tab_header $fs_tabs

        # table header
        echo "<table class=\"normtable\">"

          if [ $faxsnd_tab_virgin = true ]
          then
            case $FORM_subaction in
              $log_file1)
                echo "<tr>\
                 <th><center>$_gen_h_timestamp</center></th>\
                 <th><center>$_gen_h_status</center></th>\
                 <th><center>$_gen_h_phone</center></th>\
                 <th><center>$_gen_h_file</center></th>\
                 <th><center>$_gen_h_action</center></th>\
                 </tr>"
              ;;
              *)
                echo "<tr>\
                 <th><left><nobr>$_gen_h_generic</nobr></left></th>\
                 </tr>"
            esac
            faxsnd_tab_virgin=false
          fi

        # generischer Teil
        if [ -n "$FORM_showall" ]
        then
          if [ $FORM_log_sort -eq $_log_sort_reverse_idx ]
          then
            cat $FAXSND_LOG/$FORM_subaction | sed '1!G;h;$!d' | simple_output
          else
            cat $FAXSND_LOG/$FORM_subaction | simple_output
          fi
        else
          if [ $FORM_log_sort -eq $_log_sort_reverse_idx ]
          then
            cat $FAXSND_LOG/$FORM_subaction | do_tail $FORM_log_lines | sed '1!G;h;$!d' | simple_output
          else
            cat $FAXSND_LOG/$FORM_subaction | do_tail $FORM_log_lines | simple_output
          fi
        fi

        # Tabelle schlieen
        echo "</table>"

        show_tab_footer

      fi # Lschen Besttigen

    else
      show_info "$_log_info_head" "$_log_no_logfile"
    fi
  # Ende TAB:logview [main=logview]
  #################################
  ### ende   TAB: Logview   ###
  #################################
  ;;

  #################################
  ### anfang   TAB: Faxsent     ###
  #################################
  faxsent)

# Gesendete Faxe anzeigen

    echo "<table class=\"normtable\">"
    # Faxe suchen
    for f in $FAXSND_DONE/*.sff
    do
      # schliee den Abfrage-String aus
      if [ "$f" = "$FAXSND_DONE/*.sff" ]
      then
        show_info "$_gen_info_head" "$_sent_info_nothing_txt"
      else
        # Ausgabe der Header (einmalig)
        if [ $faxsnd_tab_virgin = true ]
        then
          cat <<-EOF
            &nbsp;<h2>$_sent_for_view</h2>
            <tr>
            <td><center><b>$_gen_h_file</b></center></td>
            <td><center><b>$_gen_h_action</b></center></td>
            </tr>
EOF
          faxsnd_tab_virgin=false
        fi

        # Ausgabe der Inhalte
        cat <<-EOF
          <tr>
          <td><center>`basename "$f"`</center></td>
          <td><center>
          &nbsp;<a href="$myname?action=faxsent&work=delete&faxfile=$f">$_sent_delete</a>&nbsp;
          </center></td></tr>
EOF
      # Ende else
      fi
    done
    # Tabelle schlieen
    echo "</table>"

  #################################
  ### ende   TAB: Faxsent   ###
  #################################
  ;;



  *)
    show_error "$_tab_gen_err_title" "$_tab_gen_err_unknowntab_text"

esac

#
show_tab_footer

#
show_html_footer
