#!/bin/sh
# #############################################################
# Zentrales c3Surf Modul.....
# (fs) 2008
# Version: 2.2.1
# #############################################################
# habe dies Design gewählt, weil jedes Modul wieder
# die c3Surf Variablen initialisieren musste.
# Es wird viel Global benötigt. -- nix für Softwareengineers
# #############################################################
# params:
# $1 : Command
# $2 : IP-Address (REMOTE_ADDR)
# $3 : ID: UserID (LoginUsr), ProcessID (3Surf)
# $4 : forename (3Surf)
# $5 : surename (3Surf)
# $6 : email (3Surf)
# $7 : mac address (optional)  <--- OBSOLETE 08.2008
# #############################################################
# FUNCTIONS
# #############################################################
# Testing Vars
# write some output to /tmp ("+"), to be silent comment it out
#DEBUG_INFO="+"

# #################################################
# initVars
# #################################################

# name: user data file
initUserVar()
{
  # READ_PATH is for C3SURF_WORKON_TMP
  c3surf_un="$C3SURF_READ_PATH/$c3surf_id.data"
  # allow only one login
  c3surf_on="$C3SURF_TMP_PATH/$c3surf_id.online"
}

# read the user.data file
readUserVar()
{
  if [ -f "$c3surf_un" ]
  then
    . "$c3surf_un"
  fi
}

# set the user defaults to global
setUserDefaults()
{
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    # C3SURF_TIME
    if [ -n "$fssecs" ]
    then
      C3SURF_SECS=$fssecs
    fi
    # C3SURF_BLOCKSECS
    if [ -n "$fsblocksecs" ]
    then
      C3SURF_BLOCKSECS=$fsblocksecs
    fi
    # C3SURF_COUNTER
    if [ -n "$fscounter" ]
    then
      C3SURF_COUNTER=$fscounter
    fi
  fi
}

# #################################################
# log
# #################################################

# log valid Logins
logValid()
{
  if [ $C3SURF_DOLOG_LOGIN = yes ]
  then
    if [ $# -gt 0 ]
    then
      echo "$c3surf_log_ts|$c3surf_ip|$c3surf_id|$c3surf_vorname|$c3surf_name|$c3surf_mail|$c3surf_mac|$1" >> "$C3SURF_LOG_PATH/c3surf_login.log"
    else
      echo "$c3surf_log_ts|$c3surf_ip|$c3surf_id|$c3surf_vorname|$c3surf_name|$c3surf_mail|$c3surf_mac|unknown" >> "$C3SURF_LOG_PATH/c3surf_login.log"
    fi
  fi
}

# log invalid logins
logInvalid()
{
  if [ "$C3SURF_DOLOG_INVALID" = "yes" ]
  then
    echo "$c3surf_log_ts|$c3surf_mac|$c3surf_cstatus $c3surf_sstatus|$c3surf_ip|$c3surf_id $c3surf_vorname $c3surf_name $c3surf_mail" >> "$C3SURF_LOG_PATH/c3surf_invalid.log"
  fi
}

# log worker events
logWorker()
{
  echo "$c3surf_log_ts|$c3surf_cmd|$c3surf_ip|$c3surf_id|$c3surf_vorname|$c3surf_name|$c3surf_mail|$c3surf_mac|$c3surf_error" >> "$C3SURF_LOG_PATH/c3surf_worker.log"
}

# #################################################
# html
# #################################################
# feed the status-frame of the html page
# allways use the IP-address here
printHtmlStatus()
{
  echo "$c3surf_sstatus" > "$C3SURF_TMP_PATH/$c3surf_ip.status"
[ $DEBUG_INFO ] && echo "DEBUG $c3surf_id : $c3surf_sstatus" > "$C3SURF_TMP_PATH/$c3surf_ip.status"
}

# #################################################
# mac
# #################################################

# get mac for the IP from ARP
# sets: c3surf_mac
getMacFromArp()
{
  {
    read arp_header
    while read arp_ip arp_hwtype arp_flags arp_mac arp_mask arp_device
    do
      if [ $tmp_arp_mac ]; then break; fi
      if [ "$arp_ip" = "$c3surf_ip" ]
      then
        tmp_arp_mac="$arp_mac"
      fi
    done
  } < /proc/net/arp
  # no capital letters
  c3surf_mac="$(echo "$tmp_arp_mac" | sed -e 'y/ABCDEF/abcdef/')"
  # etwas aufräumen
  unset arp_header arp_ip arp_hwtype arp_flags arp_mac arp_mask arp_device tmp_arp_mac
} # getMacFromArp


# #################################################
# TimeBlock (Quota, Admin)
# block IP or ID for C3SURF_BLOCKTIME minutes
# #################################################
# fileformat: c3surf_block_time c3surf_mac c3surf_id $c3surf_ip
# optional parameter: block_secs
initTimeBlockVar()
{
  if [ $# -gt 0 ]
  then
    c3surf_time_block=$1
  else
    c3surf_time_block=$C3SURF_BLOCKSECS
  fi
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    c3surf_bn="$C3SURF_TMP_PATH/$c3surf_id.block"
  else
    c3surf_bn="$C3SURF_TMP_PATH/$c3surf_ip.block"
  fi
}

addTimeBlock()
{
  if [ $c3surf_time_block -ge 0 ]
  then
    if [ $c3surf_time_block -eq 0 ]
    then
      # block until tomorrow "00:00"
      c3surf_block_time=$c3surf_tomorrow_ts
    else
      c3surf_block_time=$(/usr/bin/expr $c3surf_reference_ts + $C3SURF_BLOCKSECS)
    fi
    # !! write TimeBlock
    echo "$c3surf_block_time" "$c3surf_mac" "$c3surf_id" "$c3surf_ip" > "$c3surf_bn"
  fi
} # addTimeBlock

removeTimeBlock()
{
  rm -f "$c3surf_bn"
} # removeTimeBlock


# #################################################
# setIPFilter
# #################################################
openIPFilter()
{
  /sbin/iptables -t nat -I c3surf_nat_control 1 -s $c3surf_ip -j RETURN
  /sbin/iptables -I c3surf_control 1 -s $c3surf_ip -j RETURN
}

closeIPFilter()
{
  /sbin/iptables -D c3surf_control -s $c3surf_ip -j RETURN
  /sbin/iptables -t nat -D c3surf_nat_control -s $c3surf_ip -j RETURN
}

# #################################################
# read/write-User is online
# #################################################

writeUserOnline()
{
  echo "$c3surf_id" "$c3surf_ip" "$c3surf_mac" > "$c3surf_on"
}

readUserOnline()
{
  {
    read "c3surf_online_id" c3surf_online_ip c3surf_online_mac
  } < "$c3surf_on"
}

removeUserOnline()
{
  rm -f "$c3surf_on"
}

# #################################################
# read/write-Timer
# setzt den Timer für die IP oder ID
# #################################################
#
# fileformat: c3surf_time c3surf_count c3surf_id c3surf_ip c3surf_mac c3surf_vorname c3surf_name c3surf_mail

# set filename for timer: always subst user to IP
initTimerVar()
{
  c3surf_tn="$C3SURF_TMP_PATH/$c3surf_ip.time"
}

writeTimer()
{
  echo "$c3surf_time" "$c3surf_count" "$c3surf_id" "$c3surf_ip" "$c3surf_mac" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" > "$c3surf_tn"
}

readTimer()
{
  {
    read c3surf_time c3surf_count c3surf_id c3surf_ip c3surf_mac c3surf_vorname c3surf_name c3surf_mail
  } < "$c3surf_tn"
}

removeTimer()
{
  rm -f "$c3surf_tn"
}

# used by login
setTimer()
{
if [ -f $c3surf_tn ]
then
  readTimer
  c3surf_count=$(/usr/bin/expr $c3surf_count + 1)
  # nur Zähler erhöhen, nicht Zeit verlängern
  # fstime=`date +%s`
  # c3surf_time=`expr $fstime + $C3SURF_SECS`
  # /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" "$c3surf_mac" "prolong:$c3surf_count"
  # es ist die erste Anmeldung
else
  c3surf_count="0"
  if [ "$c3surf_id" = "-" ]
  then
    # the c3surf_tn is initialised with IP-address
    c3surf_time="0"
    if [ -z "$c3surf_mac" ]
    then
      c3surf_mac="-"
    fi
  else
    c3surf_time=$(/usr/bin/expr $c3surf_reference_ts + $C3SURF_SECS)
  fi
  openIPFilter
fi
writeTimer
} # setTimer

# =====
# QUOTA
# =====
# set quota PATH
initQuotaVar()
{
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    # check for unlimited login by admin
    if [ "$c3surf_id" = "-" ]
    then
      C3SURF_QUOTA="admin"
      c3surf_qn=""
    else
      if [ "$OPT_LOGINUSR" = "yes" ]
      then
        # ID: LoginUsr
        c3surf_qn="$C3SURF_TMP_PATH/$c3surf_id.quota"
      else
        # IP: FreeSurf
        c3surf_qn="$C3SURF_TMP_PATH/$c3surf_ip.quota"
      fi
    fi
  fi
  c3surf_quota_block="none"
}

calcQuota()
{
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    # tmpnow=$(/bin/date +%s) <-- better use $c3surf_reference_ts
    c3surf_quota_time=$(/usr/bin/expr $c3surf_time - $c3surf_reference_ts)
    # special: counter<0 do not recognize the counter 
    if [ $c3surf_quota_maxcount -lt 0 ]
    then
      c3surf_quota_count=$c3surf_quota_maxcount
    else
      # for doAutoLogout do not increase count
      if [ -z "$c3surf_quota_nocount" ]
      then
        c3surf_quota_count=$(/usr/bin/expr $c3surf_quota_count + 1)
      fi
    fi
  fi
}

writeQuota()
{
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    echo "$c3surf_quota_ts $c3surf_quota_time $c3surf_quota_maxtime $c3surf_quota_count $c3surf_quota_maxcount" > "$c3surf_qn"
  fi
}

# used by doLogout
removeQuota()
{
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    rm -f "$c3surf_qn"
  fi
}

# calc a quota timestamp
calcQuotaTimestamp()
{
  if [ $C3SURF_BLOCKSECS -ge 0 ]
  then
    if [ $C3SURF_BLOCKSECS -eq 0 ]
    then
      # until tomorrow "00:00"
      c3surf_quota_ts=$c3surf_tomorrow_ts
    else
      # until block and surf time
      c3surf_quota_ts=$(/usr/bin/expr $c3surf_reference_ts + $C3SURF_BLOCKSECS + $C3SURF_SECS)
    fi
   else
    # c3surf_quota_ts=$c3surf_reference_ts
    c3surf_quota_ts=0
  fi
}

# read the quotas and set defaults
# and check the quota timestamp
readQuota()
{
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    if [ -f "$c3surf_qn" ]
    then
      {
        read c3surf_quota_ts c3surf_quota_time c3surf_quota_maxtime c3surf_quota_count c3surf_quota_maxcount
      } < "$c3surf_qn"
      # check for valid timestamp
      if [ $c3surf_quota_ts -gt 0 -a $c3surf_reference_ts -gt $c3surf_quota_ts ]
      then
        # quota expired
        calcQuotaTimestamp
        c3surf_quota_maxtime=$C3SURF_SECS
        c3surf_quota_maxcount=$C3SURF_COUNTER
        c3surf_quota_count=0
        c3surf_quota_time=$c3surf_quota_maxtime
        # update expired data
        writeQuota
      else
        # adjust the global login time to quota
        C3SURF_SECS=$c3surf_quota_time
      fi
    else
      calcQuotaTimestamp
      c3surf_quota_maxtime=$C3SURF_SECS
      c3surf_quota_maxcount=$C3SURF_COUNTER
      c3surf_quota_count=0
      c3surf_quota_time=$c3surf_quota_maxtime
      # save the quota (preserve timestamp)
      writeQuota
    fi
  fi
}

# checks Quota and makes a block
checkQuota()
{
  initQuotaVar
  if [ "$C3SURF_QUOTA" = "yes" ]
  then
    # read the user.data
    readUserVar
# [ $DEBUG_INFO ] && set > /tmp/readuser.var
    # set the user specific values
    setUserDefaults
# [ $DEBUG_INFO ] && set > /tmp/userdefaults.var
    readQuota
    calcQuota
    writeQuota
# [ $DEBUG_INFO ] && set > /tmp/userquota.var
    if [ $c3surf_quota_time -le 0 ]
    then
      # quota block
      c3surf_quota_block="time"
    else
      if [ $c3surf_quota_count -gt $c3surf_quota_maxcount ]
      then
        c3surf_quota_block="count"
      else
        c3surf_quota_block="none"
      fi
    fi
  fi
}

# ======
# LOGOUT
# ======
###################################################
# 3surf: logout this IP
# parameter: $1 = IP-address, $2 optional = action (counter, logout)
#
# Frank Saurbier, 2007, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
###################################################
# logout the user
# optional Parameter: $1 log message default: "logout"
doLogout()
{
  if [ -f "$c3surf_tn" ]
  then
    if [ $# -gt 0 ]
    then
      log_msg="$1"
    else
      log_msg="logout"
    fi

    # read the Timer Data
    readTimer

    if [ "$OPT_LOGINUSR" = "yes" ]
    then
      # set the Variables for user-files
      initUserVar
      # remove online flag
      removeUserOnline
    fi

    checkQuota
    if [ "$c3surf_quota_block" = "none" ]
    then
      # log the logout
      logValid "$log_msg"
    else
      initTimeBlockVar
      addTimeBlock
      logValid "$log_msg:quota:$c3surf_quota_block"
      removeQuota
    fi

    removeTimer
  fi

  # always close the iptable rule
  closeIPFilter
}

# logout anc caltulate time, but do not increase the quota counter
doAutoLogout()
{
  c3surf_quota_nocount="yes"
  doLogout "$1"
}

# logout without Quota-Check or Calculation
doAdminLogout()
{
  C3SURF_QUOTA="Admin"
  doLogout "$1"
}


# =====
# LOGIN
# =====
# ##################################################
# 3surf: check the post-method and login if everything is ok
# parameter: 1.IP-address, 2.id, 3.vorname, 4.name, 5.mail
# /usr/local/bin/c3surf_login.sh "$REMOTE_ADDR" "$fsid" "$fsvorname" "$fsname" "$fsmail"
# Frank Saurbier, 2008, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
# nicht sourcen: endet mit exit code
# ##################################################
# c3surf_nstatus > 0 Status for html
# c3surf_nstatus = 0 Login erlaubt
# c3surf_nstatus < 0 no Login and no Status for html
checkLogin()
{
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    # check Admin login
    initUserVar
    if [ -f "$c3surf_un" ]
    then
      if [ -f "$c3surf_on" ]
      then
        c3surf_sstatus="$c3surf_login_msg_multilogin"
        c3surf_nstatus=7
        c3surf_cstatus="multi_login:"
      else
      . "$c3surf_un"
      fi
    else
      c3surf_sstatus="$c3surf_login_msg_nouser"
      c3surf_nstatus=7
      c3surf_cstatus="unknown_user:"
    fi
  else
    # check all params
    if [ -z "$c3surf_vorname" -o -z "$c3surf_name" -o -z "$c3surf_mail" ]
    then
      # missing params = no login
      c3surf_sstatus="$c3surf_login_msg_noparm"
      c3surf_nstatus=7
      c3surf_cstatus="param_error:"
    else
      # test for double post
      if [ -f "$c3surf_tn" ]
      then
        # check the id to identify a double POST from html
        {
          read fs_time fs_count fs_id fs_rest
        } < "$c3surf_tn"
        if [ "$fs_id" = "$c3surf_id" ]
        then
          # this was a double POST -- silent Error
          # silent errors are less than 0
          c3surf_nstatus=-1
          c3surf_cstatus="double_post:"
        fi # id is the same = same process calls us
      fi # file for IP exists
    fi # check login and double post
  fi # LoginUsr

  # go on with some general tests

  # system locked
  if [ $c3surf_nstatus -eq 0 ]
  then
    # System is locked
    if [ -f $C3SURF_SYSLOCK_FILE ]
    then
      # system lock: no login
      c3surf_sstatus="$c3surf_login_msg_syslock"
      c3surf_nstatus=7
      c3surf_cstatus="system_lock:"
    fi
  fi

  # mac blacklist
  if [ $c3surf_nstatus -eq 0 ]
  then
    # check the c3surf MAC-blocklist
    if [ -z "$c3surf_mac" ]
    then
      # fatal error, we have no mac-address
      c3surf_sstatus="$c3surf_login_msg_nomac"
      c3surf_nstatus=7
      c3surf_cstatus="no_mac-address:"
    else
      if [ -s "$C3SURF_BLACKLIST_FILE" ]
      then
        # blacklist lesen und mac vergleichen
        {
          while read fs_mac fs_rest
          do
            if [ "$fs_mac" = "$c3surf_mac" ]
            then
              # login leider nicht erlaubt
              c3surf_sstatus="$c3surf_login_msg_macblack"
              c3surf_nstatus=7
              c3surf_cstatus="mac-blacklist:"
              break
            fi
          done
        } < "$C3SURF_BLACKLIST_FILE"
      fi # end blacklist
    fi # no mac address
  fi

  # Quotas: IP or ID block (check initTimeBlockVar -> c3surf_bn)
  if [ $c3surf_nstatus -eq 0 ]
  then
    initTimeBlockVar
    if [ -s "$c3surf_bn" ]
    then
      # login not permitted: quota block
      c3surf_sstatus="$c3surf_login_msg_quotablock"
      c3surf_nstatus=7
      c3surf_cstatus="quota-block:"
    fi
    # Ende ip-Block
  fi

  if [ $c3surf_nstatus -eq 0 ]
  then
    # login is allowed
    c3surf_sstatus="$c3surf_login_msg_ok"
  fi
}


# worker for command "doLogin"
doLogin()
{
  checkLogin
  # html status feedback
  printHtmlStatus
  # Login
  if [ $c3surf_nstatus -eq 0 ]
  then
    setUserDefaults
    initQuotaVar
    if [ "$C3SURF_QUOTA" = "yes" ]
    then
      readQuota
    fi
    # do the login (set the timer)
    setTimer
    if [ "$OPT_LOGINUSR" = "yes" ]
    then
      writeUserOnline
    fi
    # log it
    logValid "login"
  else
    logInvalid
    c3surf_error="nothing done"
  fi
}


# worker for command "doAdminLogin"
# no checks, admin is the master
# just login a HOST!!!
doAdminLogin()
{
  # only check if host is in use
  if [ ! -f "$c3surf_tn" ]
  then
    c3surf_id="-"
    [ $c3surf_vorname ] || c3surf_vorname="hostlogin"
    [ $c3surf_name ] || c3surf_name="unlimited"
    [ $c3surf_mail ] || c3surf_mail="-"
    # do the login (set the timer)
    setTimer
    # log it
    logValid "admin:login"
  else
    c3surf_error="nothing done"
    c3surf_sstatus="multiple login ignored"
    c3surf_cstatus="login_by_admin:"
    logInvalid
  fi
}

# ###################
# Delete User account
# ###################
# delete the user (do a logout first!)
doUserDelete()
{
  # read user vars
  . "$c3surf_un"
  # remove user .data
  rm -f "$c3surf_un"
  # rm -f "$C3SURF_TMP_PATH/$fsid.quota"
  removeQuota
  # delete PERSISTENT too, if TMP it is on
  if [ "$C3SURF_WORKON_TMP" = "yes" ]
  then
    rm -f "$C3SURF_PERSISTENT_PATH/$c3surf_id.data"
  fi
  # take user away from .htpasswd
  sed "/$fsid:$fspw/d" /srv/www/c3surf/login/.htpasswd > /tmp/.htpasswd.$$
  mv -f /tmp/.htpasswd.$$ /srv/www/c3surf/login/.htpasswd
}

# #############################################################
# MAIN
# #############################################################

# #############################################################
# INIT
# #############################################################

# init packet globals
. /var/run/c3surf.conf

# get the Parameters
c3surf_cmd="$1"
c3surf_ip="$2"
c3surf_id="$3"
c3surf_vorname="$4"
c3surf_name="$5"
c3surf_mail="$6"

if [ -n "$c3surf_ip" ]
then
  # get mac
  getMacFromArp
  # always need the timer (exeption: doUserDelete)
  initTimerVar
fi

# my reference time_stamps (now and tomorrow 00:00)
c3surf_reference_ts=$(/bin/date +%s)
c3surf_log_ts=$(/bin/date +%d.%m.%Y-%H:%M:%S)
c3surf_tomorrow_ts=$(/bin/date -d +24:0 +%s)

# no parallel processing please
while [ -f /tmp/c3surf_worker.lck ]
do
  c3surf_wait_ts=$(/bin/date +%s)
  if [ $(/usr/bin/expr $c3surf_wait_ts - $c3surf_reference_ts) -gt 2 ]
  then
    c3surf_error="worker waits to long - semaphore deleted"
    logWorker
    rm -f /tmp/c3surf_worker.lck
  fi
done
>/tmp/c3surf_worker.lck

# my logging
c3surf_error="starting"
[ $DEBUG_INFO ] && logWorker

# #############################################################
# COMMAND HANDLER
# #############################################################

c3surf_error="processing"

case "$c3surf_cmd" in
  "doLogin")
    # set vars for msg and error handling
    c3surf_nstatus="0"
    c3surf_sstatus=""
    c3surf_cstatus=""
    . /usr/lib/c3surf/c3surf_worker.msg
    doLogin
  ;;

  "doLogout")
    doLogout "logout"
  ;;

  # minimal checks
  # login a host without limits
  "doAdminLogin")
    doAdminLogin
  ;;

  # logout without any quota-check
  # used my blocklist / blacklist
  "doAdminLogout")
    doAdminLogout "admin:logout"
  ;;

  # logout without quota-count-check
  # used by login, if next user logs in on same terminal
  "doAdminNCLogout")
    doAutoLogout "admin:nc:logout"
  ;;

  # logout without quota-count-check
  # used by login, if next user logs in on same terminal
  # used by c3surf_countdown if ARP-CHECK fails
  "doAutoLogout")
    doAutoLogout "auto:logout"
  ;;

  # logout without quota-count-check
  "doSyslockLogout")
    doAutoLogout "syslock:logout"
  ;;

  # special: no IP for logout, only ID -- no init above done
  # delete a user
  # used by Admin cgi
  "doUserDelete")
    if [ -n "$c3surf_id" ]
    then
      # init user
      initUserVar
      if [ -f "$c3surf_on" ]
      then
        # user is online - we have to init and do a logout
        readUserOnline
        c3surf_ip="$c3surf_online_ip"
        c3surf_mac="$c3surf_online_mac"
        # now we have all for init
        initTimerVar
        #  logout the user
        doAutoLogout "deluser:logout"
      else
        # we need this file in doUserDelete
        initQuotaVar
      fi # online
      doUserDelete
    else
      c3surf_error="worker needs UID for doUserDelete"
      logWorker
    fi
  ;;

  # used by Admin cgi
  "addIPTime")
    # is a global option
    # initTimerVar
    if [ -f "$c3surf_tn" ]
    then
      readTimer
      if [ $# -ge 3 -a -n "$3" ]
      then
        fstime="$3"
      else
        fstime=$C3SURF_TIME
      fi
      fstimesecs=$(/usr/bin/expr $fstime \* 60)
      c3surf_time=$(/usr/bin/expr $c3surf_time + $fstimesecs)
      c3surf_count=$(/usr/bin/expr $c3surf_count + 1)
      writeTimer
      logValid "addtime:$fstime"
    fi
  ;;

  # .cgi User online
  "addTimeBlock")
    doAdminLogout "admin:block"
    if [ -n "$3" ]
    then
      initTimeBlockVar $(/usr/bin/expr "$3" \* 60)
    else
      initTimeBlockVar
    fi
    addTimeBlock
  ;;

  # .cgi Blocklist
  "removeTimeBlock")
    # needs $2=ip and $3=id
    initTimeBlockVar
    removeTimeBlock
  ;;

  *)
    c3surf_error="illegal command"
    logWorker
  ;;
esac

[ $DEBUG_INFO ] && logWorker

# delete semaphore variable
rm -f /tmp/c3surf_worker.lck
