#!/bin/sh
# -----------------------------------------------------------------------------
# This file is part of opt_c3surf. For contact and licensing information, see
#   (fli4lroot)/config/c3surf.txt
# File version: $Id: c3surf_countdown.sh 01 2008-01-08 00:00:00Z fs $
# -----------------------------------------------------------------------------
. /var/run/c3surf.conf
#
# ---------------------------------------------------
# - calc the timer 
# ---------------------------------------------------
calcTime()
{
  fsnow=`date +%s`
  fstime=`/usr/bin/expr $fstime - $fsnow`
}
#
# ---------------------------------------------------
# - check time, than the ARP table and logout if IP is gone
# ---------------------------------------------------
checkArp()
{
  calcTime
  if [ $fstime -le 0 ]
  then
     /usr/local/bin/c3surf_worker.sh "doLogout" "$fsip" "fsid"
  else # do the ARP check
    if [ -f /proc/net/arp ]
    then
      arp_ip_found="no"
      {
        read arp_header
        # while read arp_ip arp_hwtype arp_flags arp_mac arp_mask arp_device
        while read arp_ip arp_rest
        do
          if [ "$arp_ip" = "$fsip" ]
          then
            arp_ip_found="yes"
            break
          fi
        done
      } < /proc/net/arp
      # do the logout without counter Quota
      if [ "$arp_ip_found" = "no" ]
      then
        /usr/local/bin/c3surf_worker.sh "doAutoLogout" "$fsip" "fsid"
      fi # no IP found
    fi # check for /proc/net/arp
  fi # there was some time left
}
#
# ---------------------------------------------------
# - check the blocked UID/IP and unblock - parallel?
# ---------------------------------------------------
for f in $C3SURF_TMP_PATH/*.block
do
  # schliee den Abfrage-String aus
  if [ "$f" != "$C3SURF_TMP_PATH/*.block" ]
  then
    {
      read fstime c3surf_rest
    } < $f
    fsnow=`date +%s`
    fstime=`/usr/bin/expr $fstime - $fsnow`
    if [ $fstime -le 0 ]
    then
      rm -f "$f"
    fi
  fi
done
#
# ---------------------------------------------------
# - countdown the time for UID/IP
# ---------------------------------------------------
for f in $C3SURF_TMP_PATH/*.time
do
  # schliee den Abfrage-String aus
  if [ "$f" != "$C3SURF_TMP_PATH/*.time" ]
  then
    {
      read fstime fscount fsid fsip c3surf_rest
    } < $f
    # check admin unlimited login
    if [ $fstime -gt 0 ]
    then
      # should we check ARP-table
      if [ "$C3SURF_CHECK_ARP" = "yes" ]
      then
        checkArp
      else
        calcTime
        if [ $fstime -le 0 ]
        then
          /usr/local/bin/c3surf_worker.sh "doLogout" "$fsip" "fsid"
        fi # Logout
      fi # ARP-Check
    fi # unlimited Admin login
  fi # ignore *.time
done
#