#!/bin/sh
##-------------------------------------------------------------------------------
## c3Surf is Copyright (c)  2007 Frank Saurbier, fs, email: 3surf@arcor.de
##
## Admin Interface - fli4l
##
## Creation:     20.01.2008  fs
## Last Update:  19.11.2008  fs
## Version: 	   2.2.2
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------

. /srv/www/include/cgi-helper
. /var/run/c3surf.conf

# neu: 3.3.0
if [ -f /var/run/dhcp_leases_dir ]
then
  . /var/run/dhcp_leases_dir
fi

# (fs) 20080317 dnsdhcp leases auch anzeigen
# ggf. DHCP leases anzeigen (change: 3.3.x)
c3surf_leases_file="$DHCP_LEASES_DIR/dnsmasq.leases"

c3surf_tab_virgin=true

###################################
simple_output ()
{
  htmlspecialchars | while read line
  do
    case $FORM_subaction in
    $log_file1) #login
      fsstamp=`echo $line | cut -d "|" -f 1`
      fsip=`echo $line | cut -d "|" -f 2`
      fsid=`echo $line | cut -d "|" -f 3`
      fsvorname=`echo $line | cut -d "|" -f 4`
      fsname=`echo $line | cut -d "|" -f 5`
      fsmail=`echo $line | cut -d "|" -f 6`
      fsmac=`echo $line | cut -d "|" -f 7`
      fsaction=`echo $line | cut -d "|" -f 8`
      echo "<tr>\
<td><nobr>$fsstamp</nobr></td>\
<td><nobr>$fsip</nobr></td>\
<td><nobr>$fsid</nobr></td>\
<td><nobr>$fsvorname</nobr></td>\
<td><nobr>$fsname</nobr></td>\
<td><nobr>$fsmail</nobr></td>\
<td><nobr>$fsmac</nobr></td>\
<td><nobr>$fsaction</nobr></td>\
</tr>"
    ;;
    $log_file2) #invalid
      fsstamp=`echo $line | cut -d "|" -f 1`
      fsmac=`echo $line | cut -d "|" -f 2`
      fserror=`echo $line | cut -d "|" -f 3`
      fsip=`echo $line | cut -d "|" -f 4`
      fsparms=`echo $line | cut -d "|" -f 5`
      echo "<tr>\
<td><nobr>$fsstamp</nobr></td>\
<td><nobr>$fsmac</nobr></td>\
<td><nobr>$fserror</nobr></td>\
<td><nobr>$fsip</nobr></td>\
<td><nobr>$fsparms</nobr></td>\
</tr>"
    ;;
    $log_file3) #page
      fsstamp=`echo $line | cut -d "|" -f 1`
      fsip=`echo $line | cut -d "|" -f 2`
      fsbrowser=`echo $line | cut -d "|" -f 3`
      fsany=`echo $line | cut -d "|" -f 4`
      echo "<tr>\
<td><nobr>$fsstamp</nobr></td>\
<td><nobr>$fsip</nobr></td>\
<td><nobr>$fsbrowser</nobr></td>\
<td><nobr>$fsany</nobr></td>\
</tr>"
    ;;
    *) # generischer Teil fr alles andere
      echo "<tr><td><nobr>$line</nobr></td></tr>"
    esac
  done
}
# ##################################
# log worker events
logWorker()
{
# echo "$c3surf_log_ts|$c3surf_cmd|$c3surf_ip|$c3surf_id|$c3surf_vorname|$c3surf_name|$c3surf_mail|$c3surf_mac|$c3surf_error" >> "$C3SURF_LOG_PATH/c3surf_worker.log"
  echo "$c3surf_log_ts|$c3surf_cmd|"none"|$fsid|$fsvorname|$fsname|$fsmail|"none"|$c3surf_error" >> "$C3SURF_LOG_PATH/c3surf_worker.log"
}
# do the user work - NOCH IN WORKER VERLAGERN!!!
do_userinput()
{
# first get the id
fsid="$FORM_id"
# get original user data
if [ -n "$fsid" -a -f "$C3SURF_READ_PATH/$fsid.data" ]
then
  . "$C3SURF_READ_PATH/$fsid.data"
fi
# new password -- crypt it!!!!
if [ -n "$FORM_pw" ]
then
  newpw="yes"
  fspw=$(/usr/lib/c3surf/htpasswd -nbd "$fsid" "$FORM_pw" | cut -d ":" -f 2)
else
  newpw="no"
fi
# change vars
fsname="$FORM_name"
fsvorname="$FORM_vorname"
fsmail="$FORM_mail"
fstime="$FORM_time"
fsblocktime="$FORM_blocktime"
fscounter="$FORM_counter"

# my reference time_stamp
c3surf_reference_ts=$(/bin/date +%s)
c3surf_log_ts=$(/bin/date +%d.%m.%Y-%H:%M:%S)

# check the inputs (we have to do it again)
if [ -n "$fsid" ]
then
  # no parallel processing with the worker please
  while [ -f /tmp/c3surf_worker.lck ]
  do
    c3surf_wait_ts=$(/bin/date +%s)
    if [ $(/usr/bin/expr $c3surf_wait_ts - $c3surf_reference_ts) -gt 3 ]
    then
      c3surf_cmd="userAdmin"
      c3surf_error="webAdmin waits to long - semaphore deleted"
      logWorker
      rm -f /tmp/c3surf_worker.lck
    fi
  done
  >/tmp/c3surf_worker.lck

  # now start saving the parms
  echo "fsid=\"$fsid\"" > "$C3SURF_PERSISTENT_PATH/$fsid.data"
  echo "fspw=\"$fspw\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  if [ -n "$fsname" ]
  then
    fsname=$(echo "$fsname" | tr -d '\n' | tr -c '\-[:alnum:]' '_')
    echo "fsname=\"$fsname\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  else
    echo "fsname=\"none\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  fi
  if [ -n "$fsvorname" ]
  then
    fsvorname=$(echo "$fsvorname" | tr -d '\n' | tr -c '\-[:alnum:]' '_')
    echo "fsvorname=\"$fsvorname\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  else
    echo "fsvorname=\"none\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  fi
  if [ -n "$fsmail" ]
  then
    fsmail=$(echo "$fsmail" | tr -d '\n' | tr -c '@\-.[:alnum:]' '_')
    echo "fsmail=\"$fsmail\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  else
    echo "fsmail=\"none\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  fi
  # write optional time
  if [ -n "$fstime" ]
  then
    fstime=$(echo "$fstime" | tr -d '\n' | tr -c '[:digit:]' 'X' | tr -d 'X')
    if [ -n "$fstime" ]
    then
      fssecs=`expr $fstime \* 60`
    fi
    echo "fstime=\"$fstime\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
    echo "fssecs=\"$fssecs\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
  fi
  # writer optional blocktime
  if [ -n "$fsblocktime" ]
  then
    # (fs) 20090710 bugfix: '\' was missing in translate ==> syntax error
    fsblocktime=$(echo "$fsblocktime" | tr -d '\n' | tr -c '\-[:digit:]' 'X' | tr -d 'X')
    if [ -n "$fsblocktime" ]
    then
      if [ $fsblocktime -le 0 ]
      then
        fsblocksecs=$fsblocktime
      else
        fsblocksecs=`expr $fsblocktime \* 60`
      fi
      echo "fsblocktime=\"$fsblocktime\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
      echo "fsblocksecs=\"$fsblocksecs\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
    fi
  fi
  # write optional counter
  if [ -n "$fscounter" ]
  then
    # (fs) 20090710 bugfix: '\' was missing in translate ==> syntax error
    fscounter=$(echo "$fscounter" | tr -d '\n' | tr -c '\-[:digit:]' 'X' | tr -d 'X')
    if [ -n "$fscounter" ]
    then
      if [ $fscounter -lt -1 ]
      then
        echo "fscounter=\"-1\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
      else
        echo "fscounter=\"$fscounter\"" >> "$C3SURF_PERSISTENT_PATH/$fsid.data"
      fi
    fi
  fi

  # put the data to TMP
  if [ "$C3SURF_WORKON_TMP" = "yes" ]
  then
    cp -f "$C3SURF_PERSISTENT_PATH/$fsid.data" "$C3SURF_TMP_PATH/$fsid.data"
  fi

  # unlock worker
  rm -f /tmp/c3surf_worker.lck

  # add password .htpasswd
  if [ "$newpw" = "yes" ]
  then
    /usr/local/bin/c3surf_htpasswd.sh "$fsid" "$fspw"
  fi
  douserstate="yes"
else
  c3surf_cmd="userAdmin"
  c3surf_error="webAdmin cannot add user whithout UID"
  logWorker
  douserstate="no"
fi
}


# ###########################################
# Rechte checken (im Moment nur c3surf:admin)
# ###########################################
check_rights "c3surf" "admin"

# TAB: show lockme if system is locked
if [ "$FORM_action" = "" ]
then
  if test -f $C3SURF_SYSLOCK_FILE
  then
    FORM_action="lockme"
  fi
fi

# hack for proper tab-selection, inspired by pf.cgi
: ${FORM_action:=online}
: ${FORM_work:=}

# ####################################################
# beginne mit der Arbeit, dann klappt auch der refresh
# ####################################################
case $FORM_action in
  online)
    case $FORM_work in
      addtime)
        /usr/local/bin/c3surf_worker.sh "addIPTime" "$FORM_host" "$FORM_adtime"
        myrefresh="yes"
      ;;
      block)
        /usr/local/bin/c3surf_worker.sh "addTimeBlock" "$FORM_host" "240"
        myrefresh="yes"
      ;;
      logout)
        /usr/local/bin/c3surf_worker.sh "doAdminNCLogout" "$FORM_host"
        myrefresh="yes"
      ;;
      blacklist)
        /usr/local/bin/c3surf_blacklist.sh "$FORM_mac" "add" "$FORM_host"
        /usr/local/bin/c3surf_worker.sh "doAdminLogout" "$FORM_host"
        myrefresh="yes"
      ;;
    esac
  ;;

  userdata)
    case $FORM_work in
#      usr_edit)
#        echo "usr_edit" > /dev/null
#      ;;
#      usr_delete)
#        echo "usr_delete" > /dev/null
#      ;;
      usr_quotareset)
        rm -f "$C3SURF_TMP_PATH/$FORM_uid.quota"
        myrefresh="yes"
      ;;
      usr_add)
#        echo "usr_add" > /dev/null
        do_userinput
        myrefresh="yes"
#        myrefresh="$douserstate"
      ;;
      usr_save)
#        echo "usr_save" > /dev/null
        do_userinput
        myrefresh="yes"
      ;;
      usr_esc)
#        echo "usr_esc" > /dev/null
        myrefresh="yes"
      ;;
      usr_del)
#        echo "usr_del" > /dev/null
        if [ -n "$FORM_id" ]
        then
          /usr/local/bin/c3surf_worker.sh "doUserDelete" "" "$FORM_id"
        fi
        myrefresh="yes"
      ;;
    esac
  ;;

  blocklist)
    case $FORM_work in
      unblock)
        /usr/local/bin/c3surf_worker.sh "removeTimeBlock" "$FORM_host" "$FORM_id"
        myrefresh="yes"
      ;;
      blacklist)
        /usr/local/bin/c3surf_blacklist.sh "$FORM_mac" "add" "$FORM_host"
        /usr/local/bin/c3surf_worker.sh "removeTimeBlock" "$FORM_host" "$FORM_id"
        myrefresh="yes"
      ;;
    esac
  ;;

  blacklist)
    if [ "$FORM_work" = "remove" ]
    then
      /usr/local/bin/c3surf_blacklist.sh "$FORM_mac" "remove"
      myrefresh="yes"
    fi
  ;;

  arplist)
    case $FORM_work in
      adm_login)
        /usr/local/bin/c3surf_worker.sh "doAdminLogin" "$FORM_host"
        myrefresh="yes"
      ;;
      blacklist)
        /usr/local/bin/c3surf_blacklist.sh "$FORM_mac" "add" "$FORM_host"
        myrefresh="yes"
      ;;
    esac
  ;;

  leaseslist)
    case $FORM_work in
      adm_login)
        /usr/local/bin/c3surf_worker.sh "doAdminLogin" "$FORM_host"
        myrefresh="yes"
      ;;
      blacklist)
        /usr/local/bin/c3surf_blacklist.sh "$FORM_mac" "add" "$FORM_host"
        myrefresh="yes"
      ;;
    esac
  ;;

  lockme)
    case $FORM_work in
      lock_logout)
      # melde alle ab
        for f in $C3SURF_TMP_PATH/*.time
        do
          # schliee den Abfrage-String aus
          if [ ! "$f" = "$C3SURF_TMP_PATH/*.time" ]
          then
            /usr/local/bin/c3surf_worker.sh "doSyslockLogout" `basename $f .time`
          fi
        done
        echo "$_lck_msg_system_to_user" > $C3SURF_PERSISTENT_PATH/c3surf.lock
        if [ "$C3SURF_WORKON_TMP" = "yes" ]
        then
          cp -f $C3SURF_PERSISTENT_PATH/c3surf.lock $C3SURF_SYSLOCK_FILE
        fi
        myrefresh="yes"
      ;;
      lock_only)
        echo "$_lck_msg_system_to_user" > $C3SURF_PERSISTENT_PATH/c3surf.lock
        if [ "$C3SURF_WORKON_TMP" = "yes" ]
        then
          cp -f $C3SURF_PERSISTENT_PATH/c3surf.lock $C3SURF_SYSLOCK_FILE
        fi
        myrefresh="yes"
      ;;
      unlock)
        rm -f $C3SURF_PERSISTENT_PATH/c3surf.lock
        if [ "$C3SURF_WORKON_TMP" = "yes" ]
        then
          rm -f $C3SURF_SYSLOCK_FILE
        fi
        myrefresh="yes"
      ;;
    esac
  ;;

  logview)
    if [ -n "$FORM_clearlog_yes" -a -n "$FORM_subaction" ]
    then
      # -------------------------------------- not good for httpd.log
      # rm -f $C3SURF_LOG_PATH/$FORM_subaction
      # --------------------------------------
      > $C3SURF_LOG_PATH/$FORM_subaction
      # --------------------------------------
      # unset FORM_subaction
      # --------------------------------------
      FORM_subaction=""
      myrefresh="yes"
    fi
  ;;
esac

# ####################################################
# mache eine Refresh, damit die get-Parameter aus dem Browser verschwinden
# ####################################################
if [ "$myrefresh" = "yes" ]
then
  echo "Location: $myname?action=$FORM_action"
  echo
  exit
fi

# nur die "online" Seite aktualisieren
if [ "$FORM_action" = "online" ]
then
  show_html_header "Free Surf Admin $C3SURF_VERSION" "refresh=60;url=$myname?action=$FORM_action"
else
  show_html_header "Free Surf Admin $C3SURF_VERSION"
fi

echo "<h2>3Surf&nbsp;Admin&nbsp;&nbsp;&nbsp;&rarr;&nbsp;<a href=\"http://$C3SURF_HTTPD_HOST_NAME/\" target=\"_blank\">LoginUsr&nbsp;Anmeldeseite</a>&nbsp;&larr;</h2>"
echo "<br>"

# Jetzt in lang/c3surf.de
# _online="Wer ist online"
# _blocklist="IP Blocklist"
# _blacklist="MAC Blacklist"
# _arplist="ARP Tabelle"
# _lockme="Deny all Logins"
# _logview="Logdatei"

#
#################################
# Tabs ausgeben
#################################
if [ -f $c3surf_leases_file ]
then
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    show_tab_header "$_online" "$myname?action=online" \
                    "$_userdata" "$myname?action=userdata" \
                    "$_blocklist" "$myname?action=blocklist" \
                    "$_blacklist" "$myname?action=blacklist" \
                    "$_arplist" "$myname?action=arplist" \
                    "$_leaseslist" "$myname?action=leaseslist" \
                    "$_lockme" "$myname?action=lockme" \
                    "$_logview" "$myname?action=logview"
  else
    show_tab_header "$_online" "$myname?action=online" \
                    "$_blocklist" "$myname?action=blocklist" \
                    "$_blacklist" "$myname?action=blacklist" \
                    "$_arplist" "$myname?action=arplist" \
                    "$_leaseslist" "$myname?action=leaseslist" \
                    "$_lockme" "$myname?action=lockme" \
                    "$_logview" "$myname?action=logview"
  fi
else
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    show_tab_header "$_online" "$myname?action=online" \
                    "$_userdata" "$myname?action=userdata" \
                    "$_blocklist" "$myname?action=blocklist" \
                    "$_blacklist" "$myname?action=blacklist" \
                    "$_arplist" "$myname?action=arplist" \
                    "$_lockme" "$myname?action=lockme" \
                    "$_logview" "$myname?action=logview"
  else
    show_tab_header "$_online" "$myname?action=online" \
                    "$_blocklist" "$myname?action=blocklist" \
                    "$_blacklist" "$myname?action=blacklist" \
                    "$_arplist" "$myname?action=arplist" \
                    "$_lockme" "$myname?action=lockme" \
                    "$_logview" "$myname?action=logview"
  fi
fi


case $FORM_action in
#################################
###    TAB: Wer ist online    ###
#################################
  online)

    echo "<table class=\"normtable\">"
    # Angemeldete suchen
    for f in $C3SURF_TMP_PATH/*.time
    do
      # schliee den Abfrage-String aus
      if [ "$f" = "$C3SURF_TMP_PATH/*.time" ]
      then
        show_info "$_gen_info_head" "$_onl_info_nobody_txt"
      else
        {
          read c3surf_time c3surf_count c3surf_id c3surf_ip c3surf_mac c3surf_vorname c3surf_name c3surf_mail
        } < $f

        # Restzeit berechnen
        if [ "$c3surf_id" = "-" ]
        then
          c3surf_time="&infin;"
        else
          c3surf_now=`date +%s`
          c3surf_time=`/usr/bin/expr $c3surf_time - $c3surf_now`
          c3surf_time=`/usr/bin/expr $c3surf_time / 60`
          if [ $c3surf_time -le 1 ]
          then
            c3surf_time=" &le;1"
          fi
        fi

        # Ausgabe der Header (einmalig)
        if [ $c3surf_tab_virgin = true ]
        then
          cat <<-EOF
            <tr>
            <td><center><b>$_gen_h_ip</b></center></td>
            <td><center><b>$_gen_h_mac</b></center></td>
            <td><center><b>$_gen_h_id</b></center></td>
            <td><center><b>$_gen_h_forename<br>$_gen_h_surname</b></center></td>
            <td><center><b>$_gen_h_mail</b></center></td>
            <td><center><b>$_gen_h_time</b><br><nobr>($_gen_h_minutes)</nobr></center></td>
            <td><center><b>$_gen_h_prolong</b><br><nobr>($_gen_h_minutes)</nobr></center></td>
            <td><center><b>$_gen_h_reduce</b><br><nobr>($_gen_h_minutes)</nobr></center></td>
            <td><center><b>$_gen_h_command</b></center></td>
            </tr>
EOF
          c3surf_tab_virgin=false
        fi

        # Ausgabe der Inhalte
        cat <<-EOF
          <tr>
          <td><center>$c3surf_ip</center></td>
          <td><center>$c3surf_mac</center></td>
          <td><center>$c3surf_id</center></td>
          <td><center>$c3surf_vorname<br>$c3surf_name</center></td>
          <td><center><a href="mailto:$c3surf_mail">$c3surf_mail</a></center></td>
          <td><center>$c3surf_time</center></td>
          <td><center>
EOF
        if [ ! "$c3surf_id" = "-" ]
        then
          cat <<-EOF
            &nbsp;<a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=15">+15</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=30">+30</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=60">+60</a><br>
            &nbsp;<a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=120">+120</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=240">+240</a>&nbsp;
            </center></td><td><center>
            &nbsp;<a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=-15">-15</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=-30">-30</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=-60">-60</a><br>
            &nbsp;<a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=-120">-120</a>&nbsp;
            <a href="$myname?action=online&work=addtime&host=$c3surf_ip&adtime=-240">-240</a>&nbsp;
EOF
        fi

        echo "</center></td>\
              <td><center>&nbsp;<a href=\"$myname?action=online&work=logout&host=$c3surf_ip\">$_onl_cmd_logout</a>&nbsp;"

        if [ ! "$c3surf_id" = "-" ]
        then
          echo "<br>\
               &nbsp;<a href=\"$myname?action=online&work=block&host=$c3surf_ip\">$_onl_cmd_blockip 240 min</a>&nbsp;<br>\
               &nbsp;<a href=\"$myname?action=online&work=blacklist&host=$c3surf_ip&mac=$c3surf_mac\">$_onl_cmd_macblack</a>&nbsp;"
        fi

        echo "</center></td></tr>"

        # Ende else
      fi
    done
    # Tabelle schlieen
    echo "</table>"
  #################################
  ### ende   TAB: Wer ist online    ###
  #################################
  ;;
  #################################
  ###      TAB: Accounts        ###
  #################################
  userdata)

# ---------------------------
# Arbeitsbereich Benutzer neu anlegen, editiern und lschen
# ---------------------------
# init vars
  my_cmd="$_usr_cmd_add"
  my_work="usr_add"
  my_esc=""

  if [ "$FORM_work" = "usr_edit" ]
  then
    if [ -f "$C3SURF_READ_PATH/$FORM_uid.data" ]
    then
      . "$C3SURF_READ_PATH/$FORM_uid.data"
      my_cmd="$_usr_cmd_save"
      my_work="usr_save"
      my_esc="<a href=\"$myname?action=userdata&work=usr_esc\">$_usr_cmd_esc</a>"
    fi
  fi

  if [ "$FORM_work" = "usr_delete" ]
  then
    if [ -f "$C3SURF_READ_PATH/$FORM_uid.data" ]
    then
      . "$C3SURF_READ_PATH/$FORM_uid.data"
      my_cmd="$_usr_cmd_del"
      my_work="usr_del"
      my_esc="<a href=\"$myname?action=userdata&work=usr_esc\">$_usr_cmd_esc</a>"
    fi
  fi

# Form
    cat <<-EOF
      <table class="normtable">
      <tr>
      <form action="$myname" method="get">
      <table class="normtable">
      <tr>
      <td colspan="9"><center>$_gen_h_workingarea</center></td>
      </tr>
      <tr>
      <td><center><b>$_gen_h_id</b></center></td>
      <td><center><b>$_gen_h_forename</b></center></td>
      <td><center><b>$_gen_h_surname</b></center></td>
      <td><center><b>$_gen_h_mail</b></center></td>
      <td><center><b>$_gen_h_password</b></center></td>
      <td><center><b>$_gen_h_time<br>$_gen_h_minutes</b></center></td>
      <td><center><b>$_gen_h_blocktime<br>$_gen_h_minutes</b></center></td>
      <td><center><b>$_gen_h_counter</b></center></td>
      <td><center><b>$_gen_h_command</b></center></td>
      </tr>
      <tr>
      <td><center><input type="text" name="id" size="12" value="$fsid"></center></td>
      <td><center><input type="text" name="vorname" size="15" value="$fsvorname"></center></td>
      <td><center><input type="text" name="name" size="20" value="$fsname"></center></td>
      <td><center><input type="text" name="mail" size="25" value="$fsmail"></center></td>
      <td><center><input type="text" name="pw" size="12"></center></td>
      <td><center><input type="text" name="time" size="5" value="$fstime"></center></td>
      <td><center><input type="text" name="blocktime" size="5" value="$fsblocktime"></center></td>
      <td><center><input type="text" name="counter" size="5" value="$fscounter"></center></td>
      <td><center>
      <input type="hidden" name="action" value="userdata">
      <input type="hidden" name="work" value="$my_work">
      <input type="submit" value="$my_cmd" class="actions">
      </td>
      </tr>
      <tr>
      <td colspan="5" align="right">$_usr_h_defaultvals</td>
      <td><center>$C3SURF_TIME</center></td>
      <td><center>$C3SURF_BLOCKTIME</center></td>
      <td><center>$C3SURF_COUNTER</center></td>
      <td><center>$my_esc</center></td>
      </tr>
      </table>
      </tr>
      </table>
      <br>
EOF


if [ -z "$FORM_work"]
then
    echo "<table class=\"normtable\">"
    # Userdaten suchen
    for f in "$C3SURF_READ_PATH"/*.data
    do
      # schliee den Abfrage-String aus
      if [ "$f" = "$C3SURF_READ_PATH/*.data" ]
      then
        show_info "$_gen_info_head" "$_usr_info_noaccount_txt"
      else
        . "$f"
#
# Userdaten ggf. auf Default setzen
#
        # C3SURF_TIME
        if [ -z "$fssecs" ]
        then
          fstime=$C3SURF_TIME
          fssecs=$C3SURF_SECS
        else
          # compatibility with older c3surf version
          if [ -z "$fstime" ]
          then
            fstime=$(expr "$fssecs" \/ "60")
          fi
        fi
        # C3SURF_BLOCKTIME
        if [ -z "$fsblocksecs" ]
        then
          fsblocktime=$C3SURF_BLOCKTIME
          fsblocksecs=$C3SURF_BLOCKSECS
        else
          # compatibility with older c3surf version
          if [ -z "$fsblocktime" ]
          then
            if [ $fsblocksecs -gt 0 ]
            then
              fsblocktime=$(expr "$fsblocksecs" \/ "60")
            else
              fsblocktime=$fsblocksecs
            fi
          fi
        fi
        # C3SURF_COUNTER
        if [ -z "$fscounter" ]
        then
          fscounter=$C3SURF_COUNTER
        fi
#
# Lese die Quota Daten
#
        if [ -f "$C3SURF_TMP_PATH/$fsid.quota" ]
        then
          {
            read c3surf_quota_ts c3surf_quota_time c3surf_quota_maxtime c3surf_quota_count c3surf_quota_maxcount
          } < "$C3SURF_TMP_PATH/$fsid.quota"
          # noch fr Anzeige berechnen
# --- hier noch berechnen
#
#
# --- hier noch berechnen
        else
          c3surf_quota_ts="-"
          c3surf_quota_time="-"
          c3surf_quota_maxtime="-"
          c3surf_quota_count="-"
          c3surf_quota_maxcount="$fscounter"
        fi

        # Ausgabe der Header (einmalig)
        if [ $c3surf_tab_virgin = true ]
        then
          cat <<-EOF
            <tr>
            <td rowspan="2"><center><b>$_gen_h_id</b></center></td>
            <td rowspan="2"><center><b>$_gen_h_forename<br>$_gen_h_surname</b></center></td>
            <td rowspan="2"><center><b>$_gen_h_mail</b></center></td>
            <td rowspan="2"><center><b>$_gen_h_time<br>$_gen_h_minutes</b><br><nobr>($_gen_h_seconds)</nobr></center></td>
            <td rowspan="2"><center><b>$_gen_h_blocktime<br>$_gen_h_minutes</b><br><nobr>($_gen_h_seconds)</nobr></center></td>
            <td rowspan="2"><center><b>$_gen_h_counter</b></center></td>
            <td rowspan="2"><center></center></td>
            <td colspan="2"><center><b>$_gen_h_quota</center></td>
            <td rowspan="2"><center><b>$_gen_h_command</b></center></td>
            </tr>
            <tr>
            <td><center><b>$_gen_h_time<br></b>$_gen_h_seconds</center></td>
            <td><center><b>$_gen_h_counter / $_gen_h_max</b></center></td>
            </tr>
EOF
          c3surf_tab_virgin=false
        fi

        # Ausgabe der Inhalte
        cat <<-EOF
          <tr>
          <td><center>$fsid</center></td>
          <td><center>$fsvorname<br>$fsname</center></td>
          <td><center><a href="mailto:$fsmail">$fsmail</center></td>
          <td><center>$fstime<br>($fssecs)</center></td>
          <td><center>$fsblocktime<br>($fsblocksecs)</center></td>
          <td><center>$fscounter</center></td>
          <td><center></center></td>
          <td><center>$c3surf_quota_time</center></td>
          <td><center>$c3surf_quota_count / $c3surf_quota_maxcount</center></td>
          <td><center>
          <nobr>$_usr_cmd_userprefix <a href="$myname?action=userdata&work=usr_edit&uid=$fsid">$_usr_cmd_edit</a></nobr>
          <nobr><a href="$myname?action=userdata&work=usr_delete&uid=$fsid">$_usr_cmd_del</a></nobr>
          <nobr>$_usr_cmd_quotaprefix <a href="$myname?action=userdata&work=usr_quotareset&uid=$fsid">$_usr_cmd_quotareset</a></nobr>
          </center></td>
          </tr>
EOF
	unset fsid fspw fsname fsvorname fsmail fssecs fsblocksecs fscounter fstime fsblocktime

        # Ende else
      fi
    done
    # Tabelle schlieen
    echo "</table>"

fi # check FORM_work


  #################################
  ### ende   TAB: Accounts      ###
  #################################
  ;;
  #################################
  ### anfang   TAB: IP/UID-Blocklist   ###
  #################################
  blocklist)

  echo "<table class=\"normtable\">"
  # Angemeldete suchen
  for f in $C3SURF_TMP_PATH/*.block
  do
    # schliee den Abfrage-String aus
    if [ "$f" = "$C3SURF_TMP_PATH/*.block" ]
    then
      show_info "$_gen_info_head" "$_blo_info_noblock_txt"
    else
      {
        read c3surf_time c3surf_mac c3surf_id c3surf_ip
      } < $f

      # Restzeit berechnen
      c3surf_now=`date +%s`
      c3surf_time=`/usr/bin/expr $c3surf_time - $c3surf_now`
      c3surf_time=`/usr/bin/expr $c3surf_time / 60`
      if [ $c3surf_time -le 1 ]
      then
        c3surf_time=" &le;1"
      fi

      # Ausgabe der Header (einmalig)
      if [ $c3surf_tab_virgin = true ]
      then
        echo "<tr>\
             <td><center><b>$_gen_h_id</b></center></td>\
             <td><center><b>$_gen_h_ip</b></center></td>\
             <td><center><b>$_gen_h_mac</b></center></td>\
             <td><center><b>$_gen_h_timelock<br>(Minuten)</b></center></td>\
             <td><center><b>$_gen_h_command</b></center></td>\
             </tr>"
        c3surf_tab_virgin=false
      fi

      # Ausgabe der Inhalte
      echo "<tr>\
            <td><center>$c3surf_id</center></td>\
            <td><center>$c3surf_ip</center></td>\
            <td><center>$c3surf_mac</center></td>\
            <td><center>$c3surf_time</center></td>\
            <td><center>&nbsp;<a href=\"$myname?action=blocklist&work=unblock&host=$c3surf_ip&id=$c3surf_id\">$_blo_cmd_unlock</a>&nbsp;"
      if [ ! "$c3surf_mac" = "" ]
      then
        echo "<br>&nbsp;<a href=\"$myname?action=blocklist&work=blacklist&host=$c3surf_ip&mac=$c3surf_mac\">$_onl_cmd_macblack</a>&nbsp;"
      fi
      echo "</center></td></tr>"

      # Ende else
    fi
  done
  # Tabelle schlieen
  echo "</table>"
  #################################
  ### ende   TAB: IP-Blocklist    ###
  #################################
  ;;
  #################################
  ### anfang   TAB: MAC-Blacklist   ###
  #################################
  blacklist)

    echo "<table class=\"normtable\">"
    # Blacklist prfen
    if [ -s $C3SURF_BLACKLIST_FILE ]
    then
      # schreibe den header
      echo "<tr>\
           <td><center><b>$_gen_h_mac</b></center></td>\
           <td><center><b>$_gen_h_forename</b></center></td>\
           <td><center><b>$_gen_h_surname</b></center></td>\
           <td><center><b>$_gen_h_mail</b></center></td>\
           <td><center><b>$_gen_h_command</b></center></td>\
           </tr>"
      # hole die Daten des Surfers
      {
        while read c3surf_mac c3surf_vorname c3surf_name c3surf_mail
        do
          # schreibe raus
          echo "<tr>\
                <td><center>&nbsp;$c3surf_mac&nbsp;</center></td>\
                <td><center>&nbsp;$c3surf_vorname&nbsp;</center></td>\
                <td><center>&nbsp;$c3surf_name&nbsp;</center></td>\
                <td><center>&nbsp;<a href=\"mailto:$c3surf_mail\">$c3surf_mail</a>&nbsp;</center></td>\
                <td><center>&nbsp;<a href=\"$myname?action=blacklist&work=remove&mac=$c3surf_mac\">$_blk_cmd_remove</a>&nbsp;</center></td>\
                </tr>"
        done
      } < $C3SURF_BLACKLIST_FILE
    else
      # Keine Blacklist vorhanden
      show_info "$_gen_info_head" "$_blk_info_noblock_txt"
    fi
    # Tabelle schlieen
    echo "</table>"
  # Ende TAB:blaclist [action=blacklist]
  #################################
  ### ende   TAB: Blacklist   ###
  #################################
  ;;
  #################################
  ### anfang   TAB: ARP-list   ###
  #################################
  arplist)

    echo "<table class=\"normtable\">"

    # ARP-List lesen
    {
      read c3surf_header
      while read c3surf_ip c3surf_hwtype c3surf_flags c3surf_mac c3surf_mask c3surf_device
      do

        # Ausgabe der Header (einmalig)
        if [ $c3surf_tab_virgin = true ]
        then
          echo "<tr>\
               <td><center><b>$_gen_h_ip</b></center></td>\
               <td><center><b>$_gen_h_mac</b></center></td>\
               <td><center><b>$_gen_h_device</b></center></td>\
               <td><center><b>$_gen_h_command</b></center></td>\
               </tr>"
          c3surf_tab_virgin=false
        fi

        # Ausgabe der Inhalte
        echo "<tr>\
              <td><center>$c3surf_ip</center></td>\
              <td><center>$c3surf_mac</center></td>\
              <td><center>$c3surf_device</center></td>\
              <td><center>&nbsp;<a href=\"$myname?action=arplist&work=adm_login&host=$c3surf_ip\">$_arp_cmd_allow_forever</a>&nbsp;"
        if [ -n "$c3surf_mac" ]
        then
          echo "&nbsp;<a href=\"$myname?action=arplist&work=blacklist&host=$c3surf_ip&mac=$c3surf_mac\">$_onl_cmd_macblack</a>&nbsp;"
        fi
        echo "</center></td></tr>"

      done
    } < /proc/net/arp

    if [ $c3surf_tab_virgin = true ]
    then
      # Keine ARP Eintrge vorhanden
      show_info "$_gen_info_head" "$_arp_info_noarp_txt"
    fi
    # Tabelle schlieen
    echo "</table>"
  # Ende TAB:arplist [action=arplist]
  #################################
  ### ende   TAB: ARP-list   ###
  #################################
  ;;
  ###################################
  ### anfang   TAB: LEASES-list   ###
  ###################################
  leaseslist)

    echo "<table class=\"normtable\">"

    # LEASES lesen
    if [ -s $c3surf_leases_file ]
    then

      # LEASE Ende Berechnung vorbereiten (Konstante aus der Schleife ziehen)
      c3surf_datediff=`date +%z`
      c3surf_datediff=`expr $c3surf_datediff "*" 36`

      {
        while read c3surf_leaseend c3surf_mac c3surf_ip c3surf_hostname c3surf_fix
        do

          # LEASE Ende berechnen
          if [ $c3surf_leaseend -eq 0 ]
          then
            c3surf_leaseend=$_lease_neverends
          else
            c3surf_leaseend=`expr $c3surf_leaseend "+" $c3surf_datediff`
            c3surf_leaseend=`date -d "1970.1.1-0:0:$c3surf_leaseend" +%d.%m.%Y'&nbsp;'%H:%M:%S`
          fi

          # Ausgabe der Header (einmalig)
          if [ $c3surf_tab_virgin = true ]
          then
            echo "<tr>\
                 <td><center><b>$_gen_h_ip</b></center></td>\
                 <td><center><b>$_gen_h_mac</b></center></td>\
                 <td><center><b>$_gen_h_hostname</b></center></td>\
                 <td><center><b>$_gen_h_leaseend</b></center></td>\
                 <td><center><b>$_gen_h_command</b></center></td>\
                 </tr>"
            c3surf_tab_virgin=false
          fi

          # Ausgabe der Inhalte
          echo "<tr>\
                <td><center>$c3surf_ip</center></td>\
                <td><center>$c3surf_mac</center></td>\
                <td><center>$c3surf_hostname</center></td>\
                <td><center>$c3surf_leaseend</center></td>\
                <td><center>&nbsp;<a href=\"$myname?action=leaseslist&work=adm_login&host=$c3surf_ip\">$_lease_cmd_allow_forever</a>&nbsp;"
          if [ -n "$c3surf_mac" ]
          then
            echo "&nbsp;<a href=\"$myname?action=leaseslist&work=blacklist&host=$c3surf_ip&mac=$c3surf_mac\">$_onl_cmd_macblack</a>&nbsp;"
          fi
          echo "</center></td></tr>"

        done
      } < $c3surf_leases_file
    fi

    if [ $c3surf_tab_virgin = true ]
    then
      # Keine LEASE Eintrge vorhanden
      show_info "$_gen_info_head" "$_lease_info_nolease_txt"
    fi
    # Tabelle schlieen
    echo "</table>"
  # Ende TAB:leaseslist [action=leaseslist]
  #################################
  ### ende   TAB: LEASES-list   ###
  #################################
  ;;

  #################################
  ### anfang   TAB: Lock 3Surfs   ###
  #################################
  lockme)

    # Angemeldete suchen
    if test -f $C3SURF_SYSLOCK_FILE
    then
      show_error "$_lck_msg_header" "$_lck_msg_system_is_locked"
      echo "<table class=\"normtable\">"
      echo "<br>"
      echo "<tr>\
            <td><center> &nbsp; <a href=\"$myname?action=lockme&work=unlock\"><b>$_lck_action_unlock</b></a> &nbsp; </center></td>\
            </tr>"
    else
      if [ "$OPT_LOGINUSR" = "yes" ]
      then
        show_info "$_lck_msg_header" "$_lck_msg_system_is_unlocked_for_login"
      else
        show_info "$_lck_msg_header" "$_lck_msg_system_is_unlocked_for_free"
      fi
      echo "<table class=\"normtable\">"
      echo "<br>"
      echo "<tr>\
            <td><center>&nbsp;<a href=\"$myname?action=lockme&work=lock_only\"><b>$_lck_action_lock_only</b></a>&nbsp;</center></td>\
            <td><center>&nbsp;<a href=\"$myname?action=lockme&work=lock_logout\"><b>$_lck_action_lock_logout</b></a>&nbsp;</center></td>\
            </tr>"
    fi
    # Tabelle schlieen
    echo "</table>"
    echo "<br>"
  # Ende TAB:online [main=lockme]
  #################################
  ### ende   TAB: Lock 3surf   ###
  #################################
  ;;
  #################################
  ### anfang   TAB: Logview     ###
  #################################
  logview)

    # some constants (basename of log) = sort order of logfiles
    log_file1="c3surf_login.log"
    log_file2="c3surf_invalid.log"
    log_file3="c3surf_page.log"
    log_file4="c3surf_httpd.log"
    log_file5="c3surf_worker.log"
    _log_sort_normal_idx="1"
    _log_sort_reverse_idx="2"

    # some defaults
    : ${FORM_log_lines:=30}
    : ${FORM_log_sort:=$_log_sort_reverse_idx}
    : ${FORM_showall:=}

    #################################
    # Tabs generieren
    #################################

    fs_tabs=""
    for f in "$log_file1" "$log_file2" "$log_file3" "$log_file4" "$log_file5"
    do
      # teste ob Datei da ist
      # if test -f $C3SURF_LOG_PATH/$f
      # teste ob Datei mit Inhalt da ist
      if test -s $C3SURF_LOG_PATH/$f
      then
        : ${FORM_subaction:=$f}
        if [ $FORM_subaction = $f ]
        then
          fs_tabs=$(echo "$fs_tabs" "$f" "no")
        else
          fs_tabs=$(echo "$fs_tabs" "$f" "$myname?action=logview&subaction=$f&log_sort=$FORM_log_sort&log_lines=$FORM_log_lines")
        fi
      fi
    done

    #################################
    # Tabs ausgeben
    #################################
    if [ -n "$fs_tabs" ]
    then

      # prepare select field for sort
      log_sorta_idx=$FORM_log_sort
      if [ $log_sorta_idx -eq $_log_sort_reverse_idx ]
      then
        log_sortb_idx=$_log_sort_normal_idx
        log_sortb_txt=$_log_sort_normal_txt
        log_sorta_txt=$_log_sort_reverse_txt
      else
        log_sortb_idx=$_log_sort_reverse_idx
        log_sortb_txt=$_log_sort_reverse_txt
        log_sorta_txt=$_log_sort_normal_txt
      fi

      # formular Auswahl
      cat <<-EOF
<br>
<form action="$myname" method="GET">
&nbsp;<select name="log_sort">
<option value="$log_sorta_idx">$log_sorta_txt</option>
<option value="$log_sortb_idx">$log_sortb_txt</option>
</select>
<input type="hidden" name="action" value="logview">
<input type="hidden" name="subaction" value="$FORM_subaction">
<input class="itext" type="text" size="3" maxlength="4" name="log_lines" value="$FORM_log_lines">&nbsp;
<input class="sbutton" type="submit" value="$_log_refresh">&nbsp;
<input class="sbutton" type="submit" name="showall" value="$_log_show_all">
<!-- <input class="sbutton" type="submit" name="download" value="$_log_download"> -->
&nbsp;&nbsp;<input class="sbutton" type="submit" name="clearlog" value="$_log_clear">
EOF

      if [ -n "$FORM_clearlog" ]
      then
        cat <<-EOF
&rarr;<input class="sbutton" type="submit" name="clearlog_yes" value="$_log_clear_yes">
EOF
      fi

      cat <<-EOF
</form>
EOF

      if [ -n "$FORM_clearlog" ]
      then
        show_info "$FORM_subaction" "$_log_clear_question"
      else
        show_tab_header $fs_tabs

        # table header
        echo "<table class=\"normtable\">"

          if [ $c3surf_tab_virgin = true ]
          then
            case $FORM_subaction in
              $log_file1)
                echo "<tr>\
                 <th><center>$_gen_h_timestamp</center></th>\
                 <th><center>$_gen_h_ip</center></th>\
                 <th><center>$_gen_h_id</center></th>\
                 <th><center>$_gen_h_forename</center></th>\
                 <th><center>$_gen_h_surname</center></th>\
                 <th><center>$_gen_h_mail</center></th>\
                 <th><center>$_gen_h_mac</center></th>\
                 <th><center>$_gen_h_action</center></th>\
                 </tr>"
              ;;
              $log_file2)
                echo "<tr>\
                 <th><center>$_gen_h_timestamp</center></th>\
                 <th><center>$_gen_h_mac</center></th>\
                 <th><center>$_gen_h_error</center></th>\
                 <th><center>$_gen_h_ip</center></th>\
                 <th><center>$_gen_h_parms</center></th>\
                 </tr>"
              ;;
              $log_file3)
                 echo "<tr>\
                 <th><center>$_gen_h_timestamp</center></th>\
                 <th><center>$_gen_h_ip</center></th>\
                 <th><center>$_gen_h_browser</center></th>\
                 <th><center>$_gen_h_any</center></th>\
                 </tr>"
              ;;
              *)
                echo "<tr>\
                 <th><left><nobr>$_gen_h_generic</nobr></left></th>\
                 </tr>"
            esac
            c3surf_tab_virgin=false
          fi

        # generischer Teil
        if [ -n "$FORM_showall" ]
        then
          if [ $FORM_log_sort -eq $_log_sort_reverse_idx ]
          then
            cat $C3SURF_LOG_PATH/$FORM_subaction | sed '1!G;h;$!d' | simple_output
          else
            cat $C3SURF_LOG_PATH/$FORM_subaction | simple_output
          fi
        else
          if [ $FORM_log_sort -eq $_log_sort_reverse_idx ]
          then
            cat $C3SURF_LOG_PATH/$FORM_subaction | do_tail $FORM_log_lines | sed '1!G;h;$!d' | simple_output
          else
            cat $C3SURF_LOG_PATH/$FORM_subaction | do_tail $FORM_log_lines | simple_output
          fi
        fi

        # Tabelle schlieen
        echo "</table>"

        show_tab_footer

      fi # Lschen Besttigen

    else
      show_info "Logview" "Es sind keine Logdateien vorhanden."
    fi
  # Ende TAB:logview [main=logview]
  #################################
  ### ende   TAB: Logview   ###
  #################################
  ;;

  *)
    show_error "$_tab_gen_err_title" "$_tab_gen_err_unknowntab_text"

esac

#
show_tab_footer

#
show_html_footer
