#!/bin/sh
#------------------------------------------------------------------------------
# /srv/www/admin/ow.cgi - Frontend for httpd                      1.0.0
# see documentation for licence
#
# Creation:     05.02.2009  Karl M. Weckler <news4kmw@web.de>
# Last Update:  16.02.2009  kmw
#------------------------------------------------------------------------------
#
# Die hier hinterlegten Funktionen und Aufrufe zur Steuerung von Schaltern
# (Gerten)dienen nur als beispiele fr eigene Entwicklungen.
# Die einzelnen Parameter sind den gegebenen Forderungen entsprechend zu
# ergnzen, bzw. anzupassen.
#
# Geplant ist die Auslagerung von Funktionen fr die einzelnen 1-Wire-Bauteile
# in eine eigene CGI-Script-Funktionsbibliothek.
# Rckmeldungen und Hinweise gerne erbeten an news4kmw(at)web(dot)de.

# get main helper functions
. /srv/www/include/cgi-helper

# get variables from conf
CONFFILE="/var/run/ow.conf"
if [ -f $CONFFILE ]; then
. $CONFFILE
fi

# not yet security
# check_rights "1wire" "view"

#------------------------------------------------------------------------------
# functions
#------------------------------------------------------------------------------

# gets temp from "wellknown" DS19S20
# call with: DS1920_temp ID
DS1920_temp ()
{
	if [ -f "$OWFS_PATH/$1/temperature" ]; then
		temp=`cat $OWFS_PATH/$1/temperature`
		temp1=`echo $temp | cut -d. -f1`
		temp2=`echo $temp | cut -d. -f2 | cut -c1`
		temp="$temp1.$temp2"
		echo "$temp C"
  	else
		echo "n.n."
	fi
}

# switches pio A/B from "wellknown" DS2413
# call with: DS2413_piox ID pio# on/off
# ToDo:
# berprfung des Schaltstatus
DS2413_piox ()
{
if [ -d "$OWFS_PATH/$1" ]; then
	case $2 in
		A|a)
		case $3 in
			on|1) echo "1" > $OWFS_PATH/$1/PIO.A ;;		
			off|0) echo "0" > $OWFS_PATH/$1/PIO.A ;;
		esac ;;		
		B|b)
		case $3 in
			on|1) echo "1" > $OWFS_PATH/$1/PIO.B ;;		
			off|0) echo "0" > $OWFS_PATH/$1/PIO.B ;;
		esac ;;
	esac
else
	show_error "Fehler:" "$1 nicht gefunden.<br /></b>"
fi
}

#------------------------------------------------------------------------------
# variables, constants, the whole shebang
#------------------------------------------------------------------------------

# Farbe, color
gr="bgcolor=\"#00FF00\""
rt="bgcolor=\"#FF0000\""

# Zuordnung der 1-Wire-Gerte-Nummern
# apply the 1-wire device numbers
# _10 = Temperatursensor - Temperature with alarm trips - DS19S20
# _12 = Schalter - 1Kb EPROM, 2-ch. addr. switch - DS2406 (DS2407=old)
# _3A = Schalter - 2-channel addressable switch - DS2413
# etc.

_1001=10.DEF0A8010780
_1002=10.DEF0A8010790
_1003=10.DEF0A8010800
_1004=10.DEF0A8010810
_1005=10.DEF0A8010820
_1006=10.DEF0A8010830
_1007=10.DEF0A8010840
_1008=10.DEF0A8010850
_1009=10.DEF0A8010860
_1010=10.DEF0A8010870

_3A01=3A.F6E401000000
_3A02=3A.30DB01000010

# Temperaturen, temperatures
t1001=`DS1920_temp $_1001`
t1002=`DS1920_temp $_1002`
t1003=`DS1920_temp $_1003`
t1004=`DS1920_temp $_1004`
t1005=`DS1920_temp $_1005`
t1006=`DS1920_temp $_1006`
t1007=`DS1920_temp $_1007`
t1008=`DS1920_temp $_1008`
t1009=`DS1920_temp $_1009`
t1010=`DS1920_temp $_1010`

# Schalterzustnde, switch state 
#s3A01A0=`DS2413_piox $_3A01 A 0` # PIO.A aus - hier fr hzg_up
#s3A01A1=`DS2413_piox $_3A01 A 1`
#s3A01B0=`DS2413_piox $_3A01 B 0` # PIO.A aus - hier fr hzg_lp
#s3A01B1=`DS2413_piox $_3A01 B 1`

# Links ...
# OW-Server
stop_owfs="<a href=\"$myname?action=owfs_stop\">aus</a>"
start_owfs="<a href=\"$myname?action=owfs_start\">ein</a>"
stop_owshell="<a href=\"$myname?action=owshell_stop\">aus</a>"
start_owshell="<a href=\"$myname?action=owshell_start\">ein</a>"
stop_owhttpd="<a href=\"$myname?action=owhttpd_stop\">aus</a>"
start_owhttpd="<a href=\"$myname?action=owhttpd_start\">ein</a>"

# Heizung U-Pumpe
stop_hzg_up="<a href=\"$myname?action=hzg_up_stop\">aus</a>"	
start_hzg_up="<a href=\"$myname?action=hzg_up_start\">ein</a>"

# Heizung WW-Ladepumpe
stop_hzg_lp="<a href=\"$myname?action=hzg_lp_stop\">aus</a>"	
start_hzg_lp="<a href=\"$myname?action=hzg_lp_start\">ein</a>"

#------------------------------------------------------------------------------
# Site - Header - Tables
#------------------------------------------------------------------------------

# Start the Show
: ${FORM_action:=status}
_status="Status"
_steuerung="Steuerung"
_temperatur="Temperaturen"
_konfiguration="Konfiguration"

show_html_header "OWFS \"1-Wire-Bus\"" "ow.css"
show_tab_header \
    "$_status" "$myname?action=status" \
    "$_temperatur" "$myname?action=temperatur" \
    "$_steuerung" "$myname?action=steuerung" \
    "$_konfiguration" "$myname?action=konfiguration"

case $FORM_action in

#------------------------------------------------------------------------------
# Temperaturanzeige, show temp
#------------------------------------------------------------------------------

temperatur)
	cat <<EOF
    	<table class="normtable">
    	<tr><th colspan="2">Aktuelle Temperaturen</th></tr>
	<tr><td>Aussen</td><td>$t1001</td></tr>
	<tr><td>Wohnen</td><td>$t1002</td></tr>
	<tr><td>Schlafen</td><td>$t1003</td></tr>
	<tr><td>Buero</td><td>$t1004</td></tr>
	<tr><td>Solar-VL</td><td>$t1005</td></tr>
	<tr><td>Solar-RL</td><td>$t1006</td></tr>
	<tr><td>Heizung-VL</td><td>$t1007</td></tr>
	<tr><td>Heizung-RL</td><td>$t1008</td></tr>
	<tr><td>WW-Oben</td><td>$t1009</td></tr>
	<tr><td>WW-Unten</td><td>$t1010</td></tr>
	</table>
EOF
;;

#------------------------------------------------------------------------------
# Steuerung, control
#------------------------------------------------------------------------------

steuerung)
    	echo '<table class="normtable">'
    	echo '<tr><td colspan=5>*</td></tr>'
    	echo '<tr><th colspan=3>Server de/aktivieren:</th><th>Device</th><th>Pfad/Port</th></tr>'
	
	case $OWFS_RUN in
		yes)	echo "<tr><td $gr><b>OWFS</b></td><td>ein</td><td>$stop_owfs</td><td>$OWFS_DEV</td><td>$OWFS_PATH</td></tr>" ;;
		no)	echo "<tr><td $rt><b>OWFS</b></td><td>$start_owfs</td><td>aus</td><td>-</td><td>-</td></tr>" ;;
	   	*)	;;
	esac
		
	case $OWSHELL_RUN in
		yes)	echo "<tr><td $gr><b>OWSHELL</b></td><td>ein</td><td>$stop_owshell</td><td>$OWSHELL_DEV</td><td>$OWSHELL_PORT</td></tr>" ;;
		no)	echo "<tr><td $rt><b>OWSHELL</b></td><td>$start_owshell</td><td>aus</td><td>-</td><td>-</td></tr>" ;;
		*)	;;
	esac
	
	case $OWHTTPD_RUN in
		yes)	echo "<tr><td $gr><b>OWHTTPD</b></td><td>ein</td><td>$stop_owhttpd</td><td>$OWHTTPD_DEV</td><td>$OWHTTPD_PORT</td></tr>" ;;
   		no)	echo "<tr><td $rt><b>OWHTTPD</b></td><td>$start_owhttpd</td><td>aus</td><td>-</td><td>-</td></tr>" ;;
		*)	;;
	esac

# Beispiele - Anfang
    	echo '<tr><td colspan=5>*</td></tr>'
    	echo '<tr><th colspan=5>Haustechnik - (Beispiele)</th></tr>'
    	echo '<tr><th colspan=3>Heizung</th><th>Temp-VL</th><th>Temp-RL</th></tr>'
	case $HZG_UP_RUN in
		yes)	echo "<tr><td $gr>U-Pumpe</td><td>ein</td><td>$stop_hzg_up</td><td>58.5 C</td><td>52.4 C</td></tr>" ;;
   		*)	echo "<tr><td $rt>U-Pumpe</td><td>$start_hzg_up</td><td>aus</td><td>58.5 C</td><td>52.4 C</td></tr>" ;;
	esac
	case $HZG_LP_RUN in
		yes)	echo "<tr><td $gr>Lade-Pumpe</td><td>ein</td><td>$stop_hzg_lp</td><td>58.5 C</td><td>52.4 C</td></tr>" ;;
   		*)	echo "<tr><td $rt>Lade-Pumpe</td><td>$start_hzg_lp</td><td>aus</td><td>58.5 C</td><td>52.4 C</td></tr>" ;;
	esac
# Beispiele - hier nicht belegt
    	echo '<tr><td colspan=5>*</td></tr>'
    	echo '<tr><th colspan=3>Solaranlage</th><th>Temp-VL</th><th>Temp-RL</th></tr>'
	echo "<tr><td $rt>U-Pumpe</td><td>ein</td><td>aus</td><td>88.5 C</td><td>68.2 C</td></tr>"
    	echo '<tr><td colspan=5>*</td></tr>'
    	echo '<tr><th colspan=3>Wrmerckgewinnung</th><th>Temp-In</th><th>Temp-Out</th></tr>'
	echo "<tr><td $gr>Ventilator</td><td>ein</td><td>aus</td><td>21.2 C</td><td>12.7 C</td></tr>"
# Beispiele - Ende

    	echo '</table>'
;;

#------------------------------------------------------------------------------
# Div. Anlagenteile EIN und AUS schalten, toggle some devices, !!!testing!!!
#------------------------------------------------------------------------------

hzg_up_stop)
	DS2413_piox $_3A01 A 0
	#if cat DS A = 0 then .. else nix erfolg
	sed /HZG_UP_RUN/s/yes/no/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#show_info "Erfolg" "U-Pumpe ausgeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;
 
hzg_up_start)
	DS2413_piox $_3A01 A 1
	sed /HZG_UP_RUN/s/no/yes/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#show_info "Erfolg" "U-Pumpe eingeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;

hzg_lp_stop)
	DS2413_piox $_3A01 B 0
	sed /HZG_LP_RUN/s/yes/no/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#show_info "Erfolg" "Lade-Pumpe ausgeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;
 
hzg_lp_start)
	DS2413_piox $_3A01 B 1
	sed /HZG_LP_RUN/s/no/yes/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#show_info "Erfolg" "Lade-Pumpe eingeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;

#------------------------------------------------------------------------------
# OW-Server EIN und AUS schalten, toggle servers
#------------------------------------------------------------------------------

owfs_stop)
	umount $OWFS_PATH
	killall -9 owfs
	sed /OWFS_RUN/s/yes/no/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWFS-Server ausgeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;
  
owfs_start)
	/usr/bin/owfs -d $OWFS_DEV -m $OWFS_PATH
	sed /OWFS_RUN/s/no/yes/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWFS-Server eingeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;; 

owshell_stop)
	killall -9 owserver
	sed /OWSHELL_RUN/s/yes/no/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWSHELL-Server ausgeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;
  
owshell_start)
	/usr/bin/owserver -d $OWSHELL_DEV -p $OWSHELL_PORT
	sed /OWSHELL_RUN/s/no/yes/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWSHELL-Server eingeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;; 

owhttpd_stop)
	killall -9 owhttpd
	sed /OWHTTPD_RUN/s/yes/no/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWHTTPD-Server ausgeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;;
  
owhttpd_start)
	/usr/bin/owhttpd -d $OWHTTPD_DEV -p $OWHTTPD_PORT
	sed /OWHTTPD_RUN/s/no/yes/ $CONFFILE > /tmp/ow
	cat /tmp/ow > $CONFFILE
	rm -f /tmp/ow
	#sleep 1
	show_info "Erfolg" "OWHTTPD-Server eingeschaltet"
	echo "<p><a href=\"$myname?action=steuerung\">&lt;&lt; $_MN_bck</a><p>"
;; 

#------------------------------------------------------------------------------
# Status --- Anzeige der am 1-Wire-Bus angeschlossenen Gerte, show 1-wire devs 
#------------------------------------------------------------------------------
  
status)
   if [ "$OWFS_RUN" == "yes" ]; then
	owbus=`dir $OWFS_PATH`
	set -- $owbus
    echo '<table class="normtable">'
    echo '<tr><th>Hinweis: Diese Web-Applikation basiert auf "OWFS".</th></tr>'
    case "$OWSHELL_RUN" in yes|no) echo '<tr><td><b>OWSHELL</b> knnen Sie unter "Steuerung" ein- und ausschalten.</td></tr>' ;; esac
    case "$OWHTTPD_RUN" in yes|no) echo '<tr><td><b>OWHTTPD</b> knnen Sie unter "Steuerung" ein- und ausschalten.</td></tr>' ;; esac
    echo '<tr><td>*</td></tr>'
    echo '<tr><th>An den 1-Wire-Bus angeschlossene Gerte:</th></tr>'
	while [ "$9" ]
    	do
		echo "<tr><td><a href=\"$myname?action=show_ow_dev&amp;ow_dev=$9\">$9</a></td></tr>"
		shift 9
    	done
    	echo '</table>'
   else
	show_error "Hinweis:" "<b>\"OWFS\" ist nicht aktiviert.<br /></b>"
   fi
;;

#------------------------------------------------------------------------------
# Anzeige der 1-Wire-Devices-Parameter, show parameters 
#------------------------------------------------------------------------------

show_ow_dev)
	ow_dev=`dir $OWFS_PATH/$FORM_ow_dev`
	set -- $ow_dev
    	echo "<table class=\"normtable\">"
	echo "<tr><td colspan="2"><a href=\"$myname?action=status\">----^---- Zurck zur Status-Anzeige</a></td></tr>"
	echo "<tr><th colspan="2">Inhalt von $FORM_ow_dev:</th></tr>"
    	while [ "$9" ]
    	do
		echo "<tr><td>$9</td><td>`cat $OWFS_PATH/$FORM_ow_dev/$9`</td></tr>"
		shift 9
    	done
    	echo '</table>'
;;

#------------------------------------------------------------------------------
# Anzeige der OPT_OW Konfiguration, show config 
#------------------------------------------------------------------------------
  
konfiguration) 
   if [ -f $CONFFILE ]; then
    	conf=`cat $CONFFILE`
    	set -- $conf 
     	echo "<table class=\"normtable\">"
	echo "<tr><th>Inhalt der Konfigurationsdatei \"$CONFFILE\":</th></tr>"
	while [ "$1" ]
    	do
		echo "<tr><td>$1</td></tr>"
		shift 1
    	done
	echo "</table>"
   else
   	show_error "Fehler:" "<b>\"$CONFFILE\" nicht gefunden<br /></b>"
   fi
;;

esac
show_tab_footer
show_html_footer
