#!/bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/msmtp_retry.sh                                           v0.1m
#
# Mails mit Status "retry" versenden
#
# Creation:     2003-05-05  t_klingl
# Last Update:  2006-03-27  dke
#------------------------------------------------------------------------------

#----------------------------------------------------
# Variablen inkludieren
#----------------------------------------------------

. /etc/msmtp/msmtp_skripte.conf

#----------------------------------------------------
# Welche Dateien liegen vor ?
#----------------------------------------------------
for FILES in `ls ${MSMTP_SPOOL_DIR} | grep '^.*retry[0-9]\+$'`
do
	/usr/local/bin/msmtp_send.sh "${MSMTP_SPOOL_DIR}/${FILES}"
	
	if [ -e "${MSMTP_SPOOL_DIR}/${FILES}" ];
	then
	    # Versand gescheitert, neuen Namen ermitteln
	    TRY=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\2/g' | sed 's/[^0-9]//g'`
	    BASE=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\1/g'`
	    NEXTTRY=`expr ${TRY} + 1`
	    mv "${MSMTP_SPOOL_DIR}/${FILES}" "${MSMTP_SPOOL_DIR}/${BASE}${NEXTTRY}"
	fi
done
