#!/bin/sh
. /var/run/faxsnd.conf
# es darf nur einen geben
# wurde ich schon gestartet
if [ ! -f "$FAXSND_QUEUE/.workFax" ]
then
  # setze meine Marke
  > "$FAXSND_QUEUE/.workFax"
  # ... begin work
  # make a unique tag
  my_unique=1
  # start for all files
  for f in "$FAXSND_QUEUE"/*.sff
  do
    # schliesse den Abfrage-String aus
    if [ "$f" != "$FAXSND_QUEUE/*.sff" ]
    then
      # do work
      # phone number is first part of basename
      my_call=$(basename "$f")
      my_call=$(echo $my_call | cut -d "." -f 1)
      my_time="$(date +%Y.%m.%d-%H:%M:%S)"
      # tell what I am doing
      if [ -f /usr/bin/logger -o -L /usr/bin/logger ]
      then
        logger -t "capifaxsnd" "sending $f to $my_call"
      else
        echo "capifaxsnd: sending $f to $my_call" > /dev/console 2>&1
      fi
      # and do it
      /usr/local/bin/capifax -c "$FAXSND_MSN" -i "$FAXSND_ID" -h "$FAXSND_HEAD" "$my_call" "$f"
      # do not check, only report the Status
      my_rc="$?"
      # Status
      if [ "$my_rc" = "0" ]
      then
        my_status="Erfolg"
      else
        my_status="Fehler"
      fi
      # sichere die Datei und schreibe ein kleines log
      my_save="$FAXSND_DONE/$my_time.$my_status.$my_call.$my_unique.sff"
      my_unique=$(expr $my_unique + 1)
      # verschiebe die Quelldatei
      mv -f "$f" "$my_save"
      # falls move klemmt, nochmal richtig löschen - NUR ZUR SICHERHEIT
      rm -f "$f" 2>/dev/null
      if [ -f /usr/bin/logger -o -L /usr/bin/logger ]
      then
        logger -t "capifaxsnd" "status($my_rc) $f to $my_call"
      else
        echo "capifaxsnd: status($my_rc) $f to $my_call" > /dev/console 2>&1
      fi
      # log: keine Leerzeichen reinmachen !!!
      echo "$my_time|$my_status|$my_rc|$my_call|$f|$my_save" >> "$FAXSND_LOG"/faxsnd.log
    fi
  done
  # entferne meine Marke
  rm -f "$FAXSND_QUEUE/.workFax"
fi
