/*----------------------------------------------------------------
 *       Copyright (C) 2007 Gernot Miksch
 *          
 *----------------------------------------------------------------
 *
 * sff2tiff.c,v 1.00 2007/02/21 17:39:19
 *
 * converts SFF to TIFF
 *
 * Original author: Kolja Waschk 
 *
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <getopt.h>

extern int convert_sff_to_tiff(char*,char*,FILE *);

char* help[] = 
{ "sff2tiff V1.00 (c) 2007 Gernot Miksch",
  "convert sff fax file into tiff file.\n",
  "Usage: sff2tiff <input>  [-o <output>]",
  "Options:",
  "<input>:      sff fax file",
  "-o: <output>: optional output file instead of stdout",
  "-h:           this text",0
};


int main(int argc, char *argv[]) {
  int c;
  FILE* output=stdout;

  while((c = getopt(argc, argv, "o:h?")) != EOF) 
  {
    switch(c) 
    {
    case 'o':
      output=fopen(optarg,"wb");
      if (!output)
      {
        fprintf(stderr,"error opening %s\n",optarg);
        return -1;
      } 
      break;

    case '?':
    case 'h':
      for (c = 0; help[c] != NULL; c++)
      {
	fprintf(stderr, "%s\n", help[c]);
      }
      return 0;
      break;
    };
  };

  if(optind >= argc) 
  {
    fprintf(stderr,"input-file missing\n");
    return -1;
  };

  return convert_sff_to_tiff(argv[optind], argv[optind], output);
};

