#!/bin/sh

#------------------------------------------------------------------------------
# Creation:      27.03.2007    Christoph Fritsch <fli4l@dechristo.net>
# Last modified: 11.05.2008    Christoph Fritsch <fli4l@dechristo.net>
#-------------------------------------------------------------------------------

#--------------------------------------------------------
# fax2mail.sh
#--------------------------------------------------------

#---------------------------------------
# Hilfsfunktionen
#---------------------------------------
#---------------------------------------
# usage ()
#---------------------------------------
usage ()
{
    echo "usage: FAX2MAIL.sh sff_file or gziped sff_file MSN <List of recipients>"
    echo "       'sff-file' must be specified as an absolute path!"
    echo "       FAX2MAIL.sh -v"
    echo "       print out some version information"
}

#---------------------------------------
# log (string)
#---------------------------------------
log ()
{
    TEXT=$1

    if [ "${FAX2MAIL_LOGFILE}" != "" ]; then
        case "${FAX2MAIL_LOGFILE}"
        in
            syslog) logger "FAX2MAIL: ${TEXT}";;
            *)      echo "${DATE} FAX2MAIL: ${TEXT}" >> ${FAX2MAIL_LOGFILE};;
        esac
    fi
    
    return 1    
}

#---------------------------------------
# Hilfsvariablen
#---------------------------------------
. /etc/fax2mail.conf
VERSION='3.2.0a (2008-05-1)'
BASENAME=''

#---------------------------------------
# Aufrufparameter einlesen
#---------------------------------------

log "$*"

if [ "$1" = "-v" ]; then
    echo "FAX2MAIL.sh version ${VERSION}"
    exit 0
fi

## Syntax: cmd recipient1 recipient2 Faxfile MSN
while [ "$1" ]
do
    case $1 in
    *[^0-9]*)
        FILENAME="$1"
        case x$2 in
        x) csid=$FAXRCV_CSID 
           colecho "OPT_FAXSEND Parameter FAXRCV_CSID: $csid" cy
           log "OPT_FAXSEND Parameter FAXRCV_CSID: $csid"
           ;; 
        *) csid=$2 
           colecho "OPT_FAXSEND Parameter 2: $2" cy 
           log "OPT_FAXSEND Parameter 2: $2"
           ;;
        esac
        colecho "File: $FILENAME" cy
        colecho "MSN: $csid" cy
        log "File: $FILENAME"
        log "MSN: $csid"
        break 
        ;;
    *)
    #collect recipients
        RECIPIENTS="$RECIPIENTS $1" 
        colecho "Recipients: $RECIPIENTS" cy
        log "Recipients: $RECIPIENTS"
        ;;
    esac
    shift
done


if [ -f "$FILENAME" ]; then
    log "File $FILENAME ok"
else
    log "missing or invalid filename ($1). will quit now..."
    usage
    exit 1
fi


#---------------------------------------
# define MTA
#---------------------------------------
if [ "$FAX2MAIL_SMTP_CLIENT" = "ssmtp" ] 
then
    FAXCMD="ssmtp.sh"
else
    FAXCMD="msmtp.sh"
fi

#---------------------------------------
# prepare conversion
#---------------------------------------

     FAXDIR=`dirname "${FILENAME}"`
  EXTENSION=`basename "${FILENAME}" | sed 's/^\(.*\)\(\.sff\)\(.*\)$/\2\3/g'`
   BASENAME=`basename "${FILENAME}" .gz`
   BASENAME=`basename "${BASENAME}" .sff`
     TMPDIR=`date '+%Y%m%d%H%M%S'`          # temporary directory for conversion
       DATE=`date '+%d.%m.%Y %H:%M:%S Uhr'`
   FAXPAGES=`echo ${BASENAME} | cut -c 3-5 | sed 's/^[0]*//'`  # extract number of pages
     SENDER=`echo ${BASENAME} | cut -c 14-`  # extract sender
 SENDERNAME=`sed 's/,[^,]*$//' /etc/phonebook | grep "^${SENDER}=" | cut -d"=" -f 2-`  # get sendername from /etc/phonebook

if [ "${SENDERNAME}" = "" ];
then
    SENDERNAME=${SENDER}" (unbekannt)"
fi

cd "${FAXDIR}"
mkdir -p "${TMPDIR}"
if [ -d "${TMPDIR}" ];
then
    # temporary directory exists
    #-------------------------------
    # start conversion
    #-------------------------------
    
    # work with copy only
    cp "${FILENAME}" "${TMPDIR}"
    cd "${TMPDIR}"
    
    #--------------------
    # unzip if necessary
    #--------------------
    if [ "${EXTENSION}" = ".sff.gz" ]; then
        gzip -d "${BASENAME}${EXTENSION}" > /dev/null 2>&1
    fi

    #--------------------
    # convert to multipage TIFF 
    #--------------------
    if [ "${OPT_FAX2MAIL_TIF}" = "yes" ]; then
        #sfftobmp -t "${BASENAME}.sff" "${BASENAME}.tif"
        sff2tiff "${BASENAME}.sff" -o "${BASENAME}.tif"
    fi
    
    #--------
    # PDF
    #--------
    if [ "${OPT_FAX2MAIL_PDF}" = "yes" ]; then
        tiff2pdf "${BASENAME}.tif" -f -o "${BASENAME}.pdf"
    fi

    #--------
    # PS
    #--------
    if [ "${OPT_FAX2MAIL_PS}" = "yes" ]; then
        sff2misc -p "${BASENAME}.tif" "${BASENAME}"
    fi

    #--------
    # PNG
    #--------
    if [ "${OPT_FAX2MAIL_PNG}" = "yes" ]; then
        PAGE="1"
        while [ ${PAGE} -le ${FAXPAGES} ];
        do
            tiff2png "${BASENAME}.tif" "${BASENAME}_${PAGE}.png" -p ${PAGE} -a
            PAGE=`expr ${PAGE} + 1`
        done
    fi
    
    #--------
    # JPEG
    #--------
    if [ "${OPT_FAX2MAIL_JPG}" = "yes" ]; then
        case "`echo $filename | cut -b1-2`" in
            fn) conv_option="-d" ;;
            *)  conv_option="-j" ;;
        esac
        
        #creates BASENAME.$PAGE.jpg
            sff2misc $conv_option $BASENAME.sff $BASENAME
    fi
    
    #-------------------------------
    # conversions done
    #-------------------------------
    
    #-------------------------------
    # create bodytext
    #-------------------------------
    {
        echo -e "Fax von     : ${SENDERNAME}\r"
        echo -e "Faxnummer   : ${SENDER}\r"
        echo -e "Datum       : ${DATE}\r"
        echo -e "Seiten      : ${FAXPAGES}\r"
    } > body.txt

    #-----------------------------------
    # send received fax as mail
    #-----------------------------------
    
    for RECIPIENT in $RECIPIENTS
    do
        eval TO='$FAX2MAIL_'$RECIPIENT'_TO'
        eval FORMAT='$FAX2MAIL_'$RECIPIENT'_FORMAT'
        eval GZIP='$FAX2MAIL_'$RECIPIENT'_GZIP'
        log "To: $TO From: $FROM, Gzip: $GZIP"

        if [ "$GZIP" = "yes" ]; then
            /usr/local/bin/tar czfv "FAX_von_${SENDER}.tgz" *."${FORMAT}"
            FORMAT="tgz"
        fi
        $FAXCMD \
        -f "${FAX2MAIL_FROM}" \
        -t "${TO}" \
        -r "${FAX2MAIL_REPLY_TO}" \
        -s "Fax von ${SENDERNAME}, ${FAXPAGES} Seite(n)" \
        -b "${FAXDIR}/${TMPDIR}/body.txt" \
        -d "${FAXDIR}/${TMPDIR}" \
        -rn "^body.txt$" \
        -rp "^.*$FORMAT$"
    done
    
    #-------------------------------
    # cleanup
    #-------------------------------
    cd ..
    rm -rf "${TMPDIR}"
    
    # done!
else
    log "Cannot create temporary directory. Will quit now ..."
    exit 1
fi

exit 0
