#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <asm/io.h>
#include <signal.h>
#include <netinet/tcp.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/stat.h>

#define MAXLEN		255
#define NETDEVFILENAME	"/proc/net/dev"
#define FIELDCOUNT 	11	/* 12 really, 7 for 2.0, 11 for 2.2 */
#define CHILD 0
#define ERROR -1

int 		got_signal=0;
char*		find_device_line (char* buffer, char* netDeviceName);
void 		report_traffic (char** list);
char**		split_on_blank (char* line);
static const char	devFileName [] = NETDEVFILENAME;
static long long	formerReceived = 0L;
static long long	formerTransmitted = 0L;


/*Einen Daemon starten*/
void start_daemon(char *log_name, int facility)
{
 int i;
 pid_t pid;

 if((pid = fork()) != CHILD) exit(0);
 if(setsid() == ERROR)
  {
  fprintf(stderr, "%s kann nicht Session-Fhrer werden!\n",log_name);
  exit(0);
  }
 chdir("/");
 umask(0);
 for(i=sysconf(_SC_OPEN_MAX); i>0; i--)
  close(i);

 openlog(log_name, LOG_PID, facility);
}

void handler (int signal)
{
  got_signal=signal;
}


/*PPPOE_Status*/
int status(int device)
{
FILE *datei;
int stat=0;

if (device==1)
 {
 datei=fopen("/var/run/pppoe.up","r");
 if(datei==NULL)
  {
   stat=0;
  }
 else
   {
   stat=1;
   fclose(datei);
   }
 }
if (device==2)
 {
 stat=1;
 }

 return(stat);
 }

/*Ausgabe an den LPT-Port*/
void out_byte(int port, unsigned char byte)
{
  outb(byte, port);
}


/*Bestimmen der Interfacerate*/
char*	find_device_line (char* buffer, char* netDeviceName)
{
static long	fileOffset = 0L;
register FILE*	devFile;

if (! (devFile = fopen(devFileName, "r")) ) {
	perror(devFileName);
	exit(1);
}
#if 0
fgets(buffer, MAXLEN, devFile);
fgets(buffer, MAXLEN, devFile);
#else
if (fileOffset) {
	fseek(devFile, fileOffset, SEEK_SET);
} else {
	fgets(buffer, MAXLEN, devFile);
	fileOffset += (long)strlen(buffer);
	fgets(buffer, MAXLEN, devFile);
	fileOffset += (long)strlen(buffer);
}
#endif

while ( fgets(buffer, MAXLEN, devFile) ) {
	while(isblank(*buffer))
		buffer++;
	if (buffer == strstr(buffer, netDeviceName)) {
		fclose(devFile);
		return buffer;
	}
}
fclose(devFile);
return NULL;
}

char**	split_on_blank (char* line)
{

static char* 	list [FIELDCOUNT] = {};
register int 	i;

i = 0;
goto middle;
for (; i < FIELDCOUNT; i++) {
	while (isblank(*line))
		line++;
middle:
	list[i] = line;
	while (! isblank(*line) && *line != ':' && *line != '\n')
		line++;
	*(line++) = '\0';
}
return list;
}


void	report_traffic (char** list)
{
long long	received, transmitted;

received = strtoq(list[1],NULL,0);
transmitted = strtoq(list[9],NULL,0);

formerReceived=received;
formerTransmitted=transmitted;
}


/* Das Wichtigste */
int main ( int argc, char *argv[] )
{
  int LED=32,i=0,delay=1000;
  int mode=2;
  int lport = 0x378;
  int irate,orate,irate_max,orate_max;
  float iratea,oratea=0;
  char*	interfaceName;
  char	buffer [MAXLEN];
  char*	tmpPointer;
  char**	list;
struct 	timeval start, ende;
int 	sekunden,mikrosekunden;
float   sekunden_gesamt;
int	received_traffic[4],transmitted_traffic[4];
long long 	received_old,transmitted_old;
int device=1;
int zahl23=120;

    start_daemon("traffout", LOG_USER);


    lport = atoi(argv[3]);

      switch (lport)
      {
      case 0: lport = 0x378; break;
      case 1: lport = 0x278; break;
      case 2: lport = 0x3bc; break;
      }

    LED = atoi(argv[4]) / 2;
    mode = atoi(argv[5]);
    delay =  60000000/atoi(argv[6]);
    irate_max = atoi(argv[1]);
    orate_max = atoi(argv[2]);
    interfaceName = NULL;
    interfaceName = argv[7];
    device = atoi(argv[8]);

if (! find_device_line(buffer, interfaceName))
	{
	printf(
	    "There is currently no such interface as %s in %s.\n%s\n",
	    interfaceName, devFileName,
	    "Maybe later there will be. Closing");
	exit(0);
	}


if (ioperm(lport, 3, 1)) {perror("ioperm"); exit(1);}

    signal(SIGHUP,  handler);
    signal(SIGINT,  handler);
    signal(SIGQUIT, handler);
    signal(SIGTERM, handler);

gettimeofday(&start,(struct timezone *)0);
if ((tmpPointer = find_device_line(buffer, interfaceName)))
	{
	list = split_on_blank(tmpPointer);
	report_traffic(list);
	}


while(got_signal==0)
{
	if (status(device)==1)
		{
		usleep(delay);
		received_old = formerReceived;
		transmitted_old = formerTransmitted;

		if ((tmpPointer = find_device_line(buffer, interfaceName)))
			{
			list = split_on_blank(tmpPointer);
			report_traffic(list);
			}

		gettimeofday(&ende,(struct timezone *)0);
 		sekunden = ende.tv_sec - start.tv_sec;
 		mikrosekunden = ende.tv_usec - start.tv_usec;
		if(mikrosekunden < 0)
	  		{
	   		mikrosekunden+=1000000;
	   		mikrosekunden--;
	  		}
		sekunden_gesamt = sekunden *1000000 + mikrosekunden;
		sekunden_gesamt = sekunden_gesamt /1000000;

 		received_traffic[3] = received_traffic[1];
 		transmitted_traffic[3] = transmitted_traffic[1];

		if (formerReceived != received_old)
        		{
        		received_traffic[1]=(formerReceived - received_old)/sekunden_gesamt;
        		}
        		else
        		{
        		received_traffic[1]=0;
        		}
		if (formerTransmitted != transmitted_old)
        		{
        		transmitted_traffic[1]=(formerTransmitted - transmitted_old)/sekunden_gesamt;
        		}
			else
			{
			transmitted_traffic[1]=0;
			}

         	received_traffic[1] = received_traffic[1] + received_traffic[2];
         	transmitted_traffic[1] = transmitted_traffic[1] + transmitted_traffic[2];


         	if (received_traffic[1] > (irate_max*1024))
         		{
         		received_traffic[2] = received_traffic[1] - (irate_max*1024);
         		received_traffic[1] = irate_max*1024;
         		}
         	else
         		{
         		received_traffic[2] = 0;
         		}
         	if (transmitted_traffic[1] > (orate_max*1024))
         		{
         		transmitted_traffic[2] = transmitted_traffic[1] - (orate_max*1024);
         		transmitted_traffic[1] = orate_max*1024;
         		}
         	else
         		{
         		transmitted_traffic[2] = 0;
         		}
         	if (received_traffic[2] > (irate_max*2048))
         		{
         		received_traffic[2] = irate_max*2048;
         		}
         	if (transmitted_traffic[2] > (orate_max*2048))
         		{
         		transmitted_traffic[2] = orate_max*2048;
         		}

		received_traffic[4] =  (received_traffic[1] + received_traffic[3])/2;
		transmitted_traffic[4] =  (transmitted_traffic[1] + transmitted_traffic[3])/2;


  		iratea=received_traffic[4]*LED;
  		oratea=transmitted_traffic[4]*LED;
		iratea = iratea /1024 /irate_max;
		oratea = oratea /1024 /orate_max;

		if ((iratea > 0) && (iratea < 0.5))
		{
		iratea = 0.5;
		}
		if (iratea >= 0.5)
		{
		iratea=iratea+0.5;
		}

		if ((oratea > 0) && (oratea < 0.5))
		{
		oratea = 0.5;
		}
		if (oratea >= 0.5)
		{
		oratea=oratea+0.5;
		}


		irate=(int)iratea;
		orate=(int)oratea;

  		if ((iratea-(float)irate)>=0.5)
		{
		  irate=irate+1;
		}
		if ((oratea-(float)orate)>=0.5)
		{
	 	  orate=orate+1;
		}

		if (irate > LED)
		{
		  irate = LED;
		}
		if (orate > LED)
		{
		  orate = LED;
		}

  		if (mode==1)
  	     	   {
  	     	   if (orate>0 )
		   {
		   i=LED-orate;
	     	   while (i>0)
		   	{
		   	out_byte(lport,inb(lport)&252);
		   	out_byte(lport,inb(lport)|130);
		   	out_byte(lport,inb(lport)&252);
		   	i--;
		   	}
   		   out_byte(lport,inb(lport)|129);
		   out_byte(lport,inb(lport)|131);
		   out_byte(lport,inb(lport)&252);
		   i=orate-1;
	     	   while (i>0)
		   	{
		   	out_byte(lport,inb(lport)&252);
		   	out_byte(lport,inb(lport)|130);
		   	out_byte(lport,inb(lport)&252);
		   	i--;
		   	}
   		   }
   		   else
   		   {
	     	   i=LED;
	     	   while (i>0)
		   	{
		   	out_byte(lport,inb(lport)&252);
		   	out_byte(lport,inb(lport)|130);
		   	out_byte(lport,inb(lport)&252);
		   	i--;
		   	}
   		   }

                   if (irate>0 )
		   	{
		   	i=irate-1;
	     	   	while (i>0)
		   		{
        		   	out_byte(lport,inb(lport)&252);
        		   	out_byte(lport,inb(lport)|130);
        		   	out_byte(lport,inb(lport)&252);
        		   	i--;
        		   	}
           		out_byte(lport,inb(lport)|129);
        		out_byte(lport,inb(lport)|131);
        		out_byte(lport,inb(lport)&252);
        		i=LED-irate;
        	     	while (i>0)
        		   	{
        		   	out_byte(lport,inb(lport)&252);
        		   	out_byte(lport,inb(lport)|130);
        		   	out_byte(lport,inb(lport)&252);
        		   	i--;
        		   	}
   		   	}
   		   else
   		   	{
        	     	i=LED;
        	     	while (i>0)
        		  	{
        		   	out_byte(lport,inb(lport)&252);
        		   	out_byte(lport,inb(lport)|130);
        		   	out_byte(lport,inb(lport)&252);
        		   	i--;
        		   	}
           		}

        	   out_byte(lport,inb(lport)|132);
        	   out_byte(lport,inb(lport)&248);

		}

  		if (mode==2)
  			{
        		i=orate;
        		while (i>0)
        		   {
        		   out_byte(lport,inb(lport)|129);
        		   out_byte(lport,inb(lport)|131);
        		   out_byte(lport,inb(lport)&252);
        		   i--;
        		   }
        		i=LED-orate;
        		while (i>0)
        		   {
        		   out_byte(lport,inb(lport)&252);
        		   out_byte(lport,inb(lport)|130);
        		   out_byte(lport,inb(lport)&252);
        		   i--;
        		   }
        		i=LED-irate;
        		while (i>0)
        		   {
        		   out_byte(lport,inb(lport)&252);
        		   out_byte(lport,inb(lport)|130);
        		   out_byte(lport,inb(lport)&252);
        		   i--;
        		   }
        		i=irate;
        		while (i>0)
        		   {
        		   out_byte(lport,inb(lport)|129);
        		   out_byte(lport,inb(lport)|131);
        		   out_byte(lport,inb(lport)&252);
        		   i--;
        		   }
        		out_byte(lport,inb(lport)|132);
        		out_byte(lport,inb(lport)&248);
        		}
        	gettimeofday(&start,(struct timezone *)0);
		}
	else
		{
		i=2*LED;
		while (i>0)
		   {
		   out_byte(lport,inb(lport)&124);
		   out_byte(lport,inb(lport)|2);
		   out_byte(lport,inb(lport)&124);
		   i--;
		   }
		out_byte(lport,inb(lport)|4);
		out_byte(lport,inb(lport)&120);
		sleep(1);
	}
 }

  i=2*LED;
  while (i>0)
	{
	out_byte(lport,inb(lport)&124);
        out_byte(lport,inb(lport)|2);
	out_byte(lport,inb(lport)&124);
	i--;
	}
  out_byte(lport,inb(lport)|4);
  out_byte(lport,inb(lport)&120);
  if (ioperm(lport, 3, 0)) {perror("ioperm"); exit(1);}
  return(0);
}
