# callout.py
# 
# example for using the python SimpleCapi interface
# 
# Part of the caiviar package. 
# 
# Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>
# 
# This file is distributed under the GPL, see file COPYING for details.

import sys
sys.path += ["../../client"]
import SimpleCapi

# warning: The python interface is not yet thoroughly tested.
capi = SimpleCapi.SimpleCapi("127.0.0.1", 7347)
ret = capi.call("123456789")
if ret!=0:
    if ret==SimpleCapi.CAPI_REASON_TECHNICAL: print "no answer"
    if ret==SimpleCapi.CAPI_REASON_BUSY: print "busy"
    if ret==SimpleCapi.CAPI_REASON_WRONGNUMBER: print "wrongnumber"
    if ret==SimpleCapi.CAPI_REASON_REJECTED: print "rejected"
    if ret==SimpleCapi.CAPI_REASON_NOANSWER: print "noanswer"
    sys.exit(1)

capi.play("test.wav")

while 1:
    event = capi.listen()
    capi.printEvent(event)
    if(event.type == SimpleCapi.CAPI_EVENT_HANGUP):
	break
    if(event.type == SimpleCapi.CAPI_EVENT_DONE):
	break
    if(event.type == SimpleCapi.CAPI_EVENT_DIALTONE):
	print "dialtone: "+event.tone
    
capi.hangup()
capi.close()
