# SimpleCapi.pm
#
# Perl implementation of the SimpleCapi interface, to be used
# to interface to the capiserver program.
# 
# Copyright (c) 2002 Matthias Kramm (kramm@quiss.org)
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package SimpleCapi;

use IO::Socket;

#internal
sub __readanswer
{
    my $this = shift;
    my $function = shift;
    my $head = shift;
    my $socket = $this->{socket};
    $_ = <$socket>;
    die "$function: Wrong answer from server: \"$_\" (was expecting \"$head*\")" unless (/^$head(.*)$/);
    return $1;
}

sub new
{
    my $host = shift;
    my $port = shift;
    print "connecting to host $host on port $port\n";
    my $socket = new IO::Socket::INET ( PeerAddr => $host,
	                                        PeerPort => $port,
						Proto => 'tcp',); 
    my $this = {
	"socket" => $socket,
	"line" => -1,

	"CAPI_EVENT_TIMEOUT" => 0,
	"CAPI_EVENT_HANGUP" => 1,
	"CAPI_EVENT_INCOMING" => 2,
	"CAPI_EVENT_DONE" => 3,
	"CAPI_EVENT_DIALTONE" => 4,
	"CAPI_EVENT_CONNECTED" => 5,

	"CAPI_REASON_TECHNICAL" => 1,
	"CAPI_REASON_BUSY" => 2,
	"CAPI_REASON_WRONGNUMBER" => 3,
	"CAPI_REASON_REJECTED" => 4,
	"CAPI_REASON_NOANSWER" => 5,
    };
    bless $this, 'SimpleCapi';
    
    $this->{line} = __readanswer($this, "new", "open=");
    print "connection established - was assigned line ".$this->{line}."\n";

    return $this;
}


sub setMSISDN {
    my $this = shift;
    print $socket "set msisdn $_[0]\n";
    $this->{line} = __readanswer($this, "setMSISDN", "ok=");
}

sub acceptCalls {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "accept\n";
    __readanswer($this, "acceptCalls", "ok");
}

sub call {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "call $_[0] $_[1]\n";
    return __readanswer($this, "call", "ok=");
}

sub call_nonblock {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "call_nonblock $_[0]\n";
    return __readanswer($this, "call_nonblock", "ok=");
}

#sub put {
#    my $this = shift;
#    print $socket "put $_[0] $_[1]\n";
#    __readanswer($this, "put", "ok");
#}
#
#sub get {
#    my $this = shift;
#    print $socket "put $_[0] $_[1]\n";
#    __readanswer($this, "get", "ok");
#}

sub del {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "del $_[0]\n";
}

sub beep {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "beep $_[0]\n";
    __readanswer($this, "beep", "ok");
}

sub hold {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "hold\n";
    return __readanswer($this, "hold", "ok=");
}

sub retrieve {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "retrieve\n";
    return __readanswer($this, "retrieve", "ok=");
}

sub supplemental {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "supplemental $_[0]\n";
    return __readanswer($this, "supplemental", "ok=");
}

sub play {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "play $_[0]\n";
    return __readanswer($this, "play", "ok=");
}

sub speak {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "speak \")$_[0]\"\n";
    return __readanswer($this, "speak", "ok=");
}

sub record {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "record $_[0] $_[1]\n";
    return __readanswer($this, "record", "ok=");
}

sub fax {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "fax $_[0] $_[1]\n";
    return __readanswer($this, "fax", "ok=");
}

sub stop {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "stop $_[0]\n";
    __readanswer($this, "stop", "ok");
}

sub listen {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "listen $_[0]\n";
    my $event={};
    $event->{msisdn}=(__readanswer($this, "listen:msisdn", "msisdn="));
    $event->{called_msisdn}=(__readanswer($this, "listen:called_msisdn", "called_msisdn="));
    $event->{id}=(__readanswer($this, "listen:id", "id="));
    $event->{type}=(__readanswer($this, "listen:type", "type="));
    $event->{jobid}=(__readanswer($this, "listen:jobid", "jobid="));
    $event->{tone}=(__readanswer($this, "listen:tone", "tone="));
    $event->{reason}=(__readanswer($this, "listen:reason", "reason="));
    __readanswer($this, "listen", "ok");
    return $event;
}

sub answer {
    my $this = shift;
    my $socket = $this->{socket};
    my %event = shift;
    print $socket "answer $event{id}\n";
    return __readanswer($this, "answer", "ok=");
}

sub reject {
    my $this = shift;
    my $socket = $this->{socket};
    my %event = shift;
    print $socket "reject $event{id}\n";
    __readanswer($this, "reject", "ok");
}

sub ignore {
    my $this = shift;
    my $socket = $this->{socket};
    my %event = shift;
    print $socket "ignore $event{id}\n";
    __readanswer($this, "ignore", "ok");
}

sub forward {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "forward $_[0]\n";
    return __readanswer($this, "forward", "ok=");
}

sub hangup {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "hangup\n";
    __readanswer($this, "hangup", "ok");
}

sub connect {
    my $this = shift;
    my $socket = $this->{socket};
    my $capi2 = shift;
    print $socket "connect ".$this->{line}." ".$capi2->{line}."\n";
    __readanswer($this, "connect", "ok");
}

sub close {
    my $this = shift;
    my $socket = $this->{socket};
    print $socket "close\n";
    __readanswer($this, "close", "ok");
}

sub printEvent {
    my $this = shift;
    my $event = shift;
    print "type:TIMEOUT\n" if($event->{type} == $this->{CAPI_EVENT_TIMEOUT});
    print "type:HANGUP\n" if($event->{type} == $this->{CAPI_EVENT_HANGUP});
    print "type:INCOMING\n" if($event->{type} == $this->{CAPI_EVENT_INCOMING});
    print "type:DONE\n" if($event->{type} == $this->{CAPI_EVENT_DONE});
    print "type:DIALTONE\n" if($event->{type} == $this->{CAPI_EVENT_DIALTONE});
    print "type:CONNECTED\n" if($event->{type} == $this->{CAPI_EVENT_CONNECTED});

    print "msisdn:".$event->{msisdn}."\n";
    print "called_msisdn:".$event->{called_msisdn}."\n";
    print "id:".$event->{id}."\n";
    print "jobid:".$event->{jobid}."\n" if($event->{type} == $this->{CAPI_EVENT_DONE});
    printf("tone: %d %c\n",$event->{tone},$event->{tone}) if($event->{type} == $this->{CAPI_EVENT_DIALTONE});
    print "reason:".$event->{reason}."\n" if($event->{type} == $this->{CAPI_EVENT_HANGUP});
}

"SimpleCapi.pm";
