/*
 * Decompiled with CFR 0.152.
 */
package caivar;

import caivar.CapiEvent;
import caivar.CommandFailedException;
import caivar.NoLineFreeException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class SimpleCapi {
    static final int TIMEOUT = 0;
    static final int CAPI_EVENT_HANGUP = 1;
    static final int CAPI_EVENT_INCOMING = 2;
    static final int CAPI_EVENT_DONE = 3;
    static final int CAPI_EVENT_DIALTONE = 4;
    static final int CAPI_EVENT_CONNECTED = 5;
    static final int CAPI_REASON_TECHNICAL = 1;
    static final int CAPI_REASON_BUSY = 2;
    static final int CAPI_REASON_WRONGNUMBER = 3;
    static final int CAPI_REASON_REJECTED = 4;
    static final int CAPI_REASON_NOANSWER = 5;
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out = null;
    private int line;

    public SimpleCapi(String server, int port) throws IOException, NoLineFreeException {
        this.socket = new Socket(server, port);
        OutputStream out = this.socket.getOutputStream();
        InputStream in = this.socket.getInputStream();
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new PrintWriter(out);
        try {
            this.line = Integer.parseInt(this.readAnswer("open="));
        }
        catch (CommandFailedException e) {
            throw new NoLineFreeException(e.getMessage());
        }
    }

    public synchronized void setMSISDN(String msisdn) throws IOException, CommandFailedException {
        this.sendCommand("set msisdn " + msisdn);
        this.line = Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized void acceptCalls() throws IOException, CommandFailedException {
        this.sendCommand("accept");
        this.readAnswer("ok");
    }

    public synchronized int call(String msisdn, int timeout) throws IOException, CommandFailedException {
        this.sendCommand("call " + msisdn + " " + timeout);
        return Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized int call_nonblock(String msisdn) throws IOException, CommandFailedException {
        this.sendCommand("call_nonblock " + msisdn);
        return Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized void put(String filename, String destname) throws IOException, CommandFailedException {
        FileInputStream file = new FileInputStream(filename);
        this.sendCommand("put " + destname + " " + file.available());
        byte[] array = new byte[file.available()];
        int ret = file.read(array);
        for (int t = 0; t < array.length; ++t) {
            this.out.write(array[t]);
        }
        this.out.flush();
        this.readAnswer("ok");
    }

    public synchronized void get(String filename, String destname) throws IOException, CommandFailedException {
        throw new CommandFailedException("not implemented yet!");
    }

    public synchronized void del(String filename) throws IOException, CommandFailedException {
        this.sendCommand("del " + filename);
        this.readAnswer("ok");
    }

    public synchronized void beep(String notes) throws IOException, CommandFailedException {
        this.sendCommand("beep " + notes);
        this.readAnswer("ok");
    }

    public synchronized boolean hold() throws IOException, CommandFailedException {
        this.sendCommand("hold");
        return Integer.parseInt(this.readAnswer("ok=")) != 0;
    }

    public synchronized boolean retrieve() throws IOException, CommandFailedException {
        this.sendCommand("retrieve");
        return Integer.parseInt(this.readAnswer("ok=")) != 0;
    }

    public synchronized boolean supplemental(String command) throws IOException, CommandFailedException {
        this.sendCommand("supplemental " + command);
        return Integer.parseInt(this.readAnswer("ok=")) != 0;
    }

    public synchronized int play(String filename) throws IOException, CommandFailedException {
        this.sendCommand("play " + filename);
        return Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized int speak(String text) throws IOException, CommandFailedException {
        this.sendCommand("speak \"" + text + "\"");
        return Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized int record(String filename, int seconds) throws IOException, CommandFailedException {
        this.sendCommand("record \"" + filename + "\" " + seconds);
        return Integer.parseInt(this.readAnswer("ok="));
    }

    public synchronized boolean fax(String msisdn, String filename) throws IOException, CommandFailedException {
        this.sendCommand("fax " + msisdn + " " + filename);
        return Integer.parseInt(this.readAnswer("ok=")) == 1;
    }

    public synchronized void stop(int jobid) throws IOException, CommandFailedException {
        this.sendCommand("stop " + jobid);
        this.readAnswer("ok");
    }

    public synchronized CapiEvent listen(int timeout) throws IOException, CommandFailedException {
        String s;
        this.sendCommand("listen " + timeout);
        CapiEvent event = new CapiEvent();
        event.msisdn = s = this.readAnswer("msisdn=");
        event.called_msisdn = s = this.readAnswer("called_msisdn=");
        s = this.readAnswer("id=");
        event.id = Integer.parseInt(s);
        s = this.readAnswer("type=");
        event.type = Integer.parseInt(s);
        s = this.readAnswer("jobid=");
        event.jobid = Integer.parseInt(s);
        s = this.readAnswer("tone=");
        switch (Integer.parseInt(s)) {
            case 35: {
                event.tone = (char)35;
                break;
            }
            case 42: {
                event.tone = (char)42;
                break;
            }
            case 48: {
                event.tone = (char)48;
                break;
            }
            case 49: {
                event.tone = (char)49;
                break;
            }
            case 50: {
                event.tone = (char)50;
                break;
            }
            case 51: {
                event.tone = (char)51;
                break;
            }
            case 52: {
                event.tone = (char)52;
                break;
            }
            case 53: {
                event.tone = (char)53;
                break;
            }
            case 54: {
                event.tone = (char)54;
                break;
            }
            case 55: {
                event.tone = (char)55;
                break;
            }
            case 56: {
                event.tone = (char)56;
                break;
            }
            case 57: {
                event.tone = (char)57;
            }
        }
        s = this.readAnswer("reason=");
        event.reason = Integer.parseInt(s);
        s = this.readAnswer("ok");
        return event;
    }

    public synchronized boolean answer(CapiEvent event) throws IOException, CommandFailedException {
        this.sendCommand("answer " + event.id);
        return Integer.parseInt(this.readAnswer("ok=")) != 0;
    }

    public synchronized void reject(CapiEvent event) throws IOException, CommandFailedException {
        this.sendCommand("reject " + event.id);
        this.readAnswer("ok");
    }

    public synchronized void ignore(CapiEvent event) throws IOException, CommandFailedException {
        this.sendCommand("ignore " + event.id);
        this.readAnswer("ok");
    }

    public synchronized boolean forward(String msisdn) throws IOException, CommandFailedException {
        this.sendCommand("forward " + msisdn);
        return Integer.parseInt(this.readAnswer("ok=")) != 0;
    }

    public synchronized void hangup() throws IOException, CommandFailedException {
        this.sendCommand("hangup");
        this.readAnswer("ok");
    }

    public synchronized void connect(SimpleCapi capi1, SimpleCapi capi2) throws IOException, CommandFailedException {
        this.sendCommand("connect " + capi1.line + " " + capi2.line);
        this.readAnswer("ok");
    }

    public synchronized void close() {
        this.out.println("close");
        this.out.flush();
        try {
            this.readAnswer("ok");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendCommand(String s) throws IOException {
        this.out.println(s);
        this.out.flush();
    }

    private String readAnswer(String header) throws IOException, CommandFailedException {
        String s = this.in.readLine();
        if (s == null) {
            throw new IOException("Got NULL while reading from socket");
        }
        if (!header.equalsIgnoreCase(s.substring(0, header.length()))) {
            if (s.startsWith("error: ")) {
                throw new CommandFailedException(s.substring("error: ".length()));
            }
            throw new IOException("while reading from socket: got, \"" + s + "\" but expected \"" + header + "*\"");
        }
        return s.substring(header.length());
    }

    public void finalize() {
        this.close();
    }
}

