#!/bin/sh
#################################################
# parameter: $1         ; $2      ; $3      ; $4   ; $5     ; $6
#            IP-Adresse ; ID      ; Vorname ; Name ; e-mail ; mac
#
# gerufen von: c3surf_login, c3surf_admlogin
#
#
# /usr/local/bin/c3surf_setiptimer.sh "$c3surf_ip" "$fsid" "$fsvorname" "$fsname" "$fsmail" "$c3surf_mac"
#################################################
# iptables -t nat -I c3surf_nat_control 1 -s 192.168.13.8 -j RETURN
#/sbin/iptables -t nat -A ONCO_blocklist -p tcp -s $ip -d ! fli4l-eth2 --dport 80 -j DNAT --to 192.168.100.1:80
#
c3surf_ip=$1
#
# Variablen setzen
. /var/run/c3surf.conf
#
#
# checken, ob bereits eine Datei da ist --- counter erhhen (gibt noch keine quota)
# spter auch noch quota checken
if [ -f $C3SURF_TMP_PATH/$c3surf_ip.time ]
then
  # eigentlich vorher schon geprft - aber schadet hier nicht
  if [ ! -f $C3SURF_LOG_PATH/c3surf.lock ]
  then
    {
      read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
    } < $C3SURF_TMP_PATH/$c3surf_ip.time
    c3surf_count=`/usr/bin/expr $c3surf_count + 1`
    fstime=`date +%s`
    c3surf_time=`expr $fstime + $C3SURF_SECS`
    echo "$c3surf_time" "$c3surf_count" "$c3surf_id" "$c3surf_mac" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" > $C3SURF_TMP_PATH/$c3surf_ip.time
    /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" $c3surf_mac "prolong:$c3surf_count"
  fi
# es ist die erste Anmeldung
else
	# mac-Adresse holen, falls sie fehlt
  if [ "$6" = "" ]
  then
    . /usr/local/bin/c3surf_getmac.sh
  else
    c3surf_mac="$6"
  fi
  # drfte hier nicht vorkommen, aber lieber nochmals checken
  # id="-" ($2) bedeutet login by adm, das geht auch bei "Lock"
  if [ ! -f $C3SURF_LOG_PATH/c3surf.lock -o "$2" = "-" ]
  then
    /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$3" "$4" "$5" $c3surf_mac "login"
  # read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
    if [ "$2" = "-" ]
    then
      echo "0" "0" "$2" "$c3surf_mac" "$3" "$4" "$5" > $C3SURF_TMP_PATH/$c3surf_ip.time_adm
    else
      fstime=`date +%s`
      fstime=`expr $fstime + $C3SURF_SECS`
      echo "$fstime" "0" "$2" "$c3surf_mac" "$3" "$4" "$5" > $C3SURF_TMP_PATH/$c3surf_ip.time
    fi
    # Filter lsen
    /sbin/iptables -t nat -I c3surf_nat_control 1 -s $c3surf_ip -j RETURN
    /sbin/iptables -I c3surf_control 1 -s $c3surf_ip -j RETURN
  fi
fi