#!/bin/sh
###################################################
# 3surf: logout this IP
# parameter: $1 = IP-address, $2 optional = action (counter, logout)
#
# Frank Saurbier, 2007, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
###################################################
. /var/run/c3surf.conf
c3surf_ip="$1"

if [ -f "$C3SURF_TMP_PATH/$c3surf_ip.time" ]
then
  # hole die Daten des Surfers
  {
    read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
  } < $C3SURF_TMP_PATH/$c3surf_ip.time
  rm -f $C3SURF_TMP_PATH/$c3surf_ip.time
  # log das Ergebnis
  /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" "$c3surf_mac" "$2"
  #                                    IP-Adresse ; Vorname ;         Name ;        e-mail ;        mac         ; action (optional, def:"unknown")
elif [ -f "$C3SURF_TMP_PATH/$c3surf_ip.time_adm" ]
then
  # hole die Daten der admin Freischaltung
  {
    read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
  } < $C3SURF_TMP_PATH/$c3surf_ip.time_adm
  rm -f $C3SURF_TMP_PATH/$c3surf_ip.time_adm
  # log das Ergebnis
  /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" "$c3surf_mac" "$2"
  #                                    IP-Adresse ; Vorname ;         Name ;        e-mail ;        mac         ; action (optional, def:"unknown")
fi

# entferne immer jeden Fall die Freischaltung in den Filtern
/sbin/iptables -D c3surf_control -s $c3surf_ip -j RETURN
/sbin/iptables -t nat -D c3surf_nat_control -s $c3surf_ip -j RETURN
