#!/bin/sh
###################################################
# 3surf: check the post-method and login if everything is ok
# parameter: 1.IP-address, 2.id, 3.vorname, 4.name, 5.mail
# /usr/local/bin/c3surf_login.sh "$REMOTE_ADDR" "$fsid" "$fsvorname" "$fsname" "$fsmail"
# Frank Saurbier, 2008, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
# nicht sourcen: endet mit exit code
###################################################
. /var/run/c3surf.conf

# locale vars
c3surf_sstatus=""
c3surf_nstatus=0
c3surf_cstatus=""

if [ "$OPT_LOGINUSR" = "yes" ]
then
  fsid="$2"
  if [ ! -f $C3SURF_TMP_PATH/$fsid.data ]
  then
    c3surf_sstatus="Es ist eine echte Anmeldung erforderlich"
    c3surf_nstatus=7
    c3surf_cstatus="LOGINUSR_unknown:"
  fi
else
# Kompletter Gltigkeitscheck
  if [ "$3" = "" -o "$4" = "" -o "$5" = "" ]
  then
    # keine Anmeldeparameter
    # login leider nicht erlaubt
    c3surf_sstatus="Bitte die Anmeldung komplett ausfllen."
    c3surf_nstatus=7
    c3surf_cstatus="NULL-Parameter:"
  fi
fi

if [ $c3surf_nstatus -eq 0 ]
then
  c3surf_ip="$1"
  . /usr/local/bin/c3surf_getmac.sh
  #
  # id-check ggf. entfernen, wg. UserID
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    if [ -f $C3SURF_TMP_PATH/$c3surf_ip.time ]
    then
      # mache einen id check, wegen der POST-Daten
      {
        read c3surf_time c3surf_count c3surf_id c3surf_rest
      } < $C3SURF_TMP_PATH/$c3surf_ip.time
      if [ $2 -eq $c3surf_id ]
      then
        # das war nur ein doppelter POST -- schneller Ausstieg
        # ----------- vorsicht schmutziger Ausstieg ----------
        exit 2
        # ----------- vorsicht vorzeitiger Ausstieg ----------
      fi
    fi
  fi

  # Gesperrt vom Admin
  if [ -f $C3SURF_LOG_PATH/c3surf.lock ]
  then
    # login leider nicht erlaubt
    c3surf_sstatus="Zur Zeit ist keine Anmeldung erlaubt."
    c3surf_nstatus=7
    c3surf_cstatus="Admin-Lock:"
  else
    # weitere Prfungen
    # Prfe die MAC-Blacklist
    if [ "$c3surf_mac" = "" ]
    then
      # keine mac-Adressse gefunden (kann nur auftreten, wenn aus DHCP-Tabelle geprft wird und Rechner kein DHCP macht)
      c3surf_sstatus="Falsche Rechneradresse: DHCP benutzen."
      c3surf_nstatus=7
      c3surf_cstatus="MAC-Adresse:"
    else
      if [ -s $C3SURF_LOG_PATH/c3surf_mac.blacklist ]
      then
        # blacklist lesen und mac vergleichen
        {
          while read c3s_mac c3s_rest
          do
            if [ "$c3s_mac" = "$c3surf_mac" ]
            then
              # login leider nicht erlaubt
              c3surf_sstatus="Zur Zeit ist keine Anmeldung erlaubt."
              c3surf_nstatus=7
              c3surf_cstatus="MAC-Blacklist:"
              break
            fi
          done
        } < $C3SURF_LOG_PATH/c3surf_mac.blacklist
        # Ende Blacklist
      else
        if [ -f $C3SURF_TMP_PATH/$c3surf_ip.block ]
        then
          # login leider nicht erlaubt
          c3surf_sstatus="Zur Zeit ist keine Anmeldung erlaubt."
          c3surf_nstatus=7
          c3surf_cstatus="IP-Block:"
        else
          # Anmelde-Parameter-Check
          if [ "$3" = "" -o "$4" = "" -o "$5" = "" ]
          then
            # login leider nicht erlaubt
            c3surf_sstatus="Pflichtfelder: Vorname, Name und e-mail bitte eingeben."
            c3surf_nstatus=7
            c3surf_cstatus="Parameter:"
          fi
          # Ende Anmelde-Parameter
        fi
        # Ende ip-Block
      fi
      # Ende MAC-Blacklist
    fi
    # Ende MAC-Adresse leer
  fi
  # Admin-Lock
fi


# jetzt sagt der nstatus ob ok oder nicht
if [ $c3surf_nstatus -gt 0 ]
then
  # Fehler protokollieren, wenn gewnscht
  /usr/local/bin/c3surf_log_invalid.sh "$c3surf_mac" "$c3surf_cstatus$c3surf_sstatus" "$@"
else
  # login ist mglich
  c3surf_sstatus="Anmeldung erfolgreich"
  /usr/local/bin/c3surf_setiptime.sh "$@" "$c3surf_mac"
fi

# eine Rckmeldung an das Statusfenster
echo "$c3surf_sstatus" > $C3SURF_TMP_PATH/$1.status