#!/bin/sh
###################################################
# 3surf: get mac for the IP from ARP
# source this in your code
#
# vars (global):
#       in:  c3surf_ip
#       out: c3surf_mac
#
# Frank Saurbier, 2007, 3surf@arcor.de
#
# call it sourced . ./c3surf_getmac.sh
# but: it overrides all params, if it uses grep
###################################################

####################################
# alte Schleife ber /proc/net/arp (harmlos zu Parametern)
####################################
{
  read c3s_header
  while read c3s_ip c3s_hwtype c3s_flags c3s_mac c3s_mask c3s_device
  do
    if [ $c3s_arp_mac ]; then break; fi
    if [ "$c3s_ip" = "$c3surf_ip" ]
    then
      c3s_arp_mac="$c3s_mac"
    fi
  done
} < /proc/net/arp
c3surf_mac="$(echo "$c3s_arp_mac" | sed -e 'y/ABCDEF/abcdef/')"
# etwas aufrumen
unset c3s_header c3s_ip c3s_hwtype c3s_flags c3s_mac c3s_mask c3s_device c3s_arp_mac

# ###################################
# #####################################
# mit grep berschreibt alle Parameter
# #####################################
# set -f
# set -- `grep "$1" /proc/net/arp`
# set +f
# if [ $4 ] && [ $4 != "00:00:00:00:00:00" ]
# then
#  # capital letters to lower letters
#  c3surf_mac="$(echo "$4" | sed -e 'y/ABCDEF/abcdef/')"
# fi
# ######################################
