#!/bin/sh
# -----------------------------------------------------------------------------
# This file is part of opt_c3surf. For contact and licensing information, see
#   (fli4lroot)/config/c3surf.txt
# File version: $Id: c3surf_countdown.sh 01 2008-01-08 00:00:00Z fs $
# -----------------------------------------------------------------------------
. /var/run/c3surf.conf
#
# alle angemeldeten runterzhlen
for f in $C3SURF_TMP_PATH/*.time
do
  # schliee den Abfrage-String aus
  if [ ! "$f" = "$C3SURF_TMP_PATH/*.time" ]
  then
    {
      read fstime c3surf_rest
    } < $f
    fsnow=`date +%s`
    fstime=`/usr/bin/expr $fstime - $fsnow`
    if [ $fstime -le 0 ]
    then
      /usr/local/bin/c3surf_logout.sh `basename $f .time` "counter"
    fi
  fi
done
#
# die geblockten IPs noch prfen und ggf. wieder freigeben
for f in $C3SURF_TMP_PATH/*.block
do
  # schliee den Abfrage-String aus
  if [ ! "$f" = "$C3SURF_TMP_PATH/*.block" ]
  then
    {
      read fstime c3surf_rest
    } < $f
    fsnow=`date +%s`
    fstime=`/usr/bin/expr $fstime - $fsnow`
    if [ $fstime -le 0 ]
    then
      /usr/local/bin/c3surf_blockip.sh `basename $f .block` "remove"
    fi
  fi
done