#!/bin/sh
###################################################
# 3surf: block this IP for $C3SURF_BLOCKTIME minutes
# parameter: $1 = IP-address, $2 action (add, remove), $3 optional mac
#
# Frank Saurbier, 2007, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
###################################################
. /var/run/c3surf.conf
c3surf_ip="$1"
/usr/local/bin/c3surf_logout.sh "$c3surf_ip" "adm_blocking"
case $2 in
  add)
    fstime=`date +%s`
    fstime=`expr $fstime + $C3SURF_BLOCKSECS`
    echo "$fstime" "$3" > $C3SURF_TMP_PATH/$c3surf_ip.block
  ;;
  remove)
    rm -f $C3SURF_TMP_PATH/$c3surf_ip.block
  ;;
esac