#!/bin/sh
###################################################
# 3surf: block this IP for $C3SURF_BLOCKTIME minutes
# parameter: $1 = mac-address, $2 action (add, remove) 3 optional: Host_IP
#
# Frank Saurbier, 2007, 3surf@arcor.de
#
# mandatory: all files in /tmp/c3surf /var/run/c3surf
###################################################
. /var/run/c3surf.conf
case $2 in
  add)
    if [ "$3" = "" ]
    then
      echo "$1" "none" "none" "none" >> $C3SURF_LOG_PATH/c3surf_mac.blacklist
    else  
      if [ -f "$C3SURF_TMP_PATH/$3.time" ]
      then
        # hole die Daten des Surfers
        {
          read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
        } < $C3SURF_TMP_PATH/$3.time
        echo "$1" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" >> $C3SURF_LOG_PATH/c3surf_mac.blacklist
      else
        echo "$1" "none" "none" "none" >> $C3SURF_LOG_PATH/c3surf_mac.blacklist
      fi
    fi  
  ;;
  remove)
    sed "/$1/d" $C3SURF_LOG_PATH/c3surf_mac.blacklist > /tmp/c3surf_mac.blacklist.$$
    mv -f /tmp/c3surf_mac.blacklist.$$ $C3SURF_LOG_PATH/c3surf_mac.blacklist
  ;;
esac