#!/bin/sh
#################################################
# parameter: $1         ; $2
#            IP-Adresse ; time (minuten)
#
# /usr/local/bin/c3surf_addiptime.sh "$c3surf_ip" "$fstime"
#################################################
# geht nur bei bereits angemeldeten Benutzern
. /var/run/c3surf.conf
c3surf_ip="$1"
# zeit checken
if [ "$2" = "" ]
then
  fstime=$C3SURF_TIME
else
  fstime="$2"
fi
fstimesecs=`/usr/bin/expr $fstime \* 60`
# muss angemeldet sein
if [ -f $C3SURF_TMP_PATH/$c3surf_ip.time ]
then
  {
    read c3surf_time c3surf_count c3surf_id c3surf_mac c3surf_vorname c3surf_name c3surf_mail
  } < $C3SURF_TMP_PATH/$c3surf_ip.time
  c3surf_time=`/usr/bin/expr $c3surf_time + $fstimesecs`
  c3surf_count=`/usr/bin/expr $c3surf_count + 1`
  echo "$c3surf_time" "$c3surf_count" "$c3surf_id" "$c3surf_mac" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" > $C3SURF_TMP_PATH/$c3surf_ip.time
  /usr/local/bin/c3surf_log_login.sh "$c3surf_ip" "$c3surf_vorname" "$c3surf_name" "$c3surf_mail" $c3surf_mac "addtime:$fstime"
fi