#!/bin/sh
##-------------------------------------------------------------------------------
## c3Surf is Copyright (c)  2007 Frank Saurbier, fs, email: saurbier@arcor.de
##
## Creation:     16.04.2007  fs
## Last Update:  16.04.2007  fs
## Version:      2.0.0
## requires:
## history:      04.2008: c3surf erweitert um echtes login (fs)
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------
#
# eigenes interface, nicht fli4l Admin - macht alles noch ohne cgi-helper
# verwendet jetzt method "POST" kann aber auch mit "GET" genutzt werden
#########################################################################

# Package Vars
. /var/run/c3surf.conf

# POST Variablen holen, nur ohne LOGINUSR Option
if [ ! "$OPT_LOGINUSR" = "yes" ]
then
  eval "`proccgi $*`"
fi

# Infos an den Benutzer vor der Anmeldung geben?
if [ "$LOGINUSR_SHOW_INFO" = "no" ]
then
  echo "Location: http://$C3SURF_HTTPD_HOST_NAME/login/index.cgi?action=login&time=`date +%s`"
  echo
  exit
fi

# Vorsicht mit z.B. backticks, also umwandeln und nur Zeichen 'A-Za-z0-9@.' zulassen
if [ "$OPT_LOGINUSR" = "yes" ]
then
  # lese Daten der Anmeldung
  if [ -f $C3SURF_TMP_PATH/$REMOTE_ADDR.time ]
  then
    {
      read fstime fscount fsid fsmac fsvorname fsname fsmail
    } < $C3SURF_TMP_PATH/$REMOTE_ADDR.time
  fi
  # etwas aufrumen
  unset fstime fscount fsmac
else
  if [ "$REQUEST_METHOD" = "GET" ]
  then
    # Verarbeitung FORM_vorname, -name und mail
    # eigentlich obsolete, da method "POST" gewhlt ist - Aufruf ist aber mglich
    # index.cgi?action=unlock&fsvorname=<vorname>&fsname=<name>&fsmail=<mailadresse>
    if [ "$FORM_action" = "unlock" ]
    then
      fsvorname=$(echo "$FORM_fsvorname" | tr -d '\n' | tr -c '[:alnum:]' '_')
      fsname=$(echo "$FORM_fsname" | tr -d '\n' | tr -c '[:alnum:]' '_')
      fsmail=$(echo "$FORM_fsmail" | tr -d '\n' | tr -c '@.[:alnum:]' '_')
      fsid=$$
    fi
  else
    eval $(echo "$FORM_action" | tr -d '\r' | tr '\n' ';' | tr -c '@.=;[:alnum:]' '_')
  fi
fi

# page logging
if [ "$C3SURF_DOLOG_PAGE" = "yes" ]
then
  /usr/local/bin/c3surf_log_page.sh "$REMOTE_ADDR" "$HTTP_USER_AGENT" "$fsid" "$fsvorname" "$fsname" "$fsmail"
fi

# Action: login
if [ "$REQUEST_METHOD" = "GET" ]
then
  if [ "$FORM_action" = "unlock" ]
  then
    /usr/local/bin/c3surf_login.sh "$REMOTE_ADDR" "$fsid" "$fsvorname" "$fsname" "$fsmail"
  fi
else
  # das war ein POST also action bitte
  if [ "$OPT_LOGINUSR" = "yes" ]
  then
    echo "Location: http://$C3SURF_HTTPD_HOST_NAME/login/index.cgi?action=login&time=`date +%s`"
    echo
  else
    /usr/local/bin/c3surf_login.sh "$REMOTE_ADDR" "$fsid" "$fsvorname" "$fsname" "$fsmail"
  fi
fi


# ###
# html START
# ###

# ###
# Anfang generieren
# ###
cat <<-EOF
    Content-Type: text/html; charset=iso-8859-1
    Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate, no-store
    Pragma: no-cache
EOF
# ###
echo "Expires: `date -Ru`"
echo
# ###
# Meta Daten
# ###
cat <<-EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
  <meta http-equiv="expires" content="0">
EOF

# ###
# passe an den richtigen Host an
# ###
if [ "$REQUEST_METHOD" = "POST" ]
then
  echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"3;url=http://$C3SURF_HTTPD_HOST_NAME/\">"
else
  if [ ! "$HTTP_HOST" = "$C3SURF_HTTPD_HOST_NAME" ]
  then
    echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"0;url=http://$C3SURF_HTTPD_HOST_NAME/\">"
  else
    if [ "$FORM_action" = "unlock" ]
    then
      echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"3;url=http://$C3SURF_HTTPD_HOST_NAME/\">"
    fi
  fi
fi

# ###
cat <<-EOF
  <meta name="description" content="Online mit fli4l">
  <meta name="author" content="Frank Saurbier">
  <meta name="robots" content="noindex">
	<title>Free Surf</title>
</head>
EOF
# ###
# Tabelle mit Beschreibung
# ###
cat <<-EOF
<body background="/pic/backfs03.jpg" text="#000000" bgcolor="#F0F0F0" link="#0000FF" vlink="#800000" alink="#FF0000">
<div align="center"><font size="+2">F&nbsp;r&nbsp;e&nbsp;e&nbsp;&nbsp;<font color="#408080">&nbsp;S&nbsp;u&nbsp;r&nbsp;f</font></font></div>
<hr noshade size="1">
<center><table border=0>
<colgroup>
  <col width="75">
  <col width="50">
  <col width="600">
  <col width="75">
</colgroup>
<tr>
<!--Inhalt einer Zelle, die sich ber 4 Zeilen erstreckt //-->
<td valign="top" rowspan="4">
</td>
<td valign="middle" align="center">
</td>
<td>
<font color="#408080" size=+2>Willkommen</font> in meinem Netzwerk. Bitte melde Dich an.<br>
</td>
<td valign="bottom" rowspan="4">
<img src="/pic/wormpeeking.gif" border="0" alt="">
</td>
</tr>
<!--2.Zeile-->
<tr>
<td valign="middle" align="center">
</td>
<td>
Die folgenden Bedingungen akzeptierst Du mit jeder Anmeldung...
</td>
</tr>
<!--3.Zeile-->
<tr>
<td valign="middle" align="center">
</td>
<td>
<font color="#408080">
<li>Du nutzt diesen Service auf eigenes Risiko.</li>
<li>Du hast keinen Anspruch auf diesen Service.</li>
<li>Du h&auml;lst Dich an geltendes Recht und nutzt diesen Service nicht zum Versto&szlig; gegen Gesetze.</li>
<li>Du versuchst nicht andere Benutzer oder Rechner in diesem Netz auszuspionieren.</li>
<li>Du meldest Dich mit vollst&auml;ndigen und korrekten Daten f&uuml;r den Service an.</li>
</font>
</td>
</tr>
<!--4.Zeile-->
<tr>
<td valign="middle" align="center">
</td>
<td>
EOF
# ###
echo "Mit jeder Anmeldung erh&auml;lst Du $C3SURF_TIME Minuten Zugang zum Internet. Die Zeit bekommst Du hier angezeigt."
# ###
cat <<-EOF
</td>
</tr>
</table></center>
EOF
# #####
# Anmeldeformular mit action
# #####
cat <<-EOF
<hr noshade size="1">
<!--Formular-->
<center>
<form action="/index.cgi" method="post" enctype="text/plain">
EOF
# ###
echo "<input type=\"hidden\" name=\"action\" value=\"fsid=$$\">"
# ###
cat <<-EOF
<table border=0>
<colgroup>
  <col width="125">
  <col width="550">
  <col width="125">
</colgroup>
<!--1.Zeile-->
<tr>
<td align="center" rowspan="3">
<font color="#408080" size=+1>
D&nbsp;e&nbsp;i&nbsp;n&nbsp;e
<br>
A&nbsp;n&nbsp;m&nbsp;e&nbsp;l&nbsp;d&nbsp;u&nbsp;n&nbsp;g</font>
</td>
EOF
# ###
if [ "$OPT_LOGINUSR" = "yes" ]
then
  echo "<td rowspan=\"3\" align=center>"
	if [ -n "$fsid" ]
	then
    echo "Angemeldet als,<br><font color=\"#408080\" size=+1>'$fsid'</font>.<br> Bitte abmelden, falls es nicht stimmt."
	else
    echo "F&uuml;r die Anmeldung bitte 'Anmelden' anklicken."
	fi
  echo "</td>"
else
# ###
cat <<-EOF
<td rowspan="3" align=center>
<table border=0>
<tr>
  <td align=right>Vorname:</td>
  <td><tt><input type=text size=50 name="fsvorname" maxlength="50"></tt></td>
</tr>
<tr>
  <td align=right>Name:</td>
  <td><tt><input type=text size=50 name="fsname" maxlength="50"></tt></td>
</tr>
<tr>
  <td align=right>email-Adresse:</td>
  <td><tt><input type=text size=50 name="fsmail" maxlength="50"></tt></td>
</tr>
</table>
</td>
EOF
# ###
fi
# ###
cat <<-EOF
<!--1.Zeile Haupttabelle-->
<td rowspan="3" align=center>
  <input type=submit value="Anmelden">
  </form>
EOF
	if [ "$OPT_LOGINUSR" = "yes" -a -n "$fsid" ]
	then
	  echo "<form action=\"/logout.cgi\">"
    echo "<input type=submit value=\"Abmelden\">"
	  echo "</form>"
	fi
cat <<-EOF
</td>
</tr>
</table></center>
EOF
# ###
# echo "</form>"
# ###
cat <<-EOF
<hr noshade size="1">
<!--Status-->
<iframe src="/c3surf_status.cgi" width="100%" height="70" align="center" name="Status">
<p>Dein Browser kann leider keine eingebetteten Frames anzeigen, daher benutze bitte diese Referenz:
<a href="/c3surf_status.cgi">Status</a></p>
</iframe>
EOF
# ###
# der html footer
# ###
cat <<-EOF
<!--html footer-->
<hr noshade size="1">
<div align="center"><nobr>
Letzte &Auml;nderung am 26.05.2008 (fs)
</nobr></div>
</body>
</html>