#!/bin/sh
##-------------------------------------------------------------------------------
## 3Surf is Copyright (c)  2007 Frank Saurbier, fs, email: saurbier@arcor.de
##
## Creation:     16.04.2007  fs
## Last Update:  17.04.2008  fs
## Version: 	   2.0.0
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------
# first of all
# parse variables
eval "`proccgi $*`"
# variables: $FORM_<name>
nstatus=0
myrefresh=60
. /var/run/c3surf.conf
if [ "$FORM_action" = "logout" ]
then
  /usr/local/bin/c3surf_logout.sh "$REMOTE_ADDR" "logout"
  #
	# Ld Hauptseite neu - Meldung: "Du hast Dich abgemeldet".
	# Fr Logout LOGINUSR erforderlich
	#
  nstatus=7
  isstatus="Du hast Dich abgemeldet."
  myrefresh=5
  echo "Location: /c3surf_status.cgi"
  echo
  exit
fi

####
# Status bestimmen
####
if [ "$nstatus" = "0" ]
then
  if test -s $C3SURF_TMP_PATH/$REMOTE_ADDR.status
  then
    isstatus=`cat $C3SURF_TMP_PATH/$REMOTE_ADDR.status`
    nstatus=7
    rm -f $C3SURF_TMP_PATH/$REMOTE_ADDR.status
    myrefresh=3
  elif test -s $C3SURF_TMP_PATH/$REMOTE_ADDR.time
  then
    {
      read c3surf_time c3surf_rest
    } < $C3SURF_TMP_PATH/$REMOTE_ADDR.time
    nstatus=1
    c3surf_now=`date +%s`
    c3surf_time=`/usr/bin/expr $c3surf_time - $c3surf_now`
    c3surf_time=`/usr/bin/expr $c3surf_time / 60`
    if [ "$c3surf_time" -le "1" ]
    then
      isstatus="Du surfst nur noch Sekunden!"
    else
      isstatus="Du surfst noch $c3surf_time Minuten"
    fi
  elif test -f $C3SURF_LOG_PATH/c3surf.lock
  then
    isstatus=`cat $C3SURF_LOG_PATH/c3surf.lock`
    nstatus=9
  else
    isstatus="Du bist nicht angemeldet"
    nstatus=2
  fi
fi
# ####
# html
# ####
cat <<-EOF
    Content-Type: text/html; charset=iso-8859-1
    Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate, no-store
    Pragma: no-cache
EOF
####
#echo "Expires: `date -Ru`"
echo "Expires: 0"
echo
####
cat <<-EOF
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
    <html>
    <head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <meta http-equiv="expires" content="0">
EOF
# refresh setzen
echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$myrefresh;url=/c3surf_status.cgi\">"
####
cat <<-EOF
    <meta name="description" content="Dein Online Status">
    <meta name="author" content="Frank Saurbier">
    <meta name="robots" content="noindex">
    <title>FreeSurf and LoginUsr Status</title>
    </head>
EOF
#####
cat <<-EOF
    <body text="#000000" bgcolor="#E0E0E0" link="#0000FF" vlink="#800000" alink="#FF0000">
    <center>
    <form action="/c3surf_status.cgi" method="get" enctype="text/plain">
    <table border=0>
    <colgroup>
    <col width="125">
    <col width="550">
    <col width="125">
    </colgroup>
    <tr>
    <td align="center">
    <font color="#408080" size=+1>
    S&nbsp;t&nbsp;a&nbsp;t&nbsp;u&nbsp;s
    </font>
    </td>
    <td align=center>
    <font size=+1>
EOF
####
# Status ausgeben
####
echo "$isstatus"
#
cat <<-EOF
    </font>
    <input type="hidden" name="action" value="logout">
    </td>
    <td align=center>
EOF
#
## jetzt noch den Abmeldeknopf zeigen oder nicht
#
case $nstatus in
  1)
    if [ "$OPT_LOGINUSR" = "yes" ]
    then
      echo "Online"
    else
      echo "<input type=\"submit\" value=\"Abmelden\">"
    fi
  ;;
  2) echo "Anmelden" ;;
  7) echo "Info" ;;
  8) echo "Fehler" ;;
  9) echo "Sperre" ;;
  *) echo "&there4;"
esac
# Ende
cat <<-EOF
</td>
</tr>
</table></center>
</form>
</body>
</html>