# incoming.pl
# 
# example for using the perl SimpleCapi interface with Perl
# 
# Part of the caiviar package. 
# 
# Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>
# 
# This file is distributed under the GPL, see file COPYING for details.

push @INC, "../../client/";
require SimpleCapi;

$capi = SimpleCapi::new("127.0.0.1",7347);
$capi->acceptCalls();

$running = 1;
print "Waiting for incoming calls...\n";

# Phase 1: wait for a call
while(1)
{
    $event = $capi->listen(1);
    next if($event->{type} == $capi->{CAPI_EVENT_TIMEOUT});

    $capi->printEvent($event);

    if($event->{type} == $capi->{CAPI_EVENT_INCOMING})
    {
	print "answering call from $event->{msisdn}...\n";
	last if ($capi->answer(%event));
    }
}

# Phase 2: play a message
$capi->play("welcome.wav");
while(1)
{
    $event = $capi->listen(1);
    next if($event->{type} == $capi->{CAPI_EVENT_TIMEOUT});

    last if($event->{type} == $capi->{CAPI_EVENT_DONE});
    last if($event->{type} == $capi->{CAPI_EVENT_HANGUP});

}

$capi->close();
