# connect.pl
# 
# example for using the perl SimpleCapi interface with Perl
# 
# Part of the caiviar package. 
# 
# Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>
# 
# This file is distributed under the GPL, see file COPYING for details.

push @INC, "../../client/";
require SimpleCapi;

$capi1 = SimpleCapi::new("127.0.0.1",7347);
$capi2 = SimpleCapi::new("127.0.0.1",7347);

$call1 = $capi1->call_nonblock("123456789");
$call2 = $capi2->call_nonblock("987654321");

while(!$done1 || !$done2)
{
    if(!$done1) {
	$event1 = $capi1->listen(1);
	$done1=1 if($event1->{type} == $capi1->{CAPI_EVENT_CONNECTED});
	goto end if ($event1->{type} == $capi1->{CAPI_EVENT_HANGUP});
    }

    if(!$done2) {
	$event2 = $capi2->listen(1);
	$done2=1 if($event2->{type} == $capi2->{CAPI_EVENT_CONNECTED});
	goto end if ($event2->{type} == $capi2->{CAPI_EVENT_HANGUP});
    }
}

print "Both numbers dialed. Connecting...\n";

print "line 1:".$capi1->{line}."\n";
print "line 2:".$capi2->{line}."\n";
$capi1->connect($capi2);

while(1) {
    $event1 = $capi1->listen(1);
    last if ($event1->{type} == $capi1->{CAPI_EVENT_HANGUP});
    $event2 = $capi2->listen(1);
    last if ($event2->{type} == $capi2->{CAPI_EVENT_HANGUP});
}

end:
$capi1->close();
$capi2->close();
