/* incoming.cpp

some demonstration routines for the SimpleCapi interface.

Part of the caiviar package. 

Copyright (c) 2002 MobileX AG, http://www.mobilexag.de
Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>

This file is distributed under the GPL, see file COPYING for details. */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <SimpleCapi.h>

int main(int argn, char*argv[]) 
{
    Logger * log = new Logger(5);
    SimpleCapi capi(log);

    int line=capi.open ("33");
    if (line<0) {
	printf("no free line\n");
	return 1;
    }
    capi.acceptCalls (line);

    int offline = 1;
    while(offline) {
	ISDNEvent event = capi.listen(line, 0);
	if(event.type == CAPI_EVENT_INCOMING) {
	    char*s = strdup(event.msisdn);
	    if(capi.answer (line, &event))
		offline = 0;
	    else
		printf("answering to msisdn %s didn't work out\n",s);
	    free(s);
	}
    }

    int playjob = capi.play (line, "welcome.wav");
    int done = 0;
    int playing=1;
    
    while (!done) {
	ISDNEvent event = capi.listen(line, 0);
	switch (event.type) {
	case CAPI_EVENT_HANGUP:
	    printf("hung up\n");
	    return 0;

	case CAPI_EVENT_DONE:
	    if (event.jobid == playjob)
		playing = 0;
	    break;

	case CAPI_EVENT_DIALTONE:
	    if (playing) { /* barge in */
		capi.stop(line, playjob);
		playing = 0;
	    }
	    if(event.tone == '*') {
		done =1;
	    }
	    break;
	default:
	    printf("Unexpected: %s\n", capi.eventToString (&event));
	    break;
	}
    }
    capi.hangup(line);
    capi.close(line);
    return 0;
}
