//----------------------------------------------------------------------------
// Creation:    29.07.2007 12:36
// Author:      Roland Spitzer
//
// Programm:    dlogger.c
//
// Last Update: 14.08.2007 20:08
//
// Kleines Programm, dass ein Verzeichnis berwacht und auf nderungen an Files 
// reagiert. Alle nderungen werden mit Datum und Uhrzeit ausgegeben.
// Die Ausgabe wird in ein Log geschrieben und kann dann mittels
// Logfile-Adapter ausgewertet werden.
//
//----------------------------------------------------------------------------


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <fcntl.h>
#include <signal.h>
#include <fcntl.h>
#include <time.h>

#define MAX_PATH 256

//----------------------------------------------------------------------------
//  public definitions
//----------------------------------------------------------------------------

char     program [MAX_PATH];
char     path [MAX_PATH];
char     logfile [MAX_PATH];

struct file_info
{
    int       kz;                      /* Kennzeichen */ 

    long      d_ino;                   /* Inode */
    char      d_name [NAME_MAX];       /* Dateiname */

    ushort    st_mode;                 /* File-Mode und -Typ */
    off_t     st_size;    	       /* log. Groesse des Files in Bytes */ 
    time_t    st_atime;                /* letzter Zeitpunkt des Lesens */ 
    time_t    st_mtime;                /* letzter Modifikations-Zeitpunkt des Files */ 
    time_t    st_ctime;                /* letzter Modifikations-Zeitpkt. der Struktur */

    struct    file_info *next;
};      

struct   file_info *kette = NULL;

static volatile int  event_fd;
static volatile int  event_sig;
static volatile void *event_data;

FILE     *pidfp, *logfp;
char     st      [256];
char     time_st [80];

//----------------------------------------------------------------------------
//  functions
//----------------------------------------------------------------------------

static void signal_directory   (int sig, siginfo_t *si, void *data);
void        signal_process     (int sig);
int         dir_lesen          (int start);
int         anhaengen          (char d_name [NAME_MAX], long d_ino);
int         sortiert_anhaengen (char d_name [NAME_MAX], long d_ino);
void        loesche            (char d_name [NAME_MAX]);
int         fuellen            (char d_name [NAME_MAX], long d_ino, struct file_info *);
int         file_stat          (char d_name [NAME_MAX], struct stat *);
void        time_string        (void);
void        log_print          (void);

//****************************************************************************
//  dir
//****************************************************************************

int main (int argc, char **argv)
{
    struct    sigaction sig_struct ;
    int       fd;

    if   (argc != 3)
         {
         fprintf(stderr,"Benutzung : %s Directory Logfile\n", argv[0]);
         return EXIT_FAILURE;
         }

    strcpy (program, argv[0]);
    strcpy (path, argv[1]);
    strcpy (logfile, argv[2]);

//----------------------------------------------------------------------------
//  start as daemon
//
//  fork creates a copy of the parent-process
//  fork () == 0 child-process, write pid in pid-file and close parent-process
//               with exit(0)
//----------------------------------------------------------------------------

    if   (fork () == 0)
         {
         setsid ();
         pidfp = fopen ("/var/run/dlogger.pid","w");
         if   (pidfp)
              {
              fprintf(pidfp, "%d\n", getpid ());
              fclose(pidfp);
              }
         }
    else
         return EXIT_SUCCESS;

//----------------------------------------------------------------------------
//  open logfile        
//----------------------------------------------------------------------------        

    logfp = fopen (logfile, "w");
    if   (!logfp)
         {
         fprintf(stderr, "%s unable to open logfile %s\n", program, logfile);
         return EXIT_FAILURE;
         }
    setvbuf(logfp, NULL, _IOLBF, 80);
//    setvbuf(logfp, NULL, _IONBF, BUFSIZ); keine Pufferung
   
//----------------------------------------------------------------------------
//  signal handling SIGTERM, SIGHUP und notify directory changes
//----------------------------------------------------------------------------

    sig_struct.sa_handler = signal_process;
    sigemptyset(&sig_struct.sa_mask);
    sig_struct.sa_flags = 0;
    
    if (sigaction(SIGTERM, &sig_struct, NULL) != 0)
       {
       fprintf(stderr, "%s error signal processing SIGTERM\n", program);
       return EXIT_FAILURE;
       }
    if (sigaction(SIGHUP, &sig_struct, NULL) != 0)
       {
       fprintf(stderr, "%s error signal processing SIGHUP\n", program);
       return EXIT_FAILURE;
       }

    sig_struct.sa_sigaction = signal_directory;
    sigemptyset(&sig_struct.sa_mask);
    sig_struct.sa_flags = SA_SIGINFO;

    if (sigaction(SIGRTMIN + 1, &sig_struct, NULL) != 0)
       {
       fprintf(stderr, "%s error signal processing SIGRTMIN + 1\n", program);
       return EXIT_FAILURE;
       }

//----------------------------------------------------------------------------
//  we will now be notified if any of the files in "." are created/modified
//----------------------------------------------------------------------------

    dir_lesen(0);

    fd = open(path, O_RDONLY);
    fcntl(fd, F_SETSIG, SIGRTMIN + 1);
//    fcntl(fd, F_NOTIFY, DN_ACCESS|DN_MODIFY|DN_CREATE|DN_RENAME|DN_DELETE|DN_ATTRIB|DN_MULTISHOT);
    fcntl(fd, F_NOTIFY, DN_MODIFY|DN_CREATE|DN_RENAME|DN_DELETE|DN_MULTISHOT);

    fclose(stdin);
    fclose(stdout);
    fclose(stderr);
    stderr = NULL;

    sprintf(st, "waiting for changes in directory %s\n", path);
    log_print();

    while (1)
         {
         pause();
         dir_lesen(1);
         }

    return EXIT_SUCCESS;
}

//****************************************************************************
//  directory signal handling
//****************************************************************************

static void signal_directory(int sig, siginfo_t *si, void *data)
{

    event_fd = si->si_fd;
    event_sig = sig;
    event_data = data;
}

//****************************************************************************
//  signal proces handling
//****************************************************************************

void  signal_process (int sig)
{
    char    logold  [256];
    
    if   (sig == SIGTERM)
         {
         sprintf(st, "get signal %d (SIGTERM) and stop\n", sig);
         log_print();
     
         fclose(logfp);
        
         exit(0);
         }

    if   (sig == SIGHUP)
         {
         sprintf(st, "get signal %d (SIGHUP)\n", sig);
         log_print();

         fclose(logfp);
         
         time_string();
         sprintf(logold, "%s.%s", logfile, time_st); 
         rename(logfile, logold);
         
         logfp = fopen (logfile, "w"); 
         }

    return;
}

//****************************************************************************
//  directory
//****************************************************************************

int dir_lesen (int kz_start)
{
    DIR       *dir;
    struct    dirent *dirzeiger;
    struct    stat attribut;
    struct    file_info *zeiger, *zeiger1, zeiger2;

    if   ((dir = opendir(path)) == NULL)
         {
         sprintf(st, "Fehler bei opendir ... %s\n", path);
         log_print();
         return EXIT_FAILURE;
         }
    
    while((dirzeiger = readdir(dir)) != NULL)
         {      
         if   (file_stat((*dirzeiger).d_name, &attribut) == EXIT_FAILURE)
              continue;
         if   (attribut.st_mode & S_IFDIR)
              continue;
              
         zeiger = kette;
         while(zeiger != NULL && zeiger->d_ino != (*dirzeiger).d_ino) zeiger=zeiger->next;
         if   (zeiger == NULL)
              {
              sortiert_anhaengen((*dirzeiger).d_name, (*dirzeiger).d_ino);
              if   (kz_start == 1)
                   {
                   sprintf(st, "%s new\n", (*dirzeiger).d_name);
                   log_print();
                   }
              }
         else
              {
              zeiger->kz = 1;
              if   (strcmp(zeiger->d_name, (*dirzeiger).d_name) != 0)
                   {
                   sprintf(st, "%s name changed old=%s\n", (*dirzeiger).d_name, zeiger->d_name);
                   log_print();
                   }
              fuellen((*dirzeiger).d_name, (*dirzeiger).d_ino, &zeiger2);             
              if   (zeiger->st_mode != zeiger2.st_mode)
                   {
                   sprintf(st, "%s mode changed\n", (*dirzeiger).d_name);
                   log_print();
                   }
              if   (zeiger->st_size != zeiger2.st_size)
                   {
                   sprintf(st, "%s size changed\n", (*dirzeiger).d_name);
                   log_print();
                   }
              if   (zeiger->st_atime != zeiger2.st_atime)
                   {
                   sprintf(st, "%s read\n", (*dirzeiger).d_name);
                   log_print();
                   }
              if   (zeiger->st_mtime != zeiger2.st_mtime)
                   {
                   sprintf(st, "%s changed\n", (*dirzeiger).d_name);
                   log_print();
                   }
              if   (zeiger->st_ctime != zeiger2.st_ctime)
                   {
                   sprintf(st, "%s inode changed\n", (*dirzeiger).d_name);
                   log_print();
                   }
              fuellen((*dirzeiger).d_name, (*dirzeiger).d_ino, zeiger);
              }
         }
    
    zeiger  = kette;
    while(zeiger != NULL)
         {
         if   (zeiger->kz == 1)
              {
              zeiger->kz = 0;
              zeiger=zeiger->next;
              }
         else
              {
              sprintf(st, "%s deleted\n", zeiger->d_name);
              log_print();
              zeiger1=zeiger->next;
              loesche(zeiger->d_name);
              zeiger=zeiger1;
              }
         }              

    if   (closedir(dir) == -1)
         {
         sprintf(st, "Fehler bei closedir ... %s\n", path);
         log_print();
         }
         
    return EXIT_SUCCESS;
}

//****************************************************************************
//  liste anhaengen
//****************************************************************************

int anhaengen (char d_name [], long d_ino)
{
    struct    file_info *zeiger;

    if   (kette == NULL)
         {
         if   ((kette = (struct file_info *) malloc(sizeof(struct file_info))) == NULL)
              {
              sprintf(st, "Kein Speicherplatz vorhanden ...\n");
              log_print();
              return EXIT_FAILURE;
              }
         fuellen(d_name, d_ino, kette);
         kette->next = NULL;
         }
    else
         {
         zeiger = kette;
         while(zeiger->next != NULL) zeiger=zeiger->next;
         if   ((zeiger->next =(struct file_info *) malloc(sizeof(struct file_info))) == NULL)
              {
              sprintf(st, "Kein Speicherplatz vorhanden ...\n");
              log_print();
              return EXIT_FAILURE;
              }
         zeiger=zeiger->next;
         fuellen(d_name, d_ino, zeiger);
         zeiger->next = NULL;
         }
 
    return EXIT_SUCCESS;
}  

//****************************************************************************
//  liste sortiert anhaengen
//****************************************************************************

int sortiert_anhaengen (char d_name [], long d_ino)
{
    struct    file_info *zeiger, *zeiger1;	

    if   (kette == NULL)
         anhaengen(d_name, d_ino);
    else
         {
         zeiger = kette;
         while(zeiger != NULL && (strcmp(zeiger->d_name, d_name) < 0)) zeiger=zeiger->next;
      
         if   (zeiger == NULL)
              anhaengen(d_name, d_ino);
         else
              {
              if   (zeiger == kette)
                   {
                   if   ((kette = (struct file_info *) malloc(sizeof(struct file_info))) == NULL)
                        {
                        sprintf(st, "Kein Speicherplatz vorhanden ...\n");
                        log_print();
                        return EXIT_FAILURE;
                        }
                   fuellen(d_name, d_ino, kette);                   
                   kette->next = zeiger;
                   } 
              else
                   {
                   zeiger1 = kette;
                   while(zeiger1->next != zeiger) zeiger1=zeiger1->next;
                   if   ((zeiger =(struct file_info *) malloc(sizeof(struct file_info))) == NULL)
                        {
                        sprintf(st, "Kein Speicherplatz vorhanden ...\n");
                        log_print();
                        return EXIT_FAILURE;
                        }
                   fuellen(d_name, d_ino, zeiger);
                   zeiger->next=zeiger1->next;
                   zeiger1->next=zeiger;
                   }
              }
         }

    return EXIT_SUCCESS;
}

//****************************************************************************
//  element aus liste lschen
//****************************************************************************

void loesche (char d_name [NAME_MAX])
{
    struct    file_info *zeiger, *zeiger1;

    if   (kette == NULL)
         return;

    if   (strcmp(kette->d_name, d_name) == 0)
         {
         zeiger=kette->next;
         free(kette);
         kette=zeiger;
         }
    else
         {
         zeiger = kette;
         while(zeiger->next != NULL)
              {
              zeiger1=zeiger->next;
              if   (strcmp(zeiger1->d_name, d_name) == 0)
                   {
                   zeiger->next=zeiger1->next;
                   free(zeiger1);
                   break;
                   }
              zeiger=zeiger1;
              }
         }

    return;
}

//****************************************************************************
//  element der liste fllen
//****************************************************************************

int fuellen (char d_name [NAME_MAX], long d_ino, struct file_info *zeiger)
{
    struct    stat attribut;

    file_stat (d_name, &attribut);    

    zeiger->kz = 1; 
    strcpy(zeiger->d_name, d_name);
    zeiger->d_ino = d_ino;
    zeiger->st_mode = attribut.st_mode;
    zeiger->st_size = attribut.st_size;
    zeiger->st_atime = attribut.st_atime;
    zeiger->st_mtime = attribut.st_mtime;
    zeiger->st_ctime = attribut.st_ctime;
    
    return EXIT_SUCCESS;
}

//****************************************************************************
//  read file status
//****************************************************************************

int file_stat (char d_name [NAME_MAX], struct stat *attribut)
{
    char      file [MAX_PATH];
    
    memset(file, 0x0, MAX_PATH);
    strcpy(file, path);
    strcat(file, "/");
    strcat(file, d_name);
    
    if   (strcmp(file, logfile) == 0)
         return EXIT_FAILURE;
         
    if   (stat(file, attribut) == 1)
         {
         sprintf(st, "Fehler bei Dateistatus ...\n");
         log_print();
         return EXIT_FAILURE;
         }
    
    return EXIT_SUCCESS;
}

//****************************************************************************
//  make time
//****************************************************************************

void time_string ()
{
    time_t    now;
    struct    tm *zgr;

    time(&now);
    zgr = localtime(&now);
    strftime(time_st, 80, "%d.%m.%y-%X", zgr);

    return;
}

//****************************************************************************
//  write logfile
//****************************************************************************

void log_print ()
{
    time_string();
    
    fprintf(logfp, "%s %s %s", program, time_st, st);
    fflush(logfp);

    return;
}

//-------------------------------- Ende --------------------------------------
