/* 
 * EZconsole.c - UDP control program for EZcontrol T-10 
 *
 * Copyright (c) 2005 Rose + Herleth GbR. All rights reserved.
 *
 * http://www.ezcontrol.de
 *
 * Conditions of Use:
 * For free use in commercial and non-commercial software but only
 * to communicate with Rose+Herleth GbR EZcontrol devices.
 * Use in firmware of third-party hardware only with written approval
 * of Rose+Herleth GbR.
 *
 * Nutzungsbedingungen:
 * Zur freien Verwendung in kommerzieller und nicht-kommerzieller Software
 * jedoch nur zur Kommunikation mit EZcontrol Geraeten der Firma Rose+Herleth GbR.
 * Nutzung in der Firmware der Hardware von Fremdherstellern bedarf der schriftlichen
 * Genehmigung der Rose+Herleth GbR.
 * 
 * 10jan05 1.02  - Initial Release 
 * 21feb05 1.10  - added: parameter t for FS20 timer programming 
 *                        parameter -r to send datagrams n times
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/ip.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>              // for gethostbyname
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/select.h>

#define ERROR  -1
#define TRUE    1

#define SEND_PORT 7042

#define SET_PRESET       0xab01 
#define XMIT_COMMAND     0xab02

#define u16_t unsigned short int
#define u8_t unsigned char

#define MANUAL_MODE 1
#define PRESET_MODE 2

#define VERSION "1.10"


u16_t chksum(u16_t *data, u16_t len)
{
  u16_t sum;
  
  for(sum = 0; len > 1; len -= 2) {
    sum += *data;
    if(sum < *data) {
      ++sum;
    }
    ++data;
  }
  if(len == 1) {
    sum += htons(((u16_t)(*(u8_t *)data)) << 8);
    if(sum < htons(((u16_t)(*(u8_t *)data)) << 8)) {
      ++sum;
    }
  }

  return sum;
}

  typedef struct
  {
    u16_t crc;
    u16_t type;
    u16_t errortype;
  } frame_error;

  typedef struct
  {
    u16_t crc;
    u16_t type;
    u16_t switchno;
    u16_t value;
  } frame_use_preset;

  typedef struct
  {
  u16_t crc;  
  u16_t type;   
  
  u16_t system;     //u8_t         
  u16_t hc;
  u16_t hc2;
  u16_t address;
  u16_t value;
  u16_t arg;
  u16_t repeat;
  } frame_xmit_command;


void show_help()
{
    printf("EZcontrol command line tool %s\n", VERSION);
    printf("\nusage:\n");
    printf("ezcontrol --help     display help (this)\n\n");
    printf("preset mode:\n");
    printf("ezcontrol IP -p s v\n");
    printf("     s     number of switch \n");
    printf("     v     value to send \n\n");
    printf("manual mode:\n");
    printf("ezcontrol IP -m s h h2 a v [t] [-r n]\n");
    printf("     s     system: 1=FS10, 2=FS20, ...\n");
    printf("     h     house code\n");
    printf("     h2    house code 2\n");
    printf("     a     adress\n");
    printf("     v     value/cmd: 0=off...255=on\n");
    printf("     t     argument (optional)\n");
    printf("     -r n  send datagram n times (optional)\n\n");
   
}



int main(int argc, char *argv[])
{



  static int so_reuseaddr = TRUE;
  char buffer[1500];
  struct sockaddr_in udp_addr_in;
  struct sockaddr_in dest;
  int dest_size=sizeof(struct sockaddr_in);
  int udp_sd, len, n;
  int state=0;
  unsigned int repeat=0;
  int i,j;
  struct hostent *hp;
  char *inet_ntoa();
  struct timeval timeout;
  fd_set rd_set;

  if(!((argc==5)||((argc>=8)&&(argc<=11)))) {
    show_help();
    exit(ERROR);
  }

  for(i=0; i<argc; i++)
  {
    if (strcmp(argv[i], "-r")==0) {
      repeat=atoi(argv[i+1]);
      i++;
      if(repeat==0) repeat++; // wenn angegeben dann bitte auch mind. 1
    }
  }
    
  for(i=0; i<argc; i++)
  {
    if (strcmp(argv[i], "-m")==0) {
      j=i+1;
      state=MANUAL_MODE;
      if (repeat!=0) {
        if((argc<10)||(argc>11)) {
	  printf("manual mode... wrong parameter count\n");
	  show_help();
          exit(ERROR);
	}
      }
      else {
        if((argc<8)||(argc>9)) {
	  printf("manual mode... wrong parameter count\n");
	  show_help();
	  exit(ERROR);
	}
      }

    }
    if (strcmp(argv[i], "-p")==0) {
      j=i+1;
      state=PRESET_MODE;
      if(argc!=5) {
        printf("preset mode... wrong parameter count\n");
	show_help();
        exit(ERROR);
      }
    }
  }
  
  if(state==0) {
    printf("please use paramter -p or -m\n");
    show_help();
    exit(ERROR);
  }


  if (!(hp = gethostbyname(argv[1]))) {
    fprintf(stderr, "unknown host %s\n", argv[1]);
    show_help();
    exit(ERROR);
  }
  





  udp_sd=socket(AF_INET, SOCK_DGRAM, 0);
  if (udp_sd<0) {
    printf("can't create udp socket\n");
    exit(ERROR);
  }

  timeout.tv_sec = 3;
  timeout.tv_usec = 0;

  FD_ZERO(&rd_set);
  FD_SET(udp_sd, &rd_set);


  dest.sin_family=AF_INET;
  dest.sin_addr=*(struct in_addr *) hp->h_addr_list[0];
  dest.sin_port=htons(SEND_PORT);
  printf("addr: %s \n", inet_ntoa(*(struct in_addr *) * hp->h_addr_list));
  
  switch(state) {

    case PRESET_MODE: {

      frame_use_preset *frame;
      frame=(void *)buffer;
      frame->type=SET_PRESET;
      len=sizeof(frame_use_preset);
      frame->switchno=atoi(argv[j])-1;
      frame->value=atoi(argv[j+1]);
      frame->crc=chksum(&(frame->type), len-2);
    }
    break;
    
    case MANUAL_MODE: {
    
      frame_xmit_command *frame;
      frame=(void *)buffer;
      frame->type=XMIT_COMMAND;
      len=sizeof(frame_xmit_command);
      frame->system=atoi(argv[j]);
      frame->hc=atoi(argv[j+1]);
      frame->hc2=atoi(argv[j+2]);
      frame->address=atoi(argv[j+3]);
      frame->value=atoi(argv[j+4]);
      if((argc==9)||(argc==11)) {
        frame->arg=atoi(argv[j+5]);
      }
      else
      {
        frame->arg=0;
      }
      frame->repeat=repeat; //anzahl der wiederholungen, mind. 1
      printf("system: %d\n", frame->system);
      printf("value: %d\n", frame->value);
      
      frame->crc=chksum(&(frame->type), len-2);
    }
    break;

  }  


    if(sendto(udp_sd, buffer, len, 0, (struct sockaddr *)&dest, sizeof(dest))<0) {
    printf("sendto error\n");
    exit(ERROR);
  }

  if(select(udp_sd+1, &rd_set, NULL, NULL, &timeout)>0) {
    len=recvfrom(udp_sd, buffer, 1500, 0, (struct sockaddr *)&dest, &dest_size);
    if(len<0) {
      printf("recvfrom error\n");
      exit(ERROR);
    }
    else {
      frame_error *frame;
      frame=(frame_error *)buffer;
      if( (frame->crc==chksum(&(frame->type), len-2)) && (frame->errortype==0)) {
	printf("ok\n");
      }
      else {
	printf("bad response\n"); 
	exit(ERROR);
      }
    }
  }
  else {
    printf("no response...\n");
    exit(ERROR);
  }
  
  
//  closesocket(udp_sd);
  shutdown (udp_sd,  SHUT_RDWR);

  return(0);
}
