#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    17.04.2007
# Author:      Roland Spitzer
#
# Last Update: 17.04.2007 13:07 erstellt
#              07.05.2007 03:17 v1.1.2 Zurcksichern status-files
#                                      nach rc511.automation
#              12.05.2007 11:27 v1.1.3 Start automation.sh eingebaut
#                               v1.1.3 Prfen ob Automation schon aktiv
#              12.08.2007 15:40 v1.1.4 IRTRANS ausgebaut Start/Stop ber
#                                      automation.txt (boot/shutdown)
#
# Starten automation
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

debug "start started" 

####################################################
# Prfen ob bereits aktiv, ansonsten beenden
####################################################

if [ -f /var/run/automation.pid ]
then
    /usr/bin/logger Automation already running
    log "Automation already running"
    exit $EXIT_SUCCESS
fi

####################################################
# Start logfile-adapter (type 3)
####################################################  

for host in `grep "^".*_type*=\"3\" $CONF | cut -f 1 -d '=' | sed 's/_type*$//;'`
do
    $BIN/logfile.sh $host &
done
log "Logfiles started"


####################################################
# Start Automation
#################################################### 

$BIN_ROOT/automation.sh >/dev/null 2>&1
log "Automation started"

####################################################
# Ende Start
####################################################

debug "start ready"
exit $EXIT_SUCCESS