#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
# Last Update:
#
# Skript waiting for online-/offline-Status
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen
####################################################

HOST=$1
WAIT=$2

if [ "$2" = "on" ]
then
    WAIT=1
fi
if [ "$2" = "off" ]
then
    WAIT=0
fi

debug "wait for $HOST Status: $WAIT started"

if [ $# -ne 2 ]
then
    echo "Aufruf $BASE Host 0/1 oder on/off"
    debug "Aufruf $BASE Host 0/1 oder on/off"
    exit $EXIT_ERROR
fi

if [ $WAIT -eq 0 -o $WAIT -eq 1 ]
then :
else exit $EXIT_ERROR
fi

####################################################
# Warten auf bestimmten Status
####################################################

boottime=`grep "^"$HOST"_boottime=" $CONF | cut -f 2 -d '"'`

if [ $boottime -gt 0 ]
then
    now=`date +%s`
    until=`expr $now + $boottime`

    while [ true ]
    do
           now=`date +%s`
           status=`grep "^status=" $WORK/pcs/$HOST | cut -f 2 -d '"'`
           if [ $now -gt $until -o  $status -eq $WAIT ]
           then
               break
           else
               sleep 5
           fi
    done
fi

if [ ! $status -eq $WAIT ]
then
    debug "wait for $HOST Status: $WAIT aborted"
    exit $EXIT_ERROR
fi

####################################################
# Ende Wait
####################################################

debug "wait for $HOST Status: $WAIT ready"
exit $EXIT_SUCCESS